/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.silicon.tile;

import buildcraft.api.core.EnumPipePart;
import buildcraft.api.mj.ILaserTarget;
import buildcraft.api.mj.MjAPI;
import buildcraft.api.recipes.IngredientStack;
import buildcraft.api.tiles.IDebuggable;
import buildcraft.api.tiles.TilesAPI;
import buildcraft.lib.misc.LocaleUtil;
import buildcraft.lib.misc.data.AverageLong;
import buildcraft.lib.net.PacketBufferBC;
import buildcraft.lib.tile.TileBC_Neptune;
import buildcraft.lib.tile.item.ItemHandlerSimple;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public abstract class TileLaserTableBase
extends TileBC_Neptune
implements ILaserTarget,
ITickable,
IDebuggable {
    private static final long MJ_FLOW_ROUND = MjAPI.MJ / 10L;
    private final AverageLong avgPower = new AverageLong(120);
    public long avgPowerClient;
    public long power;

    protected TileLaserTableBase() {
        this.caps.addCapabilityInstance(TilesAPI.CAP_HAS_WORK, () -> this.getTarget() > 0L, EnumPipePart.VALUES);
    }

    public abstract long getTarget();

    @Override
    public long getRequiredLaserPower() {
        return this.getTarget() - this.power;
    }

    @Override
    public long receiveLaserPower(long microJoules) {
        long received = Math.min(microJoules, this.getRequiredLaserPower());
        this.power += received;
        this.avgPower.push(received);
        return microJoules - received;
    }

    @Override
    public boolean isInvalidTarget() {
        return this.func_145837_r();
    }

    public void func_73660_a() {
        this.avgPower.tick();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.getTarget() <= 0L) {
            this.power = 0L;
            this.avgPower.clear();
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74772_a("power", this.power);
        return nbt;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.power = nbt.func_74763_f("power");
    }

    @Override
    public void writePayload(int id, PacketBufferBC buffer, Side side) {
        super.writePayload(id, buffer, side);
        if (side == Side.SERVER && id == NET_GUI_TICK) {
            buffer.writeLong(this.power);
            double avg = this.avgPower.getAverage();
            long pwrAvg = Math.round(avg);
            long div = pwrAvg / MJ_FLOW_ROUND;
            long mod = pwrAvg % MJ_FLOW_ROUND;
            int mj = (int)div + (mod > MJ_FLOW_ROUND / 2L ? 1 : 0);
            buffer.writeInt(mj);
        }
    }

    @Override
    public void readPayload(int id, PacketBufferBC buffer, Side side, MessageContext ctx) throws IOException {
        super.readPayload(id, buffer, side, ctx);
        if (side == Side.CLIENT && id == NET_GUI_TICK) {
            this.power = buffer.readLong();
            this.avgPowerClient = (long)buffer.readInt() * MJ_FLOW_ROUND;
        }
    }

    @Override
    public void getDebugInfo(List<String> left, List<String> right, EnumFacing side) {
        left.add("power - " + LocaleUtil.localizeMj(this.power));
        left.add("target - " + LocaleUtil.localizeMj(this.getTarget()));
    }

    protected boolean extract(ItemHandlerSimple inv, Collection<IngredientStack> items, boolean simulate, boolean precise) {
        AtomicLong remainingStacks = new AtomicLong(inv.stacks.stream().filter(stack -> !stack.func_190926_b()).count());
        boolean allItemsConsumed = items.stream().allMatch(definition -> {
            int remaining = definition.count;
            for (int i = 0; i < inv.getSlots() && remaining > 0; ++i) {
                ItemStack slotStack = inv.getStackInSlot(i);
                if (slotStack.func_190926_b() || !definition.ingredient.apply(slotStack)) continue;
                int spend = Math.min(remaining, slotStack.func_190916_E());
                remaining -= spend;
                if (simulate) continue;
                slotStack.func_190920_e(slotStack.func_190916_E() - spend);
                inv.setStackInSlot(i, slotStack);
            }
            if (remaining == 0) {
                remainingStacks.decrementAndGet();
                return true;
            }
            return false;
        });
        return allItemsConsumed && (!precise || remainingStacks.get() == 0L);
    }
}

