/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.client.model;

import buildcraft.lib.client.model.IModelCache;
import buildcraft.lib.client.model.ModelCache;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.block.model.BakedQuad;

public class ModelCacheJoiner<K>
implements IModelCache<K> {
    private final IModelCache<K> mainCache;
    private final ImmutableList<ModelKeyWrapper<K, ?>> modelKeyWrappers;

    public ModelCacheJoiner(List<ModelKeyWrapper<K, ?>> wrappers) {
        this.modelKeyWrappers = ImmutableList.copyOf(wrappers);
        this.mainCache = new ModelCache<Object>(this::load);
    }

    private List<BakedQuad> load(K key) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        for (ModelKeyWrapper wrapper : this.modelKeyWrappers) {
            quads.addAll(wrapper.getQuads(key));
        }
        return quads;
    }

    @Override
    public List<BakedQuad> bake(K key) {
        if (ModelCache.cacheJoined) {
            return this.mainCache.bake(key);
        }
        return this.load(key);
    }

    @Override
    public void clear() {
        this.mainCache.clear();
        for (ModelKeyWrapper wrapper : this.modelKeyWrappers) {
            wrapper.cache.clear();
        }
    }

    public static interface IModelKeyMapper<F, T> {
        public T getInternKey(F var1);
    }

    public static class ModelKeyWrapper<K, T> {
        private final IModelKeyMapper<K, T> mapper;
        private final IModelCache<T> cache;

        public ModelKeyWrapper(IModelKeyMapper<K, T> mapper, ModelCache.IModelGenerator<T> generator) {
            this.mapper = mapper;
            this.cache = new ModelCache<T>(generator);
        }

        public ModelKeyWrapper(IModelKeyMapper<K, T> mapper, IModelCache<T> cache) {
            this.mapper = mapper;
            this.cache = cache;
        }

        public List<BakedQuad> getQuads(K key) {
            return this.cache.bake(this.mapper.getInternKey(key));
        }
    }
}

