/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders.snapshot;

import buildcraft.api.core.InvalidInputDataException;
import buildcraft.api.schematics.ISchematicBlock;
import buildcraft.api.schematics.SchematicBlockContext;
import buildcraft.builders.snapshot.SchematicBlockManager;
import buildcraft.lib.misc.BlockUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;

public class SchematicBlockFluid
implements ISchematicBlock {
    private IBlockState blockState;
    private boolean isFlowing;

    public static boolean predicate(SchematicBlockContext context) {
        return BlockUtil.getFluidWithFlowing(context.world, context.pos) != null && (BlockUtil.getFluid(context.world, context.pos) == null || BlockUtil.getFluidWithoutFlowing(context.world.func_180495_p(context.pos)) != null);
    }

    @Override
    public void init(SchematicBlockContext context) {
        this.blockState = context.blockState;
        this.isFlowing = BlockUtil.getFluid(context.world, context.pos) == null;
    }

    @Override
    @Nonnull
    public Set<BlockPos> getRequiredBlockOffsets() {
        return Stream.concat(Arrays.stream(EnumFacing.field_176754_o), Stream.of(EnumFacing.DOWN)).map(EnumFacing::func_176730_m).map(BlockPos::new).collect(Collectors.toSet());
    }

    @Override
    @Nonnull
    public List<FluidStack> computeRequiredFluids() {
        return Optional.ofNullable(BlockUtil.getFluidWithoutFlowing(this.blockState)).map(fluid -> new FluidStack(fluid, 1000)).map(Collections::singletonList).orElseGet(Collections::emptyList);
    }

    @Override
    public SchematicBlockFluid getRotated(Rotation rotation) {
        SchematicBlockFluid schematicBlock = SchematicBlockManager.createCleanCopy(this);
        schematicBlock.blockState = this.blockState;
        schematicBlock.isFlowing = this.isFlowing;
        return schematicBlock;
    }

    @Override
    public boolean canBuild(World world, BlockPos blockPos) {
        return world.func_175623_d(blockPos) || BlockUtil.getFluidWithFlowing(world, blockPos) == BlockUtil.getFluidWithFlowing(this.blockState.func_177230_c()) && BlockUtil.getFluid(world, blockPos) == null;
    }

    @Override
    public boolean build(World world, BlockPos blockPos) {
        if (this.isFlowing) {
            return true;
        }
        if (world.func_180501_a(blockPos, this.blockState, 11)) {
            Stream.concat(Stream.of(EnumFacing.field_82609_l).map(EnumFacing::func_176730_m).map(BlockPos::new), Stream.of(BlockPos.field_177992_a)).map(arg_0 -> ((BlockPos)blockPos).func_177971_a(arg_0)).forEach(updatePos -> world.func_175685_c(updatePos, this.blockState.func_177230_c(), false));
            return true;
        }
        return false;
    }

    @Override
    public boolean buildWithoutChecks(World world, BlockPos blockPos) {
        return world.func_180501_a(blockPos, this.blockState, 0);
    }

    @Override
    public boolean isBuilt(World world, BlockPos blockPos) {
        return this.isFlowing || BlockUtil.blockStatesEqual(this.blockState, world.func_180495_p(blockPos));
    }

    @Override
    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74782_a("blockState", (NBTBase)NBTUtil.func_190009_a((NBTTagCompound)new NBTTagCompound(), (IBlockState)this.blockState));
        nbt.func_74757_a("isFlowing", this.isFlowing);
        return nbt;
    }

    @Override
    public void deserializeNBT(NBTTagCompound nbt) throws InvalidInputDataException {
        this.blockState = NBTUtil.func_190008_d((NBTTagCompound)nbt.func_74775_l("blockState"));
        this.isFlowing = nbt.func_74767_n("isFlowing");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SchematicBlockFluid that = (SchematicBlockFluid)o;
        return this.isFlowing == that.isFlowing && this.blockState.equals(that.blockState);
    }

    public int hashCode() {
        int result = this.blockState.hashCode();
        result = 31 * result + (this.isFlowing ? 1 : 0);
        return result;
    }
}

