/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.api.inventory;

import buildcraft.api.core.IStackFilter;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;

public interface IItemTransactor {
    @Nonnull
    public ItemStack insert(@Nonnull ItemStack var1, boolean var2, boolean var3);

    default public NonNullList<ItemStack> insert(NonNullList<ItemStack> stacks, boolean simulate) {
        NonNullList leftOver = NonNullList.func_191196_a();
        for (ItemStack stack : stacks) {
            ItemStack leftOverStack = this.insert(stack, false, simulate);
            if (leftOverStack.func_190926_b()) continue;
            leftOver.add((Object)leftOverStack);
        }
        return leftOver;
    }

    @Nonnull
    public ItemStack extract(@Nullable IStackFilter var1, int var2, int var3, boolean var4);

    default public boolean canFullyAccept(@Nonnull ItemStack stack) {
        return this.insert(stack, true, true).func_190926_b();
    }

    default public boolean canPartiallyAccept(@Nonnull ItemStack stack) {
        return this.insert(stack, false, true).func_190916_E() < stack.func_190916_E();
    }

    @FunctionalInterface
    public static interface IItemExtractable
    extends IItemTransactor {
        @Override
        @Nonnull
        default public ItemStack insert(@Nonnull ItemStack stack, boolean allOrNone, boolean simulate) {
            return stack;
        }
    }

    @FunctionalInterface
    public static interface IItemInsertable
    extends IItemTransactor {
        @Override
        @Nonnull
        default public ItemStack extract(IStackFilter filter, int min, int max, boolean simulate) {
            return ItemStack.field_190927_a;
        }
    }
}

