/*
 * Decompiled with CFR 0.152.
 */
package zone.rong.loliasm.common.modfixes.qmd;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import zone.rong.loliasm.LoliReflector;

public class QMDEventHandler {
    private static final List<WeakReference<Entity>> beamsInWorld = new ArrayList<WeakReference<Entity>>(1);
    private static final Class<?> projectileClass = LoliReflector.getClass("lach_01298.qmd.entity.EntityBeamProjectile").get();

    @SubscribeEvent
    public static void onBeamSpawn(EntityJoinWorldEvent event) {
        if (projectileClass.isInstance(event.getEntity())) {
            beamsInWorld.add(new WeakReference<Entity>(event.getEntity()));
        }
    }

    @SubscribeEvent
    public static void onRenderWorldLast(RenderWorldLastEvent event) {
        if (beamsInWorld.isEmpty()) {
            return;
        }
        ListIterator<WeakReference<Entity>> iterator = beamsInWorld.listIterator();
        float partialTicks = event.getPartialTicks();
        double bx = 0.0;
        double by = 0.0;
        double bz = 0.0;
        double rx = 0.0;
        double ry = 0.0;
        double rz = 0.0;
        float br = 0.0f;
        boolean calculated = false;
        while (iterator.hasNext()) {
            Entity entity = (Entity)((WeakReference)iterator.next()).get();
            if (entity == null || entity.field_70128_L) {
                iterator.remove();
                continue;
            }
            RenderManager renderManager = Minecraft.func_71410_x().func_175598_ae();
            Entity renderEntity = renderManager.field_78734_h;
            if (!(renderEntity.func_70068_e(entity) <= 16384.0)) continue;
            if (!calculated) {
                bx = entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * (double)partialTicks;
                by = entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)partialTicks;
                bz = entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * (double)partialTicks;
                br = entity.field_70126_B + (entity.field_70177_z - entity.field_70126_B) * partialTicks;
                rx = renderEntity.field_70142_S + (renderEntity.field_70165_t - renderEntity.field_70142_S) * (double)partialTicks;
                ry = renderEntity.field_70137_T + (renderEntity.field_70163_u - renderEntity.field_70137_T) * (double)partialTicks;
                rz = renderEntity.field_70136_U + (renderEntity.field_70161_v - renderEntity.field_70136_U) * (double)partialTicks;
                calculated = true;
            }
            renderManager.func_78715_a(entity.getClass()).func_76986_a(entity, bx - rx, by - ry, bz - rz, br, partialTicks);
        }
    }
}

