/*
 * Decompiled with CFR 0.152.
 */
package zone.rong.loliasm.common.capability.mixins;

import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityDispatcher;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.registries.IRegistryDelegate;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import zone.rong.loliasm.api.IItemStackCapabilityDelayer;

@Mixin(value={ItemStack.class})
public abstract class ItemStackMixin
implements IItemStackCapabilityDelayer {
    @Shadow
    private boolean field_190928_g;
    @Shadow
    private int field_77994_a;
    @Shadow
    int field_77991_e;
    @Shadow
    private NBTTagCompound field_77990_d;
    @Shadow(remap=false)
    private CapabilityDispatcher capabilities;
    @Shadow(remap=false)
    private NBTTagCompound capNBT;
    @Shadow(remap=false)
    private IRegistryDelegate<Item> delegate;
    @Unique
    private boolean initializedCapabilities = false;

    @Shadow
    public abstract Item func_77973_b();

    @Shadow
    public abstract int func_190921_D();

    @Shadow(remap=false)
    @Nullable
    protected abstract Item getItemRaw();

    @Override
    public boolean hasInitializedCapabilities() {
        return this.initializedCapabilities;
    }

    @Override
    public void initializeCapabilities() {
        if (this.initializedCapabilities) {
            return;
        }
        this.initializedCapabilities = true;
        Item item = this.getItemRaw();
        if (item != null) {
            this.capabilities = ForgeEventFactory.gatherCapabilities((ItemStack)((ItemStack)this), (ICapabilityProvider)item.initCapabilities((ItemStack)this, this.capNBT));
            if (this.capNBT != null && this.capabilities != null) {
                this.capabilities.deserializeNBT(this.capNBT);
            }
        }
    }

    @Overwrite
    public ItemStack func_77946_l() {
        ItemStack stack = new ItemStack(this.func_77973_b(), this.field_77994_a, this.field_77991_e, this.capabilities != null ? this.capabilities.serializeNBT() : this.capNBT);
        stack.func_190915_d(this.func_190921_D());
        if (this.field_77990_d != null) {
            ((ItemStackMixin)stack).field_77990_d = this.field_77990_d.func_74737_b();
        }
        return stack;
    }

    @Overwrite(remap=false)
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (this.field_190928_g) {
            return false;
        }
        if (!this.initializedCapabilities) {
            this.initializeCapabilities();
        }
        return this.capabilities != null && this.capabilities.hasCapability(capability, facing);
    }

    @Nullable
    @Overwrite(remap=false)
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (this.field_190928_g) {
            return null;
        }
        if (!this.initializedCapabilities) {
            this.initializeCapabilities();
        }
        return (T)(this.capabilities == null ? null : this.capabilities.getCapability(capability, facing));
    }

    @Overwrite(remap=false)
    public boolean areCapsCompatible(ItemStack other) {
        if (!this.initializedCapabilities) {
            this.initializeCapabilities();
        }
        if (!((ItemStackMixin)other).initializedCapabilities) {
            ((ItemStackMixin)other).initializeCapabilities();
        }
        if (this.capabilities == null) {
            return ((ItemStackMixin)other).capabilities == null || ((ItemStackMixin)other).capabilities.areCompatible(null);
        }
        return this.capabilities.areCompatible(((ItemStackMixin)other).capabilities);
    }

    @Overwrite(remap=false)
    private void forgeInit() {
        Item item = this.getItemRaw();
        if (item != null) {
            this.delegate = item.delegate;
        }
    }
}

