/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.lib.tweak.enchantment;

import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import pl.asie.lib.AsieLibMod;
import pl.asie.lib.tweak.enchantment.EnchantmentBetterBane;
import pl.asie.lib.util.RayTracer;

public class EnchantmentTweak {
    public static EnchantmentBetterBane bane;

    public static void registerBaneEnchantment(int enchID) {
        if (enchID >= 0 && enchID < 256) {
            bane = new EnchantmentBetterBane();
            if (Enchantment.func_185262_c((int)enchID) == null) {
                Enchantment.field_185264_b.func_177775_a(244, (Object)new ResourceLocation("bane_of_arthropods_better"), (Object)bane);
                return;
            }
            for (int i = enchID; i < 256; ++i) {
                if (Enchantment.func_185262_c((int)i) != null) continue;
                AsieLibMod.log.info("Enchantment ID " + enchID + " already occupied, using " + i + " instead");
                Enchantment.field_185264_b.func_177775_a(i, (Object)new ResourceLocation("bane_of_arthropods_better"), (Object)bane);
                return;
            }
        }
        throw new IllegalArgumentException("No valid enchantment id! " + EnchantmentBetterBane.class + " Enchantment ID:" + enchID);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void anvilEvent(AnvilUpdateEvent e) {
        if (e.getLeft().func_190926_b() || e.getRight().func_190926_b() || e.isCanceled()) {
            return;
        }
        if (e.getLeft().func_77984_f() && e.getLeft().func_77948_v() && e.getRight().func_77973_b() == Items.field_151071_bq && !EnchantmentTweak.hasBaneEnchantment(e.getLeft())) {
            if (e.getRight().func_190916_E() == e.getRight().func_77976_d()) {
                e.setOutput(e.getLeft().func_77946_l());
                e.setCost(37);
                if (!EnchantmentTweak.addBaneEnchantment(e.getOutput(), 9)) {
                    e.setOutput(ItemStack.field_190927_a);
                    if (e.isCancelable()) {
                        e.setCanceled(true);
                    }
                }
            } else {
                e.setOutput(ItemStack.field_190927_a);
                if (e.isCancelable()) {
                    e.setCanceled(true);
                }
            }
        }
    }

    @SubscribeEvent
    public void enchEvent(TickEvent.PlayerTickEvent e) {
        EntityPlayer player = e.player;
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        if (!player.func_184614_ca().func_190926_b() && EnchantmentTweak.hasBaneEnchantment(player.func_184614_ca()) && player.func_184614_ca().func_77984_f()) {
            Entity entity;
            RayTracer.instance().fire((EntityLivingBase)player, 10.0);
            RayTraceResult target = RayTracer.instance().getTarget();
            if (target != null && target.field_72313_a == RayTraceResult.Type.ENTITY && (entity = target.field_72308_g) != null && entity instanceof EntityLivingBase && ((EntityLivingBase)entity).func_70668_bt() == EnumCreatureAttribute.ARTHROPOD && entity.field_70172_ad <= 10 && !player.func_184585_cz()) {
                player.func_71059_n(entity);
                if (player.func_184614_ca().func_77984_f()) {
                    float distance = player.func_70032_d(entity);
                    int damage = Math.max(Math.min((int)distance + 1, 10), 1);
                    player.func_184614_ca().func_77972_a(damage, (EntityLivingBase)player);
                }
            }
        }
    }

    private static boolean hasBaneEnchantment(ItemStack stack) {
        if (stack.func_77978_p() == null || stack.func_77978_p().func_82582_d()) {
            return false;
        }
        if (!stack.func_77978_p().func_150297_b("ench", 9)) {
            return false;
        }
        NBTTagList list = stack.func_77978_p().func_150295_c("ench", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound tag = list.func_150305_b(i);
            if (tag.func_74765_d("id") != Enchantment.func_185258_b((Enchantment)bane)) continue;
            return true;
        }
        return false;
    }

    private static boolean addBaneEnchantment(ItemStack stack, int level) {
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (!stack.func_77978_p().func_150297_b("ench", 9)) {
            stack.func_77978_p().func_74782_a("ench", (NBTBase)new NBTTagList());
        }
        NBTTagList list = stack.func_77978_p().func_150295_c("ench", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound tag = list.func_150305_b(i);
            if (tag.func_74765_d("id") != Enchantment.func_185258_b((Enchantment)Enchantments.field_180312_n) || tag.func_74765_d("lvl") != 5) continue;
            list.func_74744_a(i);
            NBTTagCompound data = new NBTTagCompound();
            data.func_74777_a("id", (short)Enchantment.func_185258_b((Enchantment)bane));
            data.func_74777_a("lvl", (short)((byte)level));
            list.func_74742_a((NBTBase)data);
            return true;
        }
        return false;
    }
}

