/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.tape;

import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.asie.computronics.Computronics;
import pl.asie.computronics.integration.conventional.IntegrationConventional;
import pl.asie.computronics.item.ItemPortableTapeDrive;
import pl.asie.computronics.network.PacketType;
import pl.asie.computronics.reference.Mods;
import pl.asie.computronics.tape.PortableDriveManager;
import pl.asie.computronics.tape.PortableTapeDrive;
import pl.asie.computronics.tile.TapeDriveState;

@SideOnly(value=Side.CLIENT)
public class TapeScrollEventHandler {
    @SubscribeEvent
    public void onMouseEvent(MouseEvent event) {
        Item item;
        ItemStack stack;
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (event.getDwheel() != 0 && player != null && player.func_70093_af() && !(stack = player.func_184614_ca()).func_190926_b() && (item = stack.func_77973_b()) instanceof ItemPortableTapeDrive) {
            if (Mods.isLoaded("conventional") && IntegrationConventional.INSTANCE.isDenied("computronics:tapescroll", (EntityPlayer)player)) {
                event.setCanceled(true);
                return;
            }
            TapeScrollEventHandler.scrollTapeDrive(stack, (EntityPlayer)player, event.getDwheel());
            event.setCanceled(true);
        }
    }

    public static void scrollTapeDrive(ItemStack stack, EntityPlayer player, int dWheel) {
        PortableTapeDrive tapeDrive = PortableDriveManager.INSTANCE.getOrCreate(stack, true);
        TapeDriveState.State state = tapeDrive.getEnumState();
        TapeDriveState.State newState = null;
        switch (state) {
            case STOPPED: 
            case PLAYING: {
                newState = dWheel < 0 ? TapeDriveState.State.REWINDING : TapeDriveState.State.FORWARDING;
                break;
            }
            case FORWARDING: {
                newState = dWheel < 0 ? TapeDriveState.State.STOPPED : null;
                break;
            }
            case REWINDING: {
                newState = dWheel > 0 ? TapeDriveState.State.STOPPED : null;
            }
        }
        String id = PortableDriveManager.INSTANCE.getID(tapeDrive, true);
        if (newState != null && id != null) {
            try {
                Computronics.packet.sendToServer(Computronics.packet.create(PacketType.PORTABLE_TAPE_STATE.ordinal()).writeString(id).writeByte((byte)newState.ordinal()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

