/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.integration.railcraft.item;

import java.util.List;
import javax.annotation.Nullable;
import mods.railcraft.common.carts.EntityLocomotive;
import mods.railcraft.common.carts.EntityLocomotiveElectric;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.asie.computronics.Computronics;
import pl.asie.computronics.integration.railcraft.tile.TileLocomotiveRelay;
import pl.asie.computronics.oc.manual.IItemWithPrefix;
import pl.asie.computronics.reference.Config;
import pl.asie.computronics.util.StringUtil;

public class ItemRelaySensor
extends Item
implements IItemWithPrefix {
    public ItemRelaySensor() {
        this.func_77637_a(Computronics.tab);
        this.func_77627_a(false);
        this.func_77655_b("computronics.relaySensor");
        this.func_77656_e(0);
        this.func_77625_d(1);
        this.func_77664_n();
        this.setNoRepair();
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        if (player.field_70170_p.field_72995_K) {
            return EnumActionResult.PASS;
        }
        ItemStack stack = player.func_184586_b(hand);
        TileEntity tile = world.func_175625_s(pos);
        if (player.func_70093_af() && tile instanceof TileLocomotiveRelay) {
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            if (stack.func_77942_o()) {
                NBTTagCompound data = stack.func_77978_p();
                data.func_74768_a("relayX", pos.func_177958_n());
                data.func_74768_a("relayY", pos.func_177956_o());
                data.func_74768_a("relayZ", pos.func_177952_p());
                data.func_74757_a("bound", true);
                stack.func_77982_d(data);
                player.func_184609_a(hand);
                return EnumActionResult.SUCCESS;
            }
        }
        return EnumActionResult.FAIL;
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        if (player.func_70093_af() && entity != null) {
            if (stack.func_77942_o() && stack.func_77978_p().func_74767_n("bound") && !player.field_70170_p.field_72995_K) {
                NBTTagCompound data = stack.func_77978_p();
                BlockPos pos = new BlockPos(data.func_74762_e("relayX"), data.func_74762_e("relayY"), data.func_74762_e("relayZ"));
                if (entity instanceof EntityLocomotiveElectric) {
                    if (!player.field_70170_p.func_175667_e(pos)) {
                        player.func_145747_a((ITextComponent)new TextComponentTranslation("chat.computronics.sensor.noRelayDetected", new Object[0]));
                        return true;
                    }
                    TileEntity tile = entity.field_70170_p.func_175625_s(pos);
                    if (tile != null && tile instanceof TileLocomotiveRelay) {
                        TileLocomotiveRelay relay = (TileLocomotiveRelay)tile;
                        EntityLocomotiveElectric loco = (EntityLocomotiveElectric)entity;
                        if (loco.field_71093_bK == relay.func_145831_w().field_73011_w.getDimension()) {
                            if (loco.func_174818_b(relay.func_174877_v()) <= Config.LOCOMOTIVE_RELAY_RANGE * Config.LOCOMOTIVE_RELAY_RANGE) {
                                relay.setLocomotive(loco);
                                player.func_145747_a((ITextComponent)new TextComponentTranslation("chat.computronics.sensor.bound", new Object[0]));
                                player.func_184609_a(EnumHand.MAIN_HAND);
                                player.func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
                                ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)player, (ItemStack)stack, (EnumHand)EnumHand.MAIN_HAND);
                            } else {
                                player.func_145747_a((ITextComponent)new TextComponentTranslation("chat.computronics.sensor.tooFarAway", new Object[0]));
                            }
                        } else {
                            player.func_145747_a((ITextComponent)new TextComponentTranslation("chat.computronics.sensor.wrongDim", new Object[0]));
                        }
                    } else {
                        player.func_145747_a((ITextComponent)new TextComponentTranslation("chat.computronics.sensor.noRelay", new Object[0]));
                    }
                } else if (entity instanceof EntityLocomotive) {
                    player.func_145747_a((ITextComponent)new TextComponentTranslation("chat.computronics.sensor.wrongLoco", new Object[0]));
                    return true;
                }
            }
            return true;
        }
        return false;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> text, ITooltipFlag flagIn) {
        String[] local;
        String descKey;
        if (stack.func_77942_o() && stack.func_77978_p().func_74767_n("bound")) {
            NBTTagCompound data = stack.func_77978_p();
            int x = data.func_74762_e("relayX");
            int y = data.func_74762_e("relayY");
            int z = data.func_74762_e("relayZ");
            text.add(TextFormatting.AQUA + StringUtil.localizeAndFormat("tooltip.computronics.sensor.bound", String.valueOf(x), String.valueOf(y), String.valueOf(z)));
            descKey = "tooltip.computronics.sensor.desc2";
        } else {
            descKey = "tooltip.computronics.sensor.desc1";
        }
        for (String s : local = StringUtil.localize(descKey).split("\n")) {
            text.add(TextFormatting.GRAY + s);
        }
    }

    @Override
    public String getDocumentationName(ItemStack stack) {
        return "relay_sensor";
    }

    @Override
    public String getPrefix(ItemStack stack) {
        return "railcraft/";
    }

    @SideOnly(value=Side.CLIENT)
    public static class MeshDefinition
    implements ItemMeshDefinition {
        private final ModelResourceLocation icon_off = new ModelResourceLocation("computronics:relay_sensor_off", "inventory");
        private final ModelResourceLocation icon_on = new ModelResourceLocation("computronics:relay_sensor_on", "inventory");

        public ModelResourceLocation func_178113_a(ItemStack stack) {
            if (stack.func_77942_o() && stack.func_77978_p().func_74767_n("bound")) {
                return this.icon_on;
            }
            return this.icon_off;
        }
    }
}

