/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.integration.railcraft.gui.container;

import com.mojang.authlib.GameProfile;
import javax.annotation.Nullable;
import mods.railcraft.common.gui.containers.RailcraftContainer;
import mods.railcraft.common.gui.slots.SlotOutput;
import mods.railcraft.common.gui.slots.SlotSecure;
import mods.railcraft.common.gui.widgets.AnalogWidget;
import mods.railcraft.common.gui.widgets.ChargeNetworkIndicator;
import mods.railcraft.common.gui.widgets.IIndicatorController;
import mods.railcraft.common.gui.widgets.Widget;
import mods.railcraft.common.items.ItemTicketGold;
import mods.railcraft.common.plugins.forge.PlayerPlugin;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.asie.computronics.integration.railcraft.gui.slot.PaperSlotFilter;
import pl.asie.computronics.integration.railcraft.gui.slot.SlotSecureInput;
import pl.asie.computronics.integration.railcraft.gui.widget.LockButtonWidget;
import pl.asie.computronics.integration.railcraft.gui.widget.PrintButtonWidget;
import pl.asie.computronics.integration.railcraft.gui.widget.ProgressBarWidget;
import pl.asie.computronics.integration.railcraft.gui.widget.SlotSelectionWidget;
import pl.asie.computronics.integration.railcraft.tile.TileTicketMachine;
import pl.asie.computronics.reference.Config;

public class ContainerTicketMachine
extends RailcraftContainer {
    private final InventoryPlayer inventoryPlayer;
    private TileTicketMachine tile;
    private boolean maintenanceMode = false;
    private boolean isSelectLocked = true;
    public boolean canLock;
    private int lastEnergy;
    private int lastProgress;

    public ContainerTicketMachine(InventoryPlayer inventoryPlayer, TileTicketMachine tile, boolean maintenanceMode) {
        super((IInventory)inventoryPlayer);
        int j;
        int i;
        this.inventoryPlayer = inventoryPlayer;
        this.tile = tile;
        this.maintenanceMode = maintenanceMode;
        this.addWidget(new PrintButtonWidget(tile, 67, 54, 0, 168, 20, 16));
        this.addWidget(new SlotSelectionWidget(tile, 33, 15, 184, 0, 88, 34, maintenanceMode));
        if (Config.TICKET_MACHINE_CONSUME_CHARGE) {
            this.addWidget(new Widget(92, 54, 178, 40, 30, 16));
            this.addWidget((Widget)new AnalogWidget((IIndicatorController)new ChargeNetworkIndicator(tile.func_145831_w(), tile.func_174877_v()), 93, 55, 28, 14, 105, 66, 191, 52));
        }
        this.addWidget(new ProgressBarWidget(tile, 136, 34, 208, 25, 10, 13));
        if (maintenanceMode) {
            this.addWidget(new LockButtonWidget(tile, 6, 6, 224, 0, 16, 16, true));
        } else {
            this.addWidget(new LockButtonWidget(tile, 6, 6, 224, 0, 16, 16, false));
        }
        for (i = 0; i < 5; ++i) {
            this.addSlot((Slot)new SlotSecure(ItemTicketGold.FILTER, (IInventory)tile, i, 33 + i * 18, 15));
        }
        for (i = 0; i < 5; ++i) {
            this.addSlot((Slot)new SlotSecure(ItemTicketGold.FILTER, (IInventory)tile, i + 5, 33 + i * 18, 33));
        }
        this.addSlot((Slot)new SlotSecureInput(PaperSlotFilter.FILTER, (IInventory)tile, 10, 133, 15));
        this.addSlot((Slot)new SlotOutput((IInventory)tile, 11, 133, 54));
        for (j = 0; j < 3; ++j) {
            for (int k = 0; k < 9; ++k) {
                this.addSlot(new Slot((IInventory)inventoryPlayer, k + j * 9 + 9, 8 + k * 18, 84 + j * 18));
            }
        }
        for (j = 0; j < 9; ++j) {
            this.addSlot(new Slot((IInventory)inventoryPlayer, j, 8 + j * 18, 142));
        }
        this.setTicketsAndPaperLocked(!this.maintenanceMode());
    }

    public boolean maintenanceMode() {
        return this.maintenanceMode;
    }

    @Nullable
    public ItemStack func_184996_a(int slotId, int mouseButton, ClickType clickType, EntityPlayer player) {
        if (!this.maintenanceMode()) {
            this.setTicketsAndPaperLocked(true);
        } else {
            this.setTicketsAndPaperLocked(false);
        }
        return super.func_184996_a(slotId, mouseButton, clickType, player);
    }

    public void setTicketsAndPaperLocked(boolean locked) {
        if (this.isSelectLocked == locked) {
            return;
        }
        for (int i = 0; i <= 10; ++i) {
            Object slot = this.field_75151_b.get(i);
            if (!(slot instanceof SlotSecure)) continue;
            ((SlotSecure)slot).locked = locked;
        }
        this.isSelectLocked = locked;
    }

    public InventoryPlayer getInventoryPlayer() {
        return this.inventoryPlayer;
    }

    private void updateLock() {
        for (Widget widget : this.getWidgets()) {
            if (!(widget instanceof LockButtonWidget)) continue;
            ((LockButtonWidget)widget).accessible = this.maintenanceMode() && this.canLock;
        }
    }

    public void sendUpdateToClient() {
        super.sendUpdateToClient();
        for (IContainerListener listener : this.field_75149_d) {
            if (this.lastProgress == this.tile.getProgress()) continue;
            listener.func_71112_a((Container)this, 1, this.tile.getProgress());
        }
        this.lastProgress = this.tile.getProgress();
        this.lastEnergy = this.tile.getEnergyStored(null);
    }

    public void func_75132_a(IContainerListener listener) {
        super.func_75132_a(listener);
        this.canLock = PlayerPlugin.isOwnerOrOp((GameProfile)this.tile.getOwner(), (GameProfile)this.inventoryPlayer.field_70458_d.func_146103_bH());
        this.updateLock();
        listener.func_71112_a((Container)this, 0, this.canLock ? 1 : 0);
        listener.func_71112_a((Container)this, 1, this.tile.getProgress());
    }

    @SideOnly(value=Side.CLIENT)
    public void func_75137_b(int id, int value) {
        super.func_75137_b(id, value);
        switch (id) {
            case 0: {
                this.canLock = value == 1;
                this.updateLock();
                break;
            }
            case 1: {
                this.tile.setProgress(value);
            }
        }
    }

    public boolean func_75145_c(EntityPlayer playerIn) {
        return this.tile.func_70300_a(playerIn);
    }
}

