/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.client.gui.button;

import com.enderio.core.api.client.gui.IGuiOverlay;
import com.enderio.core.api.client.gui.IGuiScreen;
import com.enderio.core.api.client.render.IWidgetIcon;
import com.enderio.core.client.gui.GuiContainerBase;
import com.enderio.core.client.gui.button.IconButton;
import com.enderio.core.client.render.ColorUtil;
import com.enderio.core.client.render.EnderWidget;
import com.enderio.core.client.render.RenderUtil;
import com.enderio.core.common.util.NNList;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.input.Mouse;

public class CycleButton<T extends Enum<T>>
extends IconButton {
    @Nonnull
    private final NNList<T> modes;
    @Nullable
    private T mode;
    private boolean isOpened = true;
    private PickerOverlay overlay;

    public CycleButton(@Nonnull IGuiScreen gui, int id, int x, int y, @Nonnull Class<T> enumClass) {
        super(gui, id, x, y, null);
        this.modes = NNList.of(enumClass);
        this.overlay = new PickerOverlay(this);
        ((GuiContainerBase)gui).addOverlay(this.overlay);
    }

    @Override
    public void onGuiInit() {
        super.onGuiInit();
        if (this.mode == null) {
            this.setMode((Enum)this.modes.get(0));
            this.setIcon(((ICycleEnum)this.getMode()).getIcon());
        }
    }

    @Override
    public boolean mousePressedButton(@Nonnull Minecraft mc, int mouseX, int mouseY, int button) {
        boolean result = super.mousePressedButton(mc, mouseX, mouseY, button);
        if (result) {
            this.overlay.setIsVisible(!this.overlay.isVisible());
        }
        return result;
    }

    public void setMode(@Nonnull T newMode) {
        if (this.mode != newMode) {
            this.mode = newMode;
            List<String> tooltip = ((ICycleEnum)newMode).getTooltipLines();
            this.setToolTip(tooltip.toArray(new String[tooltip.size()]));
            this.icon = ((ICycleEnum)newMode).getIcon();
        }
    }

    @Nonnull
    public T getMode() {
        return (T)(this.mode != null ? this.mode : (Enum)this.modes.get(0));
    }

    class PickerOverlay
    implements IGuiOverlay {
        CycleButton cycleButton;
        Rectangle bounds = new Rectangle(0, 0, 0, 0);
        List<Pair<Rectangle, T>> modes = new ArrayList();
        boolean visible;
        int rows = 0;
        int cols = 0;
        int yOffset = 0;
        int xOffset = 0;
        int width = 0;
        int height = 0;

        public PickerOverlay(CycleButton cycleButton) {
            this.cycleButton = cycleButton;
            int clrIndex = 0;
            while (this.rows * this.cols < cycleButton.modes.size()) {
                if ((this.cols + 1) * this.rows >= cycleButton.modes.size()) {
                    ++this.cols;
                    continue;
                }
                if ((this.rows + 1) * this.cols >= cycleButton.modes.size()) {
                    ++this.rows;
                    continue;
                }
                if (this.cols > this.rows) {
                    ++this.rows;
                    continue;
                }
                ++this.cols;
            }
            this.yOffset = cycleButton.yOrigin + cycleButton.field_146121_g;
            this.xOffset = cycleButton.xOrigin;
            this.width = 17 * this.cols + 4;
            this.height = 17 * this.rows + 4;
            this.setBounds(new Rectangle(this.xOffset, this.yOffset, this.width, this.height));
            for (int r = 0; r < this.rows; ++r) {
                for (int c = 0; c < this.cols; ++c) {
                    if (clrIndex >= cycleButton.modes.size()) continue;
                    this.modes.add(Pair.of((Object)new Rectangle(17 * c, 3 + 17 * r, 17, 17), (Object)((Enum)cycleButton.modes.get(clrIndex))));
                    ++clrIndex;
                }
            }
        }

        @Override
        public void init(@Nonnull IGuiScreen screen) {
        }

        @Override
        @Nonnull
        public Rectangle getBounds() {
            return this.bounds;
        }

        public void setBounds(Rectangle bounds) {
            this.bounds = bounds;
        }

        @Override
        public void draw(int mouseX, int mouseY, float partialTick) {
            RenderHelper.func_74520_c();
            GlStateManager.func_179126_j();
            if (CycleButton.this.isOpened) {
                for (Pair pair : this.modes) {
                    IWidgetIcon icon = ((ICycleEnum)((Object)((Enum)pair.getRight()))).getIcon();
                    if (this.cycleButton.getMode() == pair.getRight()) {
                        this.setBounds(new Rectangle(this.cycleButton.xOrigin - ((Rectangle)pair.getLeft()).x, this.cycleButton.yOrigin - ((Rectangle)pair.getLeft()).y, this.width, this.height));
                        EnderWidget.BUTTON_DOWN_HIGHLIGHT.getMap().render((IWidgetIcon)EnderWidget.BUTTON_DOWN_HIGHLIGHT, (double)(this.getBounds().x + ((Rectangle)pair.getLeft()).x), (double)(this.getBounds().y + ((Rectangle)pair.getLeft()).y), 390.0, true);
                    } else {
                        EnderWidget.BUTTON.getMap().render((IWidgetIcon)EnderWidget.BUTTON, (double)(this.getBounds().x + ((Rectangle)pair.getLeft()).x), (double)(this.getBounds().y + ((Rectangle)pair.getLeft()).y), 390.0, true);
                    }
                    icon.getMap().render(icon, (double)(this.getBounds().x + ((Rectangle)pair.getLeft()).x), (double)(this.getBounds().y + ((Rectangle)pair.getLeft()).y), 400.0, true);
                }
                RenderUtil.renderQuad2D((double)(this.getBounds().x - 2), (double)(this.getBounds().y + 1), 300.0, (double)(this.width - 1), (double)(this.height - 1), ColorUtil.getRGB(Color.DARK_GRAY));
                RenderUtil.renderQuad2D((double)(this.getBounds().x - 1), (double)(this.getBounds().y + 2), 300.0, (double)(this.width - 3), (double)(this.height - 3), ColorUtil.getRGB(Color.GRAY));
            }
        }

        @Override
        public void setIsVisible(boolean visible) {
            this.visible = visible;
        }

        @Override
        public boolean isVisible() {
            return this.visible;
        }

        @Override
        public boolean handleMouseInput(int x, int y, int b) {
            if (this.isMouseInBounds(x, y)) {
                if (b == 0 && Mouse.isButtonDown((int)b)) {
                    int mouseX = x - this.cycleButton.gui.getGuiRootLeft() - this.getBounds().x;
                    int mouseY = y - this.cycleButton.gui.getGuiRootTop() - this.getBounds().y;
                    for (Pair pair : this.modes) {
                        if (!((Rectangle)pair.getLeft()).contains(mouseX, mouseY)) continue;
                        this.cycleButton.setMode((Enum)pair.getRight());
                        this.setIsVisible(false);
                    }
                }
                return true;
            }
            if (b == 0 && Mouse.isButtonDown((int)b)) {
                this.setIsVisible(false);
            }
            return false;
        }

        @Override
        public boolean isMouseInBounds(int mouseX, int mouseY) {
            int x = mouseX - this.cycleButton.gui.getGuiRootLeft();
            int y = mouseY - this.cycleButton.gui.getGuiRootTop();
            return this.bounds.contains(x, y);
        }

        @Override
        public void guiClosed() {
        }
    }

    public static interface ICycleEnum {
        @Nonnull
        public IWidgetIcon getIcon();

        @Nonnull
        public List<String> getTooltipLines();
    }
}

