/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.client.gui;

import com.enderio.core.client.gui.GuiContainerBase;
import com.enderio.core.client.gui.widget.GhostSlot;
import com.enderio.core.client.render.RenderUtil;
import com.enderio.core.common.util.ItemUtil;
import com.enderio.core.common.util.NNList;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;

public class GhostSlotHandler {
    @Nonnull
    protected final NNList<GhostSlot> ghostSlots = new NNList();
    @Nullable
    protected GhostSlot hoverGhostSlot;

    @Nonnull
    public NNList<GhostSlot> getGhostSlots() {
        return this.ghostSlots;
    }

    public void add(GhostSlot slot) {
        this.ghostSlots.add(slot);
    }

    public GhostSlot getGhostSlotAt(@Nonnull GuiContainerBase guiContainerBase, int mouseX, int mouseY) {
        int mX = mouseX - guiContainerBase.getGuiLeft();
        int mY = mouseY - guiContainerBase.getGuiTop();
        Iterator iterator = this.ghostSlots.iterator();
        while (iterator.hasNext()) {
            GhostSlot slot = (GhostSlot)iterator.next();
            if (!slot.isVisible() || !slot.isMouseOver(mX, mY) || !slot.shouldDrawFakeHover()) continue;
            return slot;
        }
        return null;
    }

    protected void ghostSlotClicked(@Nonnull GuiContainerBase gui, @Nonnull GhostSlot slot, int x, int y, int button) {
        ItemStack handStack = Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70445_o();
        ItemStack existingStack = slot.getStack();
        if (button == 0) {
            this.ghostSlotClickedPrimaryMouseButton(slot, handStack, existingStack);
        } else if (button == 1) {
            this.ghostSlotClickedSecondaryMouseButton(slot, handStack, existingStack);
        } else if (button == -2) {
            this.ghostSlotClickedMouseWheelUp(slot, handStack, existingStack);
        } else if (button == -1) {
            this.ghostSlotClickedMouseWheelDown(slot, handStack, existingStack);
        }
    }

    protected void ghostSlotClickedPrimaryMouseButton(@Nonnull GhostSlot slot, @Nonnull ItemStack handStack, @Nonnull ItemStack existingStack) {
        if (handStack.func_190926_b()) {
            slot.putStack(ItemStack.field_190927_a, 0);
        } else if (existingStack.func_190926_b()) {
            this.replaceSlot(slot, handStack);
        } else if (ItemUtil.areStackMergable(existingStack, handStack)) {
            if (existingStack.func_190916_E() < existingStack.func_77976_d() && existingStack.func_190916_E() < slot.getStackSizeLimit()) {
                this.increaseSlot(slot, existingStack);
            }
        } else {
            this.replaceSlot(slot, handStack);
        }
    }

    protected void ghostSlotClickedSecondaryMouseButton(@Nonnull GhostSlot slot, @Nonnull ItemStack handStack, @Nonnull ItemStack existingStack) {
        if (handStack.func_190926_b()) {
            slot.putStack(ItemStack.field_190927_a, 0);
        } else if (existingStack.func_190926_b()) {
            this.replaceSlot1Item(slot, handStack);
        } else if (ItemUtil.areStackMergable(existingStack, handStack)) {
            this.descreaseSlot(slot, existingStack);
        } else {
            this.replaceSlot1Item(slot, handStack);
        }
    }

    protected void ghostSlotClickedMouseWheelUp(@Nonnull GhostSlot slot, @Nonnull ItemStack handStack, @Nonnull ItemStack existingStack) {
        if (!existingStack.func_190926_b() && existingStack.func_190916_E() < existingStack.func_77976_d() && existingStack.func_190916_E() < slot.getStackSizeLimit()) {
            this.increaseSlot(slot, existingStack);
        }
    }

    protected void ghostSlotClickedMouseWheelDown(@Nonnull GhostSlot slot, @Nonnull ItemStack handStack, @Nonnull ItemStack existingStack) {
        if (!existingStack.func_190926_b()) {
            this.descreaseSlot(slot, existingStack);
        }
    }

    protected void descreaseSlot(@Nonnull GhostSlot slot, @Nonnull ItemStack existingStack) {
        existingStack.func_190918_g(1);
        slot.putStack(existingStack, existingStack.func_190916_E());
    }

    protected void increaseSlot(@Nonnull GhostSlot slot, @Nonnull ItemStack existingStack) {
        existingStack.func_190917_f(1);
        slot.putStack(existingStack, existingStack.func_190916_E());
    }

    protected void replaceSlot1Item(@Nonnull GhostSlot slot, @Nonnull ItemStack handStack) {
        ItemStack oneItem = handStack.func_77946_l();
        oneItem.func_190920_e(1);
        slot.putStack(oneItem, oneItem.func_190916_E());
    }

    protected void replaceSlot(@Nonnull GhostSlot slot, @Nonnull ItemStack handStack) {
        if (handStack.func_190916_E() <= slot.getStackSizeLimit()) {
            slot.putStack(handStack, handStack.func_190916_E());
        } else {
            ItemStack tmp = handStack.func_77946_l();
            tmp.func_190920_e(slot.getStackSizeLimit());
            slot.putStack(tmp, tmp.func_190916_E());
        }
    }

    protected void startDrawing(@Nonnull GuiContainerBase gui) {
        this.hoverGhostSlot = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawGhostSlots(@Nonnull GuiContainerBase gui, int mouseX, int mouseY) {
        int sx = gui.getGuiLeft();
        int sy = gui.getGuiTop();
        gui.drawFakeItemsStart();
        try {
            this.hoverGhostSlot = null;
            Iterator iterator = this.ghostSlots.iterator();
            while (iterator.hasNext()) {
                GhostSlot slot = (GhostSlot)iterator.next();
                ItemStack stack = slot.getStack();
                if (!slot.isVisible()) continue;
                if (!stack.func_190926_b()) {
                    gui.drawFakeItemStack(slot.getX() + sx, slot.getY() + sy, stack);
                    if (slot.shouldDisplayStdOverlay()) {
                        gui.drawFakeItemStackStdOverlay(slot.getX() + sx, slot.getY() + sy, stack);
                    }
                    if (slot.shouldGrayOut()) {
                        this.drawGhostSlotGrayout(gui, slot);
                    }
                }
                if (!slot.isMouseOver(mouseX - sx, mouseY - sy)) continue;
                this.hoverGhostSlot = slot;
            }
            GhostSlot hoverGhostSlot2 = this.hoverGhostSlot;
            if (hoverGhostSlot2 != null && hoverGhostSlot2.shouldDrawFakeHover()) {
                gui.drawFakeItemHover(hoverGhostSlot2.getX() + sx, hoverGhostSlot2.getY() + sy);
            }
        }
        finally {
            gui.drawFakeItemsEnd();
        }
    }

    protected void drawGhostSlotGrayout(@Nonnull GuiContainerBase gui, @Nonnull GhostSlot slot) {
        GlStateManager.func_179097_i();
        GlStateManager.func_179147_l();
        GlStateManager.func_179140_f();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)slot.getGrayOutLevel());
        RenderUtil.bindTexture(gui.getGuiTexture());
        gui.func_73729_b(gui.getGuiLeft() + slot.getX(), gui.getGuiTop() + slot.getY(), slot.getX(), slot.getY(), 16, 16);
        GlStateManager.func_179084_k();
        GlStateManager.func_179126_j();
    }

    protected boolean drawGhostSlotToolTip(@Nonnull GuiContainerBase gui, int mouseX, int mouseY) {
        GhostSlot hoverGhostSlot2 = this.hoverGhostSlot;
        if (hoverGhostSlot2 != null) {
            return hoverGhostSlot2.drawGhostSlotToolTip(gui, mouseX, mouseY);
        }
        return false;
    }
}

