/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.teams;

import com.flansmod.common.teams.ITeamObject;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;

public class PermanentBaseData {
    public int baseID = 0;
    public List<BlockPos> spawnPoints = new ArrayList<BlockPos>();
    public int teamID = 0;

    public void writeBaseToNBT(NBTTagCompound tags) {
        tags.func_74768_a("NumObjects", this.spawnPoints.size());
        for (int i = 0; i < this.spawnPoints.size(); ++i) {
            BlockPos pos = this.spawnPoints.get(i);
            NBTTagCompound objectTags = new NBTTagCompound();
            objectTags.func_74780_a("x", (double)pos.func_177958_n());
            objectTags.func_74780_a("y", (double)pos.func_177956_o());
            objectTags.func_74780_a("z", (double)pos.func_177952_p());
            tags.func_74782_a("SP_" + i, (NBTBase)objectTags);
        }
    }

    public void readBaseFromNBT(NBTTagCompound tags) {
        int iNumObj = tags.func_74762_e("NumObjects");
        for (int i = 0; i < iNumObj; ++i) {
            NBTTagCompound objectTags = tags.func_74775_l("SP_" + i);
            this.spawnPoints.add(new BlockPos(objectTags.func_74769_h("x"), objectTags.func_74769_h("y"), objectTags.func_74769_h("z")));
        }
    }

    public void addObject(ITeamObject object) {
        BlockPos objPos = new BlockPos(object.getPosX(), object.getPosY(), object.getPosZ());
        for (BlockPos pos : this.spawnPoints) {
            if (!pos.equals((Object)objPos)) continue;
            return;
        }
        this.spawnPoints.add(objPos);
    }
}

