/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.teams;

import com.flansmod.common.FlansMod;
import com.flansmod.common.teams.ArmourType;
import com.flansmod.common.types.IFlanItem;
import com.flansmod.common.types.InfoType;
import com.google.common.collect.Multimap;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemTeamArmour
extends ItemArmor
implements IFlanItem {
    public ArmourType type;
    private ItemArmor.ArmorMaterial material;
    protected static final UUID[] uuid = new UUID[]{UUID.randomUUID(), UUID.randomUUID(), UUID.randomUUID(), UUID.randomUUID()};
    protected static final UUID KNOCKBACK_RESIST_MODIFIER = UUID.fromString("77777777-645C-4F38-A497-9C13A33DB5CF");
    protected static final UUID MOVEMENT_SPEED_MODIFIER = UUID.fromString("99999999-4180-4865-B01B-BCCE9785ACA3");

    public ItemTeamArmour(ArmourType t) {
        super(EnumHelper.addArmorMaterial((String)t.shortName, (String)"", (int)t.Durability, (int[])new int[]{t.DamageReductionAmount, t.DamageReductionAmount, t.DamageReductionAmount, t.DamageReductionAmount}, (int)t.Enchantability, (SoundEvent)SoundEvents.field_187719_p, (float)t.Toughness), 0, EntityEquipmentSlot.values()[5 - t.type]);
        this.type = t;
        this.type.item = this;
        this.setRegistryName(this.type.shortName);
        this.func_77637_a(FlansMod.tabFlanTeams);
        if (this.type.Durability > 0) {
            this.func_77656_e(this.type.Durability);
        } else {
            this.func_77656_e(0);
        }
    }

    public ItemTeamArmour(ItemArmor.ArmorMaterial armorMaterial, int renderIndex, int armourType) {
        super(armorMaterial, renderIndex, EntityEquipmentSlot.values()[5 - armourType]);
    }

    public int func_77619_b() {
        return this.type.Enchantability;
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String armourType) {
        return "flansmod:armor/" + this.type.armourTextureName + "_" + (this.type.type == 2 ? "2" : "1") + ".png";
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase living, ItemStack stack, EntityEquipmentSlot slot, ModelBiped defaultModel) {
        return this.type.model;
    }

    public void func_77624_a(ItemStack stack, World world, List<String> lines, ITooltipFlag b) {
        if (this.type.description != null) {
            Collections.addAll(lines, this.type.description.split("_"));
        }
        if (Math.abs(this.type.jumpModifier - 1.0f) > 0.01f) {
            lines.add("\u00a73+" + (int)((this.type.jumpModifier - 1.0f) * 100.0f) + "% Jump Height");
        }
        if (this.type.smokeProtection) {
            lines.add("\u00a72+Smoke Protection");
        }
        if (this.type.nightVision) {
            lines.add("\u00a72+Night Vision");
        }
        if (this.type.negateFallDamage) {
            lines.add("\u00a72+Negates Fall Damage");
        }
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        Multimap multimap = super.getAttributeModifiers(slot, stack);
        boolean bShouldAdd = false;
        switch (this.type.type) {
            case 0: {
                bShouldAdd = slot == EntityEquipmentSlot.HEAD;
                break;
            }
            case 1: {
                bShouldAdd = slot == EntityEquipmentSlot.CHEST;
                break;
            }
            case 2: {
                bShouldAdd = slot == EntityEquipmentSlot.LEGS;
                break;
            }
            case 3: {
                boolean bl = bShouldAdd = slot == EntityEquipmentSlot.FEET;
            }
        }
        if (bShouldAdd) {
            multimap.put((Object)SharedMonsterAttributes.field_111266_c.func_111108_a(), (Object)new AttributeModifier(uuid[this.type.type], "KnockbackResist", (double)this.type.knockbackModifier, 0));
            multimap.put((Object)SharedMonsterAttributes.field_111263_d.func_111108_a(), (Object)new AttributeModifier(uuid[this.type.type], "MovementSpeed", (double)(this.type.moveSpeedModifier - 1.0f), 2));
        }
        return multimap;
    }

    @Override
    public InfoType getInfoType() {
        return this.type;
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        if (this.type.nightVision && FlansMod.ticker % 25 == 0) {
            player.func_70690_d(new PotionEffect(Potion.func_188412_a((int)16), 250));
        }
        if (this.type.jumpModifier > 1.01f && FlansMod.ticker % 25 == 0) {
            player.func_70690_d(new PotionEffect(Potion.func_188412_a((int)8), 250, (int)((this.type.jumpModifier - 1.0f) * 2.0f), true, false));
        }
        if (this.type.negateFallDamage) {
            player.field_70143_R = 0.0f;
        }
    }
}

