/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.network;

import com.flansmod.common.FlansMod;
import com.flansmod.common.network.PacketBase;
import com.flansmod.common.vector.Vector3f;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.ParticleDigging;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PacketBlockHitEffect
extends PacketBase {
    private Float x;
    private Float y;
    private Float z;
    private Float directionX;
    private Float directionY;
    private Float directionZ;
    private Integer blockX;
    private Integer blockY;
    private Integer blockZ;
    private EnumFacing facing;

    public PacketBlockHitEffect() {
    }

    public PacketBlockHitEffect(Vector3f hit, Vector3f direction, BlockPos position, EnumFacing facing) {
        this(Float.valueOf(hit.x), Float.valueOf(hit.y), Float.valueOf(hit.z), Float.valueOf(direction.x), Float.valueOf(direction.y), Float.valueOf(direction.z), position.func_177958_n(), position.func_177956_o(), position.func_177952_p(), facing);
    }

    public PacketBlockHitEffect(Float x, Float y, Float z, Float directionX, Float directionY, Float directionZ, Integer blockX, Integer blockY, Integer blockZ, EnumFacing facing) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.directionX = directionX;
        this.directionY = directionY;
        this.directionZ = directionZ;
        this.blockX = blockX;
        this.blockY = blockY;
        this.blockZ = blockZ;
        this.facing = facing;
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf data) {
        data.writeFloat(this.x.floatValue());
        data.writeFloat(this.y.floatValue());
        data.writeFloat(this.z.floatValue());
        data.writeFloat(this.directionX.floatValue());
        data.writeFloat(this.directionY.floatValue());
        data.writeFloat(this.directionZ.floatValue());
        data.writeInt(this.blockX.intValue());
        data.writeInt(this.blockY.intValue());
        data.writeInt(this.blockZ.intValue());
        data.writeInt(this.facing.func_176745_a());
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf data) {
        this.x = Float.valueOf(data.readFloat());
        this.y = Float.valueOf(data.readFloat());
        this.z = Float.valueOf(data.readFloat());
        this.directionX = Float.valueOf(data.readFloat());
        this.directionY = Float.valueOf(data.readFloat());
        this.directionZ = Float.valueOf(data.readFloat());
        this.blockX = data.readInt();
        this.blockY = data.readInt();
        this.blockZ = data.readInt();
        this.facing = EnumFacing.func_82600_a((int)data.readInt());
    }

    @Override
    public void handleServerSide(EntityPlayerMP playerEntity) {
        FlansMod.log.warn("Received Packet packet on client. Skipping.");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleClientSide(EntityPlayer clientPlayer) {
        double motionZ;
        double motionY;
        double motionX;
        World world = clientPlayer.func_130014_f_();
        BlockPos pos = new BlockPos(this.blockX.intValue(), this.blockY.intValue(), this.blockZ.intValue());
        IBlockState state = world.func_180495_p(pos).func_185899_b((IBlockAccess)world, pos);
        Vec3i facingDir = this.facing.func_176730_m();
        for (int i = 0; i < 2; ++i) {
            float scale = (float)world.field_73012_v.nextGaussian() * 0.1f + 0.5f;
            motionX = (double)facingDir.func_177958_n() * (double)scale + world.field_73012_v.nextGaussian() * 0.025;
            motionY = (double)facingDir.func_177956_o() * (double)scale + world.field_73012_v.nextGaussian() * 0.025;
            motionZ = (double)facingDir.func_177952_p() * (double)scale + world.field_73012_v.nextGaussian() * 0.025;
            ParticleDigging fx = (ParticleDigging)Minecraft.func_71410_x().field_71452_i.func_178927_a(EnumParticleTypes.BLOCK_CRACK.func_179348_c(), (double)this.x.floatValue(), (double)this.y.floatValue(), (double)this.z.floatValue(), motionX += (double)this.directionX.floatValue(), motionY += (double)this.directionY.floatValue(), motionZ += (double)this.directionZ.floatValue(), new int[]{Block.func_149682_b((Block)state.func_177230_c())});
            if (fx == null) continue;
            fx.func_187117_a(Minecraft.func_71410_x().func_175602_ab().func_184389_a(state).func_177554_e());
        }
        double scale = world.field_73012_v.nextGaussian() * 0.05 + 0.05;
        motionX = (double)facingDir.func_177958_n() * scale + world.field_73012_v.nextGaussian() * 0.025;
        motionY = (double)facingDir.func_177956_o() * scale + world.field_73012_v.nextGaussian() * 0.025;
        motionZ = (double)facingDir.func_177952_p() * scale + world.field_73012_v.nextGaussian() * 0.025;
        Minecraft.func_71410_x().field_71452_i.func_178927_a(EnumParticleTypes.CLOUD.func_179348_c(), (double)this.x.floatValue(), (double)this.y.floatValue(), (double)this.z.floatValue(), motionX, motionY, motionZ, new int[0]);
    }
}

