/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.guns;

import com.flansmod.client.debug.EntityDebugDot;
import com.flansmod.client.debug.EntityDebugVector;
import com.flansmod.common.FlansMod;
import com.flansmod.common.FlansModExplosion;
import com.flansmod.common.guns.BulletType;
import com.flansmod.common.guns.EntityBullet;
import com.flansmod.common.guns.EnumSpreadPattern;
import com.flansmod.common.guns.FiredShot;
import com.flansmod.common.guns.ShootBulletHandler;
import com.flansmod.common.guns.raytracing.FlansModRaytracer;
import com.flansmod.common.network.PacketBlockHitEffect;
import com.flansmod.common.network.PacketBulletTrail;
import com.flansmod.common.network.PacketFlak;
import com.flansmod.common.network.PacketHitMarker;
import com.flansmod.common.network.PacketPlaySound;
import com.flansmod.common.teams.Team;
import com.flansmod.common.teams.TeamsManager;
import com.flansmod.common.teams.TeamsRound;
import com.flansmod.common.types.InfoType;
import com.flansmod.common.util.BlockUtil;
import com.flansmod.common.vector.Vector3f;
import java.util.List;
import java.util.Optional;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class ShotHandler {
    public static void fireGun(World world, FiredShot shot, Integer bulletAmount, Vector3f rayTraceOrigin, Vector3f shootingDirection) {
        ShotHandler.fireGun(world, shot, bulletAmount, rayTraceOrigin, shootingDirection, ShootBulletHandler.instance);
    }

    public static void fireGun(World world, FiredShot shot, Integer bulletAmount, Vector3f rayTraceOrigin, Vector3f shootingDirection, ShootBulletHandler handler) {
        if (shot.getFireableGun().getBulletSpeed() == 0.0f) {
            ShotHandler.createMultipleShots(world, shot, bulletAmount, rayTraceOrigin, shootingDirection, handler);
        } else {
            for (int i = 0; i < bulletAmount; ++i) {
                world.func_72838_d((Entity)new EntityBullet(world, shot, rayTraceOrigin.toVec3(), shootingDirection.toVec3()));
                handler.shooting(i < bulletAmount - 1);
            }
        }
    }

    private static void createMultipleShots(World world, FiredShot shot, Integer bulletAmount, Vector3f rayTraceOrigin, Vector3f shootingDirection, ShootBulletHandler handler) {
        Float bulletspread = Float.valueOf(0.0025f * shot.getFireableGun().getGunSpread() * shot.getBulletType().bulletSpread);
        for (int i = 0; i < bulletAmount; ++i) {
            ShotHandler.createShot(world, shot, bulletspread, rayTraceOrigin, new Vector3f(shootingDirection));
            handler.shooting(i < bulletAmount - 1);
        }
    }

    private static void createShot(World world, FiredShot shot, Float bulletspread, Vector3f rayTraceOrigin, Vector3f shootingDirection) {
        ShotHandler.randomizeVectorDirection(world, shootingDirection, bulletspread, shot.getFireableGun().getSpreadPattern());
        shootingDirection.scale(500.0f);
        Float penetrationPower = Float.valueOf(shot.getBulletType().penetratingPower);
        Entity ignore = shot.getPlayerOptional().isPresent() ? (Entity)shot.getPlayerOptional().get() : (Entity)shot.getShooterOptional().orElse(null);
        List<FlansModRaytracer.BulletHit> hits = FlansModRaytracer.Raytrace(world, ignore, false, null, rayTraceOrigin, shootingDirection, 0, penetrationPower);
        Vector3f previousHitPos = rayTraceOrigin;
        Vector3f finalhit = null;
        for (int i = 0; i < hits.size(); ++i) {
            FlansModRaytracer.BulletHit hit = hits.get(i);
            Vector3f shotVector = (Vector3f)new Vector3f(shootingDirection).scale(hit.intersectTime);
            Vector3f hitPos = Vector3f.add(rayTraceOrigin, shotVector, null);
            if (FlansMod.DEBUG) {
                if (hit instanceof FlansModRaytracer.BlockHit) {
                    world.func_72838_d((Entity)new EntityDebugDot(world, hitPos, 1000, 1.0f, 0.0f, 1.0f));
                } else {
                    world.func_72838_d((Entity)new EntityDebugDot(world, hitPos, 1000, 1.0f, 1.0f, 1.0f));
                }
                world.func_72838_d((Entity)new EntityDebugVector(world, previousHitPos, Vector3f.sub(hitPos, previousHitPos, null), 1000, 0.5f, 0.5f, (float)i / (float)hits.size()));
            }
            previousHitPos = hitPos;
            if (!((penetrationPower = ShotHandler.OnHit(world, hitPos, shootingDirection, shot, hit, penetrationPower)).floatValue() <= 0.0f)) continue;
            ShotHandler.onDetonate(world, shot, hitPos);
            finalhit = hitPos;
            break;
        }
        if (finalhit == null) {
            finalhit = Vector3f.add(rayTraceOrigin, shootingDirection, null);
        }
        FlansMod.packetHandler.sendToAllAround(new PacketBulletTrail(rayTraceOrigin, finalhit, Float.valueOf(0.05f), Float.valueOf(10.0f), Float.valueOf(10.0f), shot.getBulletType().trailTexture), rayTraceOrigin.x, rayTraceOrigin.y, rayTraceOrigin.z, 500.0f, world.field_73011_w.getDimension());
    }

    public static Float OnHit(World world, Vector3f hit, Vector3f shootingDirection, FiredShot shot, FlansModRaytracer.BulletHit bulletHit, Float penetratingPower) {
        Float damage = Float.valueOf(shot.getFireableGun().getDamage());
        BulletType bulletType = shot.getBulletType();
        if (bulletHit instanceof FlansModRaytracer.DriveableHit) {
            FlansModRaytracer.DriveableHit driveableHit = (FlansModRaytracer.DriveableHit)bulletHit;
            penetratingPower = Float.valueOf(driveableHit.driveable.bulletHit(bulletType, shot.getFireableGun().getDamageAgainstVehicles(), driveableHit, penetratingPower.floatValue()));
            if (FlansMod.DEBUG) {
                world.func_72838_d((Entity)new EntityDebugDot(world, hit, 1000, 0.0f, 0.0f, 1.0f));
            }
            shot.getPlayerOptional().ifPresent(player -> FlansMod.getPacketHandler().sendTo(new PacketHitMarker(), (EntityPlayerMP)player));
        } else if (bulletHit instanceof FlansModRaytracer.PlayerBulletHit) {
            Optional<EntityPlayerMP> optionalPlayer;
            FlansModRaytracer.PlayerBulletHit playerHit = (FlansModRaytracer.PlayerBulletHit)bulletHit;
            penetratingPower = Float.valueOf(playerHit.hitbox.hitByBullet(shot, damage, penetratingPower));
            if (FlansMod.DEBUG) {
                world.func_72838_d((Entity)new EntityDebugDot(world, hit, 1000, 1.0f, 0.0f, 0.0f));
            }
            if ((optionalPlayer = shot.getPlayerOptional()).isPresent()) {
                TeamsRound round;
                EntityPlayerMP player2 = optionalPlayer.get();
                if (TeamsManager.getInstance() != null && (round = TeamsManager.getInstance().currentRound) != null) {
                    Optional<Team> shooterTeam = round.getTeam((EntityPlayer)player2);
                    Optional<Team> victimTeam = round.getTeam(playerHit.hitbox.player);
                    if (!(shooterTeam.isPresent() && victimTeam.isPresent() && shooterTeam.get().equals(victimTeam.get()))) {
                        FlansMod.getPacketHandler().sendTo(new PacketHitMarker(), player2);
                    }
                } else {
                    FlansMod.getPacketHandler().sendTo(new PacketHitMarker(), player2);
                }
            }
        } else if (bulletHit instanceof FlansModRaytracer.EntityHit) {
            FlansModRaytracer.EntityHit entityHit = (FlansModRaytracer.EntityHit)bulletHit;
            if (entityHit.entity != null) {
                if (entityHit.entity.func_70097_a(shot.getDamageSource(), damage.floatValue() * bulletType.damageVsLiving) && entityHit.entity instanceof EntityLivingBase) {
                    EntityLivingBase living = (EntityLivingBase)entityHit.entity;
                    for (PotionEffect effect : bulletType.hitEffects) {
                        living.func_70690_d(new PotionEffect(effect));
                    }
                    living.field_70172_ad = 0;
                }
                if (bulletType.setEntitiesOnFire) {
                    entityHit.entity.func_70015_d(20);
                }
                penetratingPower = Float.valueOf(penetratingPower.floatValue() - 1.0f);
                if (FlansMod.DEBUG) {
                    world.func_72838_d((Entity)new EntityDebugDot(world, hit, 1000, 1.0f, 1.0f, 0.0f));
                }
            }
            shot.getPlayerOptional().ifPresent(player -> FlansMod.getPacketHandler().sendTo(new PacketHitMarker(), (EntityPlayerMP)player));
        } else if (bulletHit instanceof FlansModRaytracer.BlockHit) {
            FlansModRaytracer.BlockHit blockHit = (FlansModRaytracer.BlockHit)bulletHit;
            RayTraceResult raytraceResult = blockHit.getRayTraceResult();
            BlockPos pos = raytraceResult.func_178782_a();
            if (FlansMod.DEBUG) {
                world.func_72838_d((Entity)new EntityDebugDot(world, hit, 1000, 0.0f, 1.0f, 0.0f));
            }
            Material mat = blockHit.getIBlockState().func_185904_a();
            if (bulletType.breaksGlass && mat == Material.field_151592_s && TeamsManager.canBreakGlass) {
                WorldServer worldServer = (WorldServer)world;
                BlockUtil.destroyBlock(worldServer, pos, shot.getPlayerOptional().orElse(null), false);
            }
            IBlockState state = blockHit.getIBlockState().func_185899_b((IBlockAccess)world, pos);
            penetratingPower = Float.valueOf(penetratingPower.floatValue() - ShotHandler.getBlockPenetrationDecrease(state, pos, world));
            EnumFacing faceing = blockHit.getRayTraceResult().field_178784_b;
            Vector3f bulletDir = new Vector3f(shootingDirection);
            bulletDir.normalise();
            bulletDir.scale(0.5f);
            for (EntityPlayer player3 : world.field_73010_i) {
                if (!(player3.func_174818_b(pos) < 90000.0)) continue;
                FlansMod.getPacketHandler().sendTo(new PacketBlockHitEffect(hit, bulletDir, pos, faceing), (EntityPlayerMP)player3);
            }
            PacketPlaySound.sendSoundPacket(hit.x, hit.y, hit.z, bulletType.hitSoundRange, world.field_73011_w.getDimension(), bulletType.hitSound, false);
        }
        if (penetratingPower.floatValue() <= 0.0f || bulletType.explodeOnImpact) {
            return Float.valueOf(-1.0f);
        }
        return penetratingPower;
    }

    public static void onDetonate(World world, FiredShot shot, Vector3f detonatePos) {
        ItemStack dropStack;
        BulletType bulletType = shot.getBulletType();
        if (bulletType.explosionRadius > 0.0f) {
            new FlansModExplosion(world, shot.getShooterOptional().orElse(null), shot.getPlayerOptional(), bulletType, detonatePos.x, detonatePos.y, detonatePos.z, bulletType.explosionRadius, bulletType.fireRadius > 0.0f, bulletType.flak > 0, bulletType.explosionBreaksBlocks);
        }
        if (bulletType.fireRadius > 0.0f) {
            for (float i = -bulletType.fireRadius; i < bulletType.fireRadius; i += 1.0f) {
                for (float k = -bulletType.fireRadius; k < bulletType.fireRadius; k += 1.0f) {
                    for (int j = -1; j < 1; ++j) {
                        if (world.func_180495_p(new BlockPos((int)(detonatePos.x + i), (int)(detonatePos.y + (float)j), (int)(detonatePos.z + k))).func_185904_a() != Material.field_151579_a) continue;
                        world.func_180501_a(new BlockPos((int)(detonatePos.x + i), (int)(detonatePos.y + (float)j), (int)(detonatePos.z + k)), Blocks.field_150480_ab.func_176223_P(), 2);
                    }
                }
            }
        }
        if (bulletType.flak > 0) {
            FlansMod.getPacketHandler().sendToAllAround(new PacketFlak(detonatePos.x, detonatePos.y, detonatePos.z, bulletType.flak, bulletType.flakParticles), detonatePos.x, detonatePos.y, detonatePos.z, 200.0f, world.field_73011_w.getDimension());
        }
        if (bulletType.dropItemOnHit != null && (dropStack = InfoType.getRecipeElement(bulletType.dropItemOnHit)) != null && !dropStack.func_190926_b()) {
            EntityItem entityitem = new EntityItem(world, (double)detonatePos.x, (double)detonatePos.y, (double)detonatePos.z, dropStack);
            entityitem.func_174869_p();
            world.func_72838_d((Entity)entityitem);
        }
    }

    public static void randomizeVectorDirection(World world, Vector3f vector, Float spread, EnumSpreadPattern pattern) {
        Vector3f xAxis = Vector3f.cross(vector, new Vector3f(0.0f, 1.0f, 0.0f), null);
        xAxis.normalise();
        Vector3f yAxis = Vector3f.cross(vector, xAxis, null);
        yAxis.normalise();
        switch (pattern) {
            case circle: {
                float theta = (float)(world.field_73012_v.nextDouble() * Math.PI * 2.0);
                float radius = (float)world.field_73012_v.nextDouble() * spread.floatValue();
                float xComponent = radius * (float)Math.sin(theta);
                float yComponent = radius * (float)Math.cos(theta);
                xAxis.scale(xComponent);
                yAxis.scale(yComponent);
                Vector3f.add(vector, xAxis, vector);
                Vector3f.add(vector, yAxis, vector);
                break;
            }
            case cube: {
                vector.x += (float)world.field_73012_v.nextGaussian() * spread.floatValue();
                vector.y += (float)world.field_73012_v.nextGaussian() * spread.floatValue();
                vector.z += (float)world.field_73012_v.nextGaussian() * spread.floatValue();
                break;
            }
            case horizontal: {
                float xComponent = spread.floatValue() * (world.field_73012_v.nextFloat() * 2.0f - 1.0f);
                xAxis.scale(xComponent);
                Vector3f.add(vector, xAxis, vector);
                break;
            }
            case vertical: {
                float yComponent = spread.floatValue() * (world.field_73012_v.nextFloat() * 2.0f - 1.0f);
                yAxis.scale(yComponent);
                Vector3f.add(vector, yAxis, vector);
                break;
            }
            case triangle: {
                float xComponent = world.field_73012_v.nextFloat() * 2.0f - 1.0f;
                float yComponent = world.field_73012_v.nextFloat() * 2.0f - 1.0f;
                if (xComponent > 0.0f) {
                    if (yComponent > 1.0f - xComponent * 2.0f) {
                        yComponent = -yComponent;
                        xComponent = 1.0f - xComponent;
                    }
                } else if (yComponent > xComponent * 2.0f + 1.0f) {
                    yComponent = -yComponent;
                    xComponent = -1.0f - xComponent;
                }
                xAxis.scale(xComponent *= spread.floatValue());
                yAxis.scale(yComponent *= spread.floatValue());
                Vector3f.add(vector, xAxis, vector);
                Vector3f.add(vector, yAxis, vector);
                break;
            }
        }
    }

    public static float getBlockPenetrationDecrease(IBlockState blockstate, BlockPos pos, World world) {
        float hardness = blockstate.func_185887_b(world, pos) * 2.0f;
        if (hardness < 0.0f) {
            return 1000.0f;
        }
        return Math.max(hardness, 1.0f);
    }
}

