/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.driveables;

import com.flansmod.common.FlansMod;
import com.flansmod.common.driveables.DriveableType;
import com.flansmod.common.driveables.EntityDriveable;
import com.flansmod.common.vector.Vector3f;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;

public class EntityWheel
extends Entity
implements IEntityAdditionalSpawnData {
    public EntityDriveable vehicle;
    private int ID;
    private int vehicleID;

    public EntityWheel(World world) {
        super(world);
        this.func_70105_a(1.0f, 1.0f);
        this.field_70138_W = 1.0f;
    }

    public EntityWheel(World world, EntityDriveable entity, int i) {
        this(world);
        this.vehicle = entity;
        this.vehicleID = entity.func_145782_y();
        this.ID = i;
        this.initPosition();
    }

    public void initPosition() {
        Vector3f wheelVector = this.vehicle.axes.findLocalVectorGlobally(this.vehicle.getDriveableType().wheelPositions[this.ID].position);
        this.func_70107_b(this.vehicle.field_70165_t + (double)wheelVector.x, this.vehicle.field_70163_u + (double)wheelVector.y, this.vehicle.field_70161_v + (double)wheelVector.z);
        this.field_70138_W = this.vehicle.getDriveableType().wheelStepHeight;
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
    }

    public void func_180430_e(float k, float l) {
        if (this.vehicle == null || k <= 0.0f) {
            return;
        }
        int i = MathHelper.func_76123_f((float)(k - 3.0f));
        if (i > 0) {
            this.vehicle.attackPart(this.vehicle.getDriveableType().wheelPositions[this.ID].part, DamageSource.field_76379_h, i);
        }
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(NBTTagCompound tags) {
        DriveableType type = DriveableType.getDriveable(tags.func_74779_i("DriveableType"));
        this.ID = tags.func_74762_e("Index");
        if (type == null) {
            FlansMod.log.warn("Killing wheel due to invalid type tag");
            this.reallySetDead();
            return;
        }
        if (this.func_184187_bx() instanceof EntityDriveable) {
            this.vehicle = (EntityDriveable)this.func_184187_bx();
            this.vehicle.registerWheel(this);
        }
    }

    protected void func_70014_b(NBTTagCompound tags) {
        if (this.vehicle != null) {
            tags.func_74778_a("DriveableType", this.vehicle.getDriveableType().shortName);
            tags.func_74768_a("Index", this.ID);
        }
    }

    public void func_70071_h_() {
        if (this.vehicle == null || this.field_70128_L) {
            if (this.func_184187_bx() instanceof EntityDriveable) {
                this.vehicle = (EntityDriveable)this.func_184187_bx();
                this.vehicle.registerWheel(this);
            }
            return;
        }
        if (!this.field_70175_ag) {
            this.field_70170_p.func_72838_d((Entity)this);
        }
    }

    public void func_70106_y() {
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    public void reallySetDead() {
        super.func_70106_y();
    }

    public double getSpeedXZ() {
        return Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y);
    }

    public void func_180426_a(double d, double d1, double d2, float f, float f1, int i, boolean b) {
    }

    public void writeSpawnData(ByteBuf data) {
        data.writeInt(this.vehicleID);
        data.writeInt(this.ID);
    }

    public void readSpawnData(ByteBuf data) {
        this.vehicleID = data.readInt();
        this.ID = data.readInt();
        if (this.field_70170_p.func_73045_a(this.vehicleID) instanceof EntityDriveable) {
            this.vehicle = (EntityDriveable)this.field_70170_p.func_73045_a(this.vehicleID);
        }
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    public int getExpectedWheelID() {
        return this.ID;
    }

    public void func_70098_U() {
        if (!this.updateBlocked) {
            this.func_70071_h_();
        }
        if (this.func_184218_aH()) {
            this.func_184187_bx().func_184232_k((Entity)this);
        }
    }
}

