/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common;

import com.flansmod.client.model.ModelItemHolder;
import com.flansmod.common.BlockItemHolder;
import com.flansmod.common.FlansMod;
import com.flansmod.common.types.InfoType;
import com.flansmod.common.types.TypeFile;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.client.model.ModelBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ItemHolderType
extends InfoType {
    @SideOnly(value=Side.CLIENT)
    public ModelItemHolder model;
    public BlockItemHolder block;
    private static HashMap<String, ItemHolderType> itemHolders = new HashMap();

    public ItemHolderType(TypeFile file) {
        super(file);
    }

    @Override
    protected void preRead(TypeFile file) {
    }

    @Override
    public void postRead(TypeFile file) {
        itemHolders.put(this.shortName, this);
    }

    @Override
    protected void read(String[] split, TypeFile file) {
        super.read(split, file);
        try {
            if (FMLCommonHandler.instance().getSide().isClient() && split[0].equals("Model")) {
                this.model = FlansMod.proxy.loadModel(split[1], this.shortName, ModelItemHolder.class);
            }
        }
        catch (Exception e) {
            FlansMod.log.error("Reading item holder file failed : " + this.shortName);
            FlansMod.log.throwing((Throwable)e);
        }
    }

    @Override
    public void registerItem(IForgeRegistry<Item> registry) {
        this.item = (Item)new ItemBlock((Block)this.block).setRegistryName(this.shortName + "_item");
        registry.register((IForgeRegistryEntry)this.item);
    }

    @Override
    public void registerBlock(IForgeRegistry<Block> registry) {
        registry.register((IForgeRegistryEntry)this.block);
    }

    public static ItemHolderType getItemHolder(String string) {
        return itemHolders.get(string);
    }

    @Override
    public void reloadModel() {
        this.model = FlansMod.proxy.loadModel(this.modelString, this.shortName, ModelItemHolder.class);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ModelBase GetModel() {
        return this.model;
    }
}

