/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.client.model;

import com.flansmod.client.ClientProxy;
import com.flansmod.client.handlers.FlansModResourceHandler;
import com.flansmod.client.model.CustomItemRenderType;
import com.flansmod.client.model.CustomItemRenderer;
import com.flansmod.client.model.ModelDriveable;
import com.flansmod.client.model.ModelGun;
import com.flansmod.client.model.ModelMecha;
import com.flansmod.common.FlansMod;
import com.flansmod.common.driveables.DriveablePart;
import com.flansmod.common.driveables.DriveablePosition;
import com.flansmod.common.driveables.DriveableType;
import com.flansmod.common.driveables.EnumDriveablePart;
import com.flansmod.common.driveables.ShootPoint;
import com.flansmod.common.driveables.mechas.EntityMecha;
import com.flansmod.common.driveables.mechas.EnumMechaSlotType;
import com.flansmod.common.driveables.mechas.ItemMecha;
import com.flansmod.common.driveables.mechas.ItemMechaAddon;
import com.flansmod.common.driveables.mechas.MechaItemType;
import com.flansmod.common.driveables.mechas.MechaType;
import com.flansmod.common.guns.GunType;
import com.flansmod.common.guns.ItemGun;
import com.flansmod.common.guns.Paintjob;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fml.client.registry.IRenderFactory;

public class RenderMecha
extends Render<EntityMecha>
implements CustomItemRenderer {
    private static final ResourceLocation RES_ITEM_GLINT = new ResourceLocation("textures/misc/enchanted_item_glint.png");
    private static final ItemRenderer renderer = new ItemRenderer(Minecraft.func_71410_x());
    private static RenderItem renderItem;

    public RenderMecha(RenderManager manager) {
        super(manager);
        renderItem = Minecraft.func_71410_x().func_175599_af();
        this.field_76989_e = 0.5f;
    }

    public void doRender(EntityMecha mecha, double d, double d1, double d2, float f, float f1) {
        ItemStack holdingStack;
        ItemStack hipsSlot;
        float dRoll;
        float dPitch;
        float dYaw;
        this.func_180548_c(mecha);
        float scale = 0.0625f;
        MechaType type = mecha.getMechaType();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)((float)d), (float)((float)d1), (float)((float)d2));
        for (dYaw = mecha.axes.getYaw() - mecha.field_70126_B; dYaw > 180.0f; dYaw -= 360.0f) {
        }
        while (dYaw <= -180.0f) {
            dYaw += 360.0f;
        }
        for (dPitch = mecha.axes.getPitch() - mecha.field_70127_C; dPitch > 180.0f; dPitch -= 360.0f) {
        }
        while (dPitch <= -180.0f) {
            dPitch += 360.0f;
        }
        for (dRoll = mecha.axes.getRoll() - mecha.prevRotationRoll; dRoll > 180.0f; dRoll -= 360.0f) {
        }
        while (dRoll <= -180.0f) {
            dRoll += 360.0f;
        }
        GlStateManager.func_179114_b((float)(-mecha.field_70126_B - dYaw * f1), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(mecha.field_70127_C + dPitch * f1), (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179114_b((float)(mecha.prevRotationRoll + dRoll * f1), (float)1.0f, (float)0.0f, (float)0.0f);
        float modelScale = mecha.getMechaType().modelScale;
        ModelMecha model = (ModelMecha)type.model;
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)modelScale, (float)modelScale, (float)modelScale);
        if (model != null) {
            model.render(mecha, f1);
        }
        if ((hipsSlot = mecha.inventory.getStackInSlot(EnumMechaSlotType.hips)) != null && hipsSlot.func_77973_b() instanceof ItemMechaAddon) {
            MechaItemType hipsAddon = ((ItemMechaAddon)hipsSlot.func_77973_b()).type;
            if (hipsAddon.model != null) {
                GlStateManager.func_179109_b((float)model.hipsAttachmentPoint.x, (float)model.hipsAttachmentPoint.y, (float)model.hipsAttachmentPoint.z);
                GlStateManager.func_179152_a((float)type.heldItemScale, (float)type.heldItemScale, (float)type.heldItemScale);
                if (hipsAddon.texture != null) {
                    this.func_110776_a(FlansModResourceHandler.getTexture(hipsAddon));
                }
                hipsAddon.model.render(mecha, f1);
            }
        }
        GlStateManager.func_179121_F();
        if (mecha.isPartIntact(EnumDriveablePart.leftArm)) {
            this.func_180548_c(mecha);
            GlStateManager.func_179094_E();
            float smoothedPitch = 0.0f;
            if (mecha.getSeat(0) != null) {
                smoothedPitch = mecha.getSeat((int)0).prevLooking.getPitch() + (mecha.getSeat((int)0).looking.getPitch() - mecha.getSeat((int)0).prevLooking.getPitch()) * f1;
            }
            if (smoothedPitch > type.lowerArmLimit) {
                smoothedPitch = type.lowerArmLimit;
            }
            if (smoothedPitch < -type.upperArmLimit) {
                smoothedPitch = -type.upperArmLimit;
            }
            GlStateManager.func_179109_b((float)type.leftArmOrigin.x, (float)mecha.getMechaType().leftArmOrigin.y, (float)mecha.getMechaType().leftArmOrigin.z);
            GlStateManager.func_179114_b((float)(90.0f - smoothedPitch), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)modelScale, (float)modelScale, (float)modelScale);
            model.renderLeftArm(scale, mecha, f1);
            GlStateManager.func_179121_F();
            GlStateManager.func_179109_b((float)(0.0f + type.leftHandModifierY), (float)(-type.armLength - type.leftHandModifierX), (float)(0.0f + type.leftHandModifierZ));
            holdingStack = mecha.inventory.getStackInSlot(EnumMechaSlotType.leftTool);
            GlStateManager.func_179152_a((float)modelScale, (float)modelScale, (float)modelScale);
            if (holdingStack == null || holdingStack.func_190926_b()) {
                model.renderLeftHand(scale, mecha, f1);
            } else {
                GlStateManager.func_179152_a((float)type.heldItemScale, (float)type.heldItemScale, (float)type.heldItemScale);
                this.renderItem(mecha, holdingStack, 0, true, f1);
            }
            GlStateManager.func_179121_F();
        }
        if (mecha.isPartIntact(EnumDriveablePart.rightArm)) {
            this.func_180548_c(mecha);
            GlStateManager.func_179094_E();
            float smoothedPitch = 0.0f;
            if (mecha.getSeat(0) != null) {
                smoothedPitch = mecha.getSeat((int)0).prevLooking.getPitch() + (mecha.getSeat((int)0).looking.getPitch() - mecha.getSeat((int)0).prevLooking.getPitch()) * f1;
            }
            if (smoothedPitch > type.lowerArmLimit) {
                smoothedPitch = type.lowerArmLimit;
            }
            if (smoothedPitch < -type.upperArmLimit) {
                smoothedPitch = -type.upperArmLimit;
            }
            GlStateManager.func_179109_b((float)type.rightArmOrigin.x, (float)mecha.getMechaType().rightArmOrigin.y, (float)mecha.getMechaType().rightArmOrigin.z);
            GlStateManager.func_179114_b((float)(90.0f - smoothedPitch), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)modelScale, (float)modelScale, (float)modelScale);
            model.renderRightArm(scale, mecha, f1);
            GlStateManager.func_179121_F();
            GlStateManager.func_179109_b((float)(0.0f + type.rightHandModifierY), (float)(-type.armLength - type.rightHandModifierX), (float)(0.0f + type.rightHandModifierZ));
            GlStateManager.func_179152_a((float)modelScale, (float)modelScale, (float)modelScale);
            holdingStack = mecha.inventory.getStackInSlot(EnumMechaSlotType.rightTool);
            if (holdingStack == null || holdingStack.func_190926_b()) {
                model.renderRightHand(scale, mecha, f1);
            } else {
                GlStateManager.func_179152_a((float)type.heldItemScale, (float)type.heldItemScale, (float)type.heldItemScale);
                this.renderItem(mecha, holdingStack, 0, false, f1);
            }
            GlStateManager.func_179121_F();
        }
        if (FlansMod.DEBUG) {
            DriveablePosition driveablePosition;
            GlStateManager.func_179090_x();
            GlStateManager.func_179147_l();
            GlStateManager.func_179097_i();
            GlStateManager.func_179131_c((float)1.0f, (float)0.0f, (float)0.0f, (float)0.3f);
            for (DriveablePart part : mecha.getDriveableData().parts.values()) {
                if (part.box == null) continue;
                ModelDriveable.renderOffsetAABB(new AxisAlignedBB((double)(part.box.x / 16.0f), (double)(part.box.y / 16.0f), (double)(part.box.z / 16.0f), (double)((part.box.x + part.box.w) / 16.0f), (double)((part.box.y + part.box.h) / 16.0f), (double)((part.box.z + part.box.d) / 16.0f)), 0.0, 0.0, 0.0);
            }
            GlStateManager.func_179131_c((float)0.0f, (float)0.0f, (float)1.0f, (float)0.3f);
            for (ShootPoint point : type.shootPointsPrimary) {
                driveablePosition = point.rootPos;
                ModelDriveable.renderOffsetAABB(new AxisAlignedBB((double)(driveablePosition.position.x - 0.25f), (double)(driveablePosition.position.y - 0.25f), (double)(driveablePosition.position.z - 0.25f), (double)(driveablePosition.position.x + 0.25f), (double)(driveablePosition.position.y + 0.25f), (double)(driveablePosition.position.z + 0.25f)), 0.0, 0.0, 0.0);
            }
            GlStateManager.func_179131_c((float)0.0f, (float)1.0f, (float)0.0f, (float)0.3f);
            for (ShootPoint point : type.shootPointsSecondary) {
                driveablePosition = point.rootPos;
                ModelDriveable.renderOffsetAABB(new AxisAlignedBB((double)(driveablePosition.position.x - 0.25f), (double)(driveablePosition.position.y - 0.25f), (double)(driveablePosition.position.z - 0.25f), (double)(driveablePosition.position.x + 0.25f), (double)(driveablePosition.position.y + 0.25f), (double)(driveablePosition.position.z + 0.25f)), 0.0, 0.0, 0.0);
            }
            GlStateManager.func_179098_w();
            GlStateManager.func_179126_j();
            GlStateManager.func_179084_k();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        GlStateManager.func_179121_F();
        if (mecha.isPartIntact(EnumDriveablePart.hips)) {
            this.func_180548_c(mecha);
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)((float)d), (float)((float)d1), (float)((float)d2));
            for (dYaw = mecha.legAxes.getYaw() - mecha.prevLegsYaw; dYaw > 180.0f; dYaw -= 360.0f) {
            }
            while (dYaw <= -180.0f) {
                dYaw += 360.0f;
            }
            GlStateManager.func_179114_b((float)(-dYaw * f1 - mecha.prevLegsYaw), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(mecha.field_70127_C + dPitch * f1), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179114_b((float)(mecha.prevRotationRoll + dRoll * f1), (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179152_a((float)modelScale, (float)modelScale, (float)modelScale);
            if (model != null) {
                float legLength = type.legLength;
                float rearlegLength = type.RearlegLength;
                float frontlegLength = type.FrontlegLength;
                float legTrans = type.LegTrans;
                float rearlegTrans = type.RearLegTrans;
                float frontlegTrans = type.FrontLegTrans;
                float legsYaw = (float)Math.sin(((float)mecha.field_70173_aa + f1) / type.legSwingTime) * mecha.legSwing;
                float footH = (float)Math.sin(legsYaw) * legLength;
                float footV = (float)Math.cos(legsYaw) * legLength;
                float footRH = (float)Math.sin(legsYaw) * rearlegLength;
                float footRV = (float)Math.cos(legsYaw) * rearlegLength;
                float footFH = (float)Math.sin(legsYaw) * frontlegLength;
                float footFV = (float)Math.cos(legsYaw) * frontlegLength;
                model.renderHips(scale, mecha, f1);
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)legTrans, (float)legLength, (float)0.0f);
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)footH, (float)(-footV), (float)0.0f);
                model.renderLeftFoot(scale, mecha, f1);
                GlStateManager.func_179121_F();
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)(-footH), (float)(-footV), (float)0.0f);
                model.renderRightFoot(scale, mecha, f1);
                GlStateManager.func_179121_F();
                GlStateManager.func_179094_E();
                GlStateManager.func_179114_b((float)(legsYaw * 180.0f / (float)Math.PI), (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179109_b((float)0.0f, (float)(-legLength), (float)0.0f);
                model.renderLeftLeg(scale, mecha, f1);
                GlStateManager.func_179121_F();
                GlStateManager.func_179094_E();
                GlStateManager.func_179114_b((float)(-legsYaw * 180.0f / (float)Math.PI), (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179109_b((float)0.0f, (float)(-legLength), (float)0.0f);
                model.renderRightLeg(scale, mecha, f1);
                GlStateManager.func_179121_F();
                GlStateManager.func_179121_F();
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)rearlegTrans, (float)rearlegLength, (float)0.0f);
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)(-footRH), (float)(-footRV), (float)0.0f);
                model.renderLeftRearFoot(scale, mecha, f1);
                GlStateManager.func_179121_F();
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)footRH, (float)(-footRV), (float)0.0f);
                model.renderRightRearFoot(scale, mecha, f1);
                GlStateManager.func_179121_F();
                GlStateManager.func_179094_E();
                GlStateManager.func_179114_b((float)(-legsYaw * 180.0f / (float)Math.PI), (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179109_b((float)0.0f, (float)(-rearlegLength), (float)0.0f);
                model.renderLeftRearLeg(scale, mecha, f1);
                GlStateManager.func_179121_F();
                GlStateManager.func_179094_E();
                GlStateManager.func_179114_b((float)(legsYaw * 180.0f / (float)Math.PI), (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179109_b((float)0.0f, (float)(-rearlegLength), (float)0.0f);
                model.renderRightRearLeg(scale, mecha, f1);
                GlStateManager.func_179121_F();
                GlStateManager.func_179121_F();
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)frontlegTrans, (float)frontlegLength, (float)0.0f);
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)(-footFH), (float)(-footFV), (float)0.0f);
                model.renderLeftFrontFoot(scale, mecha, f1);
                GlStateManager.func_179121_F();
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)footFH, (float)(-footFV), (float)0.0f);
                model.renderRightFrontFoot(scale, mecha, f1);
                GlStateManager.func_179121_F();
                GlStateManager.func_179094_E();
                GlStateManager.func_179114_b((float)(-legsYaw * 180.0f / (float)Math.PI), (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179109_b((float)0.0f, (float)(-frontlegLength), (float)0.0f);
                model.renderLeftFrontLeg(scale, mecha, f1);
                GlStateManager.func_179121_F();
                GlStateManager.func_179094_E();
                GlStateManager.func_179114_b((float)(legsYaw * 180.0f / (float)Math.PI), (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179109_b((float)0.0f, (float)(-frontlegLength), (float)0.0f);
                model.renderRightFrontLeg(scale, mecha, f1);
                GlStateManager.func_179121_F();
                GlStateManager.func_179121_F();
            }
            GlStateManager.func_179121_F();
        }
    }

    protected ResourceLocation getEntityTexture(EntityMecha entity) {
        DriveableType type = entity.getDriveableType();
        Paintjob paintjob = type.getPaintjob(entity.getDriveableData().paintjobID);
        return FlansModResourceHandler.getPaintjobTexture(paintjob);
    }

    private void renderItem(EntityMecha mecha, ItemStack stack, int par3, boolean leftHand, float dT) {
        GlStateManager.func_179094_E();
        TextureManager texturemanager = Minecraft.func_71410_x().func_110434_K();
        Item item = stack.func_77973_b();
        if (item instanceof ItemMechaAddon) {
            GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)0.0f);
            ItemMechaAddon toolItem = (ItemMechaAddon)item;
            MechaItemType toolType = toolItem.type;
            this.func_110776_a(FlansModResourceHandler.getTexture(toolType));
            if (toolType.model != null) {
                toolType.model.render(mecha, dT);
                GlStateManager.func_179094_E();
                if (leftHand && mecha.primaryShootHeld || !leftHand && mecha.secondaryShootHeld) {
                    GlStateManager.func_179114_b((float)(25.0f * (float)mecha.field_70173_aa), (float)1.0f, (float)0.0f, (float)0.0f);
                }
                toolType.model.renderDrill(mecha, dT);
                GlStateManager.func_179121_F();
                toolType.model.renderSaw(mecha, dT, leftHand && mecha.primaryShootHeld || !leftHand && mecha.secondaryShootHeld);
            }
        } else if (item instanceof ItemGun && ((ItemGun)item).GetType().model != null) {
            GunType gunType = ((ItemGun)item).GetType();
            ModelGun model = gunType.model;
            GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            texturemanager.func_110577_a(FlansModResourceHandler.getTexture(gunType));
            ClientProxy.gunRenderer.renderGun(stack, gunType, 0.0625f, model, leftHand ? mecha.leftAnimations : mecha.rightAnimations, 0.0f);
        } else {
            GlStateManager.func_179114_b((float)-135.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179109_b((float)0.0f, (float)-0.4f, (float)0.0f);
            IBakedModel ibakedmodel = renderItem.func_175037_a().func_178089_a(stack);
            renderItem.func_180454_a(stack, ibakedmodel);
            GlStateManager.func_179101_C();
        }
        GlStateManager.func_179121_F();
    }

    @Override
    public void renderItem(CustomItemRenderType type, EnumHand hand, ItemStack item, Object ... data) {
        GlStateManager.func_179094_E();
        if (item != null && item.func_77973_b() instanceof ItemMecha) {
            MechaType mechaType = ((ItemMecha)item.func_77973_b()).type;
            if (mechaType.model != null) {
                float scale = 2.0f;
                switch (type) {
                    case INVENTORY: {
                        scale = 1.0f;
                        GlStateManager.func_179109_b((float)0.0f, (float)-0.35f, (float)0.0f);
                        break;
                    }
                    case ENTITY: {
                        scale = 1.5f;
                        break;
                    }
                    case EQUIPPED: {
                        GlStateManager.func_179114_b((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                        GlStateManager.func_179114_b((float)270.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                        GlStateManager.func_179114_b((float)270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                        GlStateManager.func_179109_b((float)0.0f, (float)0.25f, (float)0.0f);
                        scale = 0.5f;
                        break;
                    }
                    case EQUIPPED_FIRST_PERSON: {
                        GlStateManager.func_179114_b((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                        GlStateManager.func_179109_b((float)-0.5f, (float)0.5f, (float)-0.5f);
                        scale = 1.0f;
                        break;
                    }
                }
                GlStateManager.func_179152_a((float)(scale / mechaType.cameraDistance), (float)(scale / mechaType.cameraDistance), (float)(scale / mechaType.cameraDistance));
                Minecraft.func_71410_x().field_71446_o.func_110577_a(FlansModResourceHandler.getTexture(mechaType));
                ModelDriveable model = mechaType.model;
                model.render(mechaType);
            }
        }
        GlStateManager.func_179121_F();
    }

    public static class Factory
    implements IRenderFactory<EntityMecha> {
        public Render<EntityMecha> createRenderFor(RenderManager manager) {
            return new RenderMecha(manager);
        }
    }
}

