/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.client.handlers;

import com.flansmod.client.ClientRenderHooks;
import com.flansmod.client.FlansModClient;
import com.flansmod.client.handlers.KeyInputHandler;
import com.flansmod.client.handlers.MouseInputHandler;
import com.flansmod.client.model.InstantBulletRenderer;
import com.flansmod.client.model.RenderFlag;
import com.flansmod.client.model.RenderGun;
import com.flansmod.common.FlansMod;
import com.flansmod.common.guns.ItemGun;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderItemInFrameEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.RenderSpecificHandEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ClientEventHandler {
    private KeyInputHandler keyInputHandler = new KeyInputHandler();
    private MouseInputHandler mouseInputHandler = new MouseInputHandler();
    private ClientRenderHooks renderHooks = new ClientRenderHooks();

    @SubscribeEvent
    public void renderTick(TickEvent.RenderTickEvent event) {
        switch (event.phase) {
            case START: {
                RenderGun.smoothing = event.renderTickTime;
                FlansModClient.updateCameraZoom(event.renderTickTime);
                this.renderHooks.setPartialTick(event.renderTickTime);
                this.renderHooks.updatePlayerView();
                break;
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void clientTick(TickEvent.ClientTickEvent event) {
        switch (event.phase) {
            case START: {
                FlansMod.getPacketHandler().handleClientPackets();
                FlansModClient.updateFlashlights(Minecraft.func_71410_x());
                break;
            }
            case END: {
                InstantBulletRenderer.UpdateAllTrails();
                this.renderHooks.update();
                RenderFlag.angle += 2.0f;
                FlansModClient.tick();
                this.keyInputHandler.checkTickKeys();
            }
        }
    }

    @SubscribeEvent
    public void chatMessage(ClientChatReceivedEvent event) {
        if (event.getMessage().func_150260_c().equals("#flansmod")) {
            event.setCanceled(true);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void checkMouseInput(MouseEvent event) {
        this.mouseInputHandler.checkMouseInput(event);
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player.func_184614_ca().func_77973_b() instanceof ItemGun && ((ItemGun)player.func_184614_ca().func_77973_b()).GetType().oneHanded && Minecraft.func_71410_x().field_71474_y.field_74311_E.func_151470_d() && Math.abs(event.getDwheel()) > 0) {
            event.setCanceled(true);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onKeyInput(InputEvent.KeyInputEvent event) {
        this.keyInputHandler.checkEventKeys();
    }

    @SubscribeEvent
    public void renderWorld(RenderWorldLastEvent event) {
        InstantBulletRenderer.RenderAllTrails(event.getPartialTicks());
    }

    @SubscribeEvent
    public void renderItemFrame(RenderItemInFrameEvent event) {
        this.renderHooks.renderItemFrame(event);
    }

    @SubscribeEvent
    public void renderHeldItem(RenderSpecificHandEvent event) {
        this.renderHooks.renderHeldItem(event);
    }

    @SubscribeEvent
    public void renderThirdPersonWeapons(RenderLivingEvent.Pre event) {
        this.renderHooks.renderThirdPersonWeapons(event);
    }

    @SubscribeEvent
    public void renderPlayer(RenderPlayerEvent.Pre event) {
        this.renderHooks.renderPlayer(event);
    }

    @SubscribeEvent
    public void cameraSetup(EntityViewRenderEvent.CameraSetup event) {
        this.renderHooks.cameraSetup(event);
    }

    @SubscribeEvent
    public void ModifyHUD(RenderGameOverlayEvent event) {
        this.renderHooks.modifyHUD(event);
    }
}

