/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.client.gui.teams;

import com.flansmod.client.gui.teams.EnumLoadoutSlot;
import com.flansmod.client.gui.teams.GuiTeamsBase;
import com.flansmod.client.teams.ClientTeamsData;
import com.flansmod.common.FlansMod;
import com.flansmod.common.guns.AttachmentType;
import com.flansmod.common.guns.EnumAttachmentType;
import com.flansmod.common.guns.GunType;
import com.flansmod.common.guns.ItemGun;
import com.flansmod.common.guns.ItemShootable;
import com.flansmod.common.guns.Paintjob;
import com.flansmod.common.guns.ShootableType;
import com.flansmod.common.paintjob.IPaintableItem;
import com.flansmod.common.paintjob.PaintableType;
import com.flansmod.common.teams.LoadoutPool;
import com.flansmod.common.teams.PlayerLoadout;
import com.flansmod.common.teams.PlayerRankData;
import com.flansmod.common.teams.TeamsManagerRanked;
import com.flansmod.common.types.IFlanItem;
import com.flansmod.common.types.InfoType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;

public class GuiEditLoadout
extends GuiTeamsBase {
    private static final ResourceLocation texture = new ResourceLocation("flansmod", "gui/LoadoutEditor.png");
    private static final int WIDTH = 326;
    private static final int HEIGHT = 198;
    protected int selectedLoadout = 0;
    protected EnumLoadoutSlot selectedSlot = EnumLoadoutSlot.primary;
    protected int selectedCategory = 0;
    protected int scroller = 0;
    private PlayerLoadout previousLoadout = null;
    protected ArrayList<LoadoutPool.LoadoutEntry> availableComponents = new ArrayList();
    private static final String[] WEAPON_COMPONENT_NAMES = new String[]{"Weapon", "Paint", "Scope", "Barrel", "Stock", "Grip", "Extra"};
    private static final String[] NON_WEAPON_COMPONENT_NAMES = new String[]{"Item", "Paint"};

    public GuiEditLoadout(int i) {
        this.selectedLoadout = i;
        this.previousLoadout = ClientTeamsData.theRankData.loadouts[this.selectedLoadout].copy();
        this.RecalculateAvailableEntries();
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        ScaledResolution scaledresolution = new ScaledResolution(this.field_146297_k);
        int w = scaledresolution.func_78326_a();
        int h = scaledresolution.func_78328_b();
        this.guiOriginX = w / 2 - 163;
        this.guiOriginY = h / 2 - 99;
        this.field_146292_n.add(new GuiButton(0, this.field_146294_l / 2 - 163 + 10, this.field_146295_m / 2 - 99 + 143, 82, 20, "Confirm"));
        this.field_146292_n.add(new GuiButton(1, this.field_146294_l / 2 - 163 + 10, this.field_146295_m / 2 - 99 + 165, 82, 20, "Cancel"));
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146127_k == 0) {
            TeamsManagerRanked.ConfirmLoadoutChanges();
            ClientTeamsData.OpenLandingPage();
        } else if (button.field_146127_k == 1) {
            ClientTeamsData.theRankData.loadouts[this.selectedLoadout] = this.previousLoadout.copy();
            ClientTeamsData.OpenLandingPage();
        }
    }

    @Override
    public void func_73863_a(int i, int j, float f) {
        InfoType type;
        ItemStack stack;
        int n;
        ScaledResolution scaledresolution = new ScaledResolution(this.field_146297_k);
        int w = scaledresolution.func_78326_a();
        int h = scaledresolution.func_78328_b();
        this.func_146276_q_();
        GlStateManager.func_179147_l();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.guiOriginX = w / 2 - 163;
        this.guiOriginY = h / 2 - 99;
        this.field_146297_k.field_71446_o.func_110577_a(texture);
        int textureX = 512;
        int textureY = 256;
        PlayerRankData data = ClientTeamsData.theRankData;
        LoadoutPool pool = ClientTeamsData.currentPool;
        if (data == null || pool == null) {
            FlansMod.log.warn("Problem in landing page!");
            return;
        }
        GuiEditLoadout.func_146110_a((int)this.guiOriginX, (int)this.guiOriginY, (float)0.0f, (float)0.0f, (int)326, (int)198, (float)textureX, (float)textureY);
        this.func_73732_a(this.field_146289_q, "Edit Loadout " + (this.selectedLoadout + 1), this.guiOriginX + 163, this.guiOriginY + 4, 0xFFFFFF);
        this.field_146297_k.field_71446_o.func_110577_a(texture);
        GuiEditLoadout.func_146110_a((int)(this.guiOriginX + 70), (int)(this.guiOriginY + 32 + 22 * this.selectedSlot.ordinal()), (float)70.0f, (float)203.0f, (int)36, (int)22, (float)textureX, (float)textureY);
        this.func_73732_a(this.field_146289_q, "Loadout", this.guiOriginX + 51, this.guiOriginY + 18, 0xFFFFFF);
        for (n = 0; n < EnumLoadoutSlot.values().length; ++n) {
            this.func_73732_a(this.field_146289_q, EnumLoadoutSlot.values()[n].name, this.guiOriginX + 39, this.guiOriginY + 38 + 22 * n, 0xFFFFFF);
            stack = data.loadouts[this.selectedLoadout].slots[n];
            this.drawSlotInventory(stack, this.guiOriginX + 73, this.guiOriginY + 35 + 22 * n);
        }
        this.field_146297_k.field_71446_o.func_110577_a(texture);
        GuiEditLoadout.func_146110_a((int)(this.guiOriginX + 169), (int)(this.guiOriginY + 32 + 22 * this.selectedCategory), (float)70.0f, (float)203.0f, (int)36, (int)22, (float)textureX, (float)textureY);
        this.func_73732_a(this.field_146289_q, this.selectedSlot.name, this.guiOriginX + 150, this.guiOriginY + 18, 0xFFFFFF);
        if (this.selectedSlot.isWeapon) {
            block16: for (n = 0; n < WEAPON_COMPONENT_NAMES.length; ++n) {
                int numUnlocks;
                stack = data.loadouts[this.selectedLoadout].slots[this.selectedSlot.ordinal()];
                type = stack != null && stack.func_77973_b() instanceof IFlanItem ? ((IFlanItem)stack.func_77973_b()).getInfoType() : null;
                int n2 = numUnlocks = type != null ? data.GetNumUnlocksForType(type) : 0;
                if (n == 1 && type != null && numUnlocks > 0) {
                    this.func_73732_a(this.field_146289_q, WEAPON_COMPONENT_NAMES[n] + " (" + numUnlocks + ")", this.guiOriginX + 138, this.guiOriginY + 38 + 22 * n, 0xFFFFFF);
                } else {
                    this.func_73732_a(this.field_146289_q, WEAPON_COMPONENT_NAMES[n], this.guiOriginX + 138, this.guiOriginY + 38 + 22 * n, 0xFFFFFF);
                }
                switch (n) {
                    case 0: {
                        ItemStack copy = ItemStack.field_190927_a.func_77946_l();
                        if (stack != null) {
                            copy = stack.func_77946_l();
                            copy.func_77964_b(0);
                        }
                        this.drawSlotInventory(copy, this.guiOriginX + 172, this.guiOriginY + 35 + 22 * n);
                        continue block16;
                    }
                    case 1: {
                        this.drawSlotInventory(stack, this.guiOriginX + 172, this.guiOriginY + 35 + 22 * n);
                        continue block16;
                    }
                    default: {
                        NBTTagCompound attachmentTags;
                        if (stack == null || stack.func_190926_b() || stack.func_77978_p() == null || (attachmentTags = stack.func_77978_p().func_74775_l("attachments")) == null) continue block16;
                        ItemStack attachmentStack = ItemStack.field_190927_a.func_77946_l();
                        switch (n) {
                            case 2: {
                                attachmentStack = new ItemStack(attachmentTags.func_74775_l("scope"));
                                break;
                            }
                            case 3: {
                                attachmentStack = new ItemStack(attachmentTags.func_74775_l("barrel"));
                                break;
                            }
                            case 4: {
                                attachmentStack = new ItemStack(attachmentTags.func_74775_l("stock"));
                                break;
                            }
                            case 5: {
                                attachmentStack = new ItemStack(attachmentTags.func_74775_l("grip"));
                                break;
                            }
                            case 6: {
                                attachmentStack = new ItemStack(attachmentTags.func_74775_l("generic_0"));
                            }
                        }
                        this.drawSlotInventory(attachmentStack, this.guiOriginX + 172, this.guiOriginY + 35 + 22 * n);
                    }
                }
            }
        } else {
            block17: for (n = 0; n < NON_WEAPON_COMPONENT_NAMES.length; ++n) {
                this.func_73732_a(this.field_146289_q, NON_WEAPON_COMPONENT_NAMES[n], this.guiOriginX + 138, this.guiOriginY + 38 + 22 * n, 0xFFFFFF);
                stack = data.loadouts[this.selectedLoadout].slots[this.selectedSlot.ordinal()];
                switch (n) {
                    case 0: {
                        ItemStack copy = ItemStack.field_190927_a.func_77946_l();
                        if (stack != null) {
                            copy = stack.func_77946_l();
                            copy.func_77964_b(0);
                        }
                        this.drawSlotInventory(copy, this.guiOriginX + 172, this.guiOriginY + 35 + 22 * n);
                        continue block17;
                    }
                    case 1: {
                        this.drawSlotInventory(stack, this.guiOriginX + 172, this.guiOriginY + 35 + 22 * n);
                        continue block17;
                    }
                }
            }
        }
        String name = "";
        stack = data.loadouts[this.selectedLoadout].slots[this.selectedSlot.ordinal()];
        if (stack != null && !stack.func_190926_b()) {
            name = stack.func_82833_r();
        }
        this.func_73732_a(this.field_146289_q, name, this.guiOriginX + 262, this.guiOriginY + 18, 0xFFFFFF);
        this.DrawGun(stack, this.guiOriginX + 254, this.guiOriginY + 48, 40.0f);
        this.func_73732_a(this.field_146289_q, "Damage", this.guiOriginX + 234, this.guiOriginY + 60, 0xFFFFFF);
        this.func_73732_a(this.field_146289_q, "Accuracy", this.guiOriginX + 234, this.guiOriginY + 70, 0xFFFFFF);
        this.func_73732_a(this.field_146289_q, "Ammo", this.guiOriginX + 234, this.guiOriginY + 80, 0xFFFFFF);
        if (stack != null && stack.func_77973_b() instanceof ItemGun) {
            type = ((ItemGun)stack.func_77973_b()).GetType();
            LoadoutPool.LoadoutEntryInfoType entry = pool.GetLoadoutEntryForInfoType(this.selectedSlot.ordinal(), type);
            ShootableType mainAmmo = null;
            int numClips = 1;
            for (ItemStack extra : entry.extraItems) {
                if (extra == null || !(extra.func_77973_b() instanceof ItemShootable)) continue;
                mainAmmo = ((ItemShootable)extra.func_77973_b()).type;
                numClips = extra.func_190916_E();
                break;
            }
            if (mainAmmo != null) {
                this.func_73732_a(this.field_146289_q, String.format("%.0f", Float.valueOf(((GunType)type).damage * mainAmmo.damageVsLiving * (float)mainAmmo.numBullets)), this.guiOriginX + 290, this.guiOriginY + 60, 0xFFFFFF);
                this.func_73732_a(this.field_146289_q, String.format("%.0f", Float.valueOf((50.0f - ((GunType)type).bulletSpread) * 2.0f)), this.guiOriginX + 290, this.guiOriginY + 70, 0xFFFFFF);
                this.func_73732_a(this.field_146289_q, String.format("%d", mainAmmo.roundsPerItem * numClips), this.guiOriginX + 290, this.guiOriginY + 80, 0xFFFFFF);
            }
        }
        this.func_73732_a(this.field_146289_q, "Choose " + WEAPON_COMPONENT_NAMES[this.selectedCategory].toLowerCase(), this.guiOriginX + 262, this.guiOriginY + 95, 0xFFFFFF);
        for (int row = 0; row < 4; ++row) {
            for (int col = 0; col < 6; ++col) {
                int index = this.scroller * 24 + row * 6 + col;
                if (index >= this.availableComponents.size()) continue;
                LoadoutPool.LoadoutEntry entry = this.availableComponents.get(index);
                if (entry instanceof LoadoutPool.LoadoutEntryInfoType) {
                    this.drawSlotInventory(new ItemStack(((LoadoutPool.LoadoutEntryInfoType)entry).type.getItem()), this.guiOriginX + 209 + col * 18, this.guiOriginY + 107 + row * 18);
                } else if (entry instanceof LoadoutPool.LoadoutEntryPaintjob) {
                    Paintjob paintjob = ((LoadoutPool.LoadoutEntryPaintjob)entry).paintjob;
                    this.DrawRarityBackground(paintjob.rarity, this.guiOriginX + 209 + col * 18, this.guiOriginY + 107 + row * 18);
                    this.drawSlotInventory(new ItemStack(paintjob.parent.getItem(), 1, paintjob.ID), this.guiOriginX + 209 + col * 18, this.guiOriginY + 107 + row * 18);
                }
                if (entry.available) continue;
                this.field_146297_k.field_71446_o.func_110577_a(texture);
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)101.0f);
                GuiEditLoadout.func_146110_a((int)(this.guiOriginX + 209 + col * 18), (int)(this.guiOriginY + 107 + row * 18), (float)332.0f, (float)161.0f, (int)16, (int)16, (float)textureX, (float)textureY);
                if (entry.unlockLevel > 0) {
                    this.func_73732_a(this.field_146289_q, "" + entry.unlockLevel, this.guiOriginX + 218 + col * 18, this.guiOriginY + 112 + row * 18, 0xFFFFFF);
                }
                GlStateManager.func_179121_F();
            }
        }
        this.drawSlotInventory(new ItemStack(Items.field_151055_y), -50, -50);
        super.func_73863_a(i, j, f);
    }

    private boolean IsInSquare(int clickX, int clickY, int x, int y, int w, int h) {
        return x <= clickX && clickX < x + w && y <= clickY && clickY < y + h;
    }

    protected void func_73864_a(int i, int j, int k) throws IOException {
        super.func_73864_a(i, j, k);
        int x = i - this.guiOriginX;
        int y = j - this.guiOriginY;
        if (k == 0 || k == 1) {
            int n;
            for (n = 0; n < EnumLoadoutSlot.values().length; ++n) {
                if (!this.IsInSquare(x, y, 70, 32 + 22 * n, 22, 22)) continue;
                this.selectedSlot = EnumLoadoutSlot.values()[n];
                this.selectedCategory = 0;
                this.RecalculateAvailableEntries();
            }
            if (this.selectedSlot.isWeapon) {
                for (n = 0; n < WEAPON_COMPONENT_NAMES.length; ++n) {
                    if (!this.IsInSquare(x, y, 169, 32 + 22 * n, 22, 22)) continue;
                    this.selectedCategory = n;
                    this.RecalculateAvailableEntries();
                }
            } else {
                for (n = 0; n < NON_WEAPON_COMPONENT_NAMES.length; ++n) {
                    if (!this.IsInSquare(x, y, 169, 32 + 22 * n, 22, 22)) continue;
                    this.selectedCategory = n;
                    this.RecalculateAvailableEntries();
                }
            }
            for (int row = 0; row < 4; ++row) {
                for (int col = 0; col < 6; ++col) {
                    int index = this.scroller * 24 + row * 6 + col;
                    if (index >= this.availableComponents.size() || !this.availableComponents.get((int)index).available || !this.IsInSquare(x, y, 209 + col * 18, 107 + row * 18, 18, 18)) continue;
                    LoadoutPool.LoadoutEntry entry = this.availableComponents.get(index);
                    this.SelectItem(entry);
                }
            }
            if (this.IsInSquare(x, y, 257, 179, 10, 10)) {
                this.SelectItem(null);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void SelectItem(LoadoutPool.LoadoutEntry entry) {
        PlayerRankData data = ClientTeamsData.theRankData;
        LoadoutPool pool = ClientTeamsData.currentPool;
        switch (this.selectedCategory) {
            case 0: {
                if (entry instanceof LoadoutPool.LoadoutEntryInfoType) {
                    data.loadouts[this.selectedLoadout].slots[this.selectedSlot.ordinal()] = new ItemStack(((LoadoutPool.LoadoutEntryInfoType)entry).type.getItem());
                    return;
                }
                if (entry == null) return;
                FlansMod.log.warn("Loadout entry doesn't match for slot");
                return;
            }
            case 1: {
                if (entry instanceof LoadoutPool.LoadoutEntryPaintjob) {
                    if (data.loadouts[this.selectedLoadout].slots[this.selectedSlot.ordinal()] != null) {
                        data.loadouts[this.selectedLoadout].slots[this.selectedSlot.ordinal()].func_77964_b(((LoadoutPool.LoadoutEntryPaintjob)entry).paintjob.ID);
                        break;
                    }
                    FlansMod.log.warn("Applying paintjob to null item!");
                    break;
                }
                if (entry == null) break;
                FlansMod.log.warn("Loadout entry doesn't match slot");
            }
        }
        if (entry instanceof LoadoutPool.LoadoutEntryInfoType || entry == null) {
            ItemStack stack = data.loadouts[this.selectedLoadout].slots[this.selectedSlot.ordinal()];
            if (stack != null && !stack.func_190926_b()) {
                NBTTagCompound attachmentTags;
                if (stack.func_77978_p() == null) {
                    stack.func_77982_d(new NBTTagCompound());
                }
                if ((attachmentTags = stack.func_77978_p().func_74775_l("attachments")) == null) {
                    attachmentTags = new NBTTagCompound();
                }
                NBTTagCompound ourTags = new NBTTagCompound();
                if (entry != null) {
                    ItemStack attachmentStack = new ItemStack(((LoadoutPool.LoadoutEntryInfoType)entry).type.getItem());
                    attachmentStack.func_77955_b(ourTags);
                }
                switch (this.selectedCategory) {
                    case 2: {
                        attachmentTags.func_74782_a("scope", (NBTBase)ourTags);
                        break;
                    }
                    case 3: {
                        attachmentTags.func_74782_a("barrel", (NBTBase)ourTags);
                        break;
                    }
                    case 4: {
                        attachmentTags.func_74782_a("stock", (NBTBase)ourTags);
                        break;
                    }
                    case 5: {
                        attachmentTags.func_74782_a("grip", (NBTBase)ourTags);
                        break;
                    }
                    case 6: {
                        attachmentTags.func_74782_a("generic_0", (NBTBase)ourTags);
                        break;
                    }
                }
                stack.func_77978_p().func_74782_a("attachments", (NBTBase)attachmentTags);
                return;
            }
            FlansMod.log.warn("Applying attachment to null item!");
            return;
        }
        FlansMod.log.warn("Loadout entry doesn't match for slot");
    }

    public void RecalculateAvailableEntries() {
        this.availableComponents.clear();
        PlayerRankData data = ClientTeamsData.theRankData;
        LoadoutPool pool = ClientTeamsData.currentPool;
        ArrayList<LoadoutPool.LoadoutEntry> unlockedEntries = new ArrayList<LoadoutPool.LoadoutEntry>();
        ArrayList<LoadoutPool.LoadoutEntry> lockedEntries = new ArrayList<LoadoutPool.LoadoutEntry>();
        if (this.selectedCategory == 1) {
            ItemStack stack = data.loadouts[this.selectedLoadout].slots[this.selectedSlot.ordinal()];
            if (stack != null && stack.func_77973_b() instanceof IPaintableItem) {
                PaintableType type = ((IPaintableItem)stack.func_77973_b()).GetPaintableType();
                for (int i = 0; i < type.paintjobs.size(); ++i) {
                    LoadoutPool.LoadoutEntryPaintjob entry = new LoadoutPool.LoadoutEntryPaintjob();
                    entry.unlockLevel = 0;
                    entry.paintjob = type.paintjobs.get(i);
                    entry.available = i == 0 ? true : TeamsManagerRanked.LocalPlayerOwnsUnlock(entry.paintjob.hashCode());
                    if (entry.available) {
                        unlockedEntries.add(entry);
                        continue;
                    }
                    lockedEntries.add(entry);
                }
            }
        } else {
            block12: for (LoadoutPool.LoadoutEntryInfoType entry : pool.unlocks[this.selectedSlot.ordinal()]) {
                switch (this.selectedCategory) {
                    case 0: {
                        if (!(entry.type instanceof AttachmentType)) break;
                        continue block12;
                    }
                    case 1: {
                        break;
                    }
                    default: {
                        if (!(entry.type instanceof AttachmentType)) continue block12;
                        GunType gunType = ((ItemGun)data.loadouts[this.selectedLoadout].slots[this.selectedSlot.ordinal()].func_77973_b()).GetType();
                        if (!gunType.allowAllAttachments && !gunType.allowedAttachments.contains(entry.type)) continue block12;
                        EnumAttachmentType attachType = ((AttachmentType)entry.type).type;
                        switch (this.selectedCategory) {
                            case 2: {
                                if (attachType == EnumAttachmentType.sights) break;
                                continue block12;
                            }
                            case 3: {
                                if (attachType == EnumAttachmentType.barrel) break;
                                continue block12;
                            }
                            case 4: {
                                if (attachType == EnumAttachmentType.stock) break;
                                continue block12;
                            }
                            case 5: {
                                if (attachType == EnumAttachmentType.grip) break;
                                continue block12;
                            }
                            case 6: {
                                if (attachType == EnumAttachmentType.generic) break;
                                continue block12;
                            }
                        }
                        break;
                    }
                }
                LoadoutPool.LoadoutEntryInfoType copy = new LoadoutPool.LoadoutEntryInfoType();
                copy.type = entry.type;
                copy.unlockLevel = entry.unlockLevel;
                boolean bl = copy.available = data.currentLevel >= copy.unlockLevel;
                if (copy.available) {
                    unlockedEntries.add(copy);
                    continue;
                }
                lockedEntries.add(copy);
            }
        }
        unlockedEntries.sort(new LoadoutComparator());
        lockedEntries.sort(new LoadoutComparator());
        this.availableComponents.addAll(unlockedEntries);
        this.availableComponents.addAll(lockedEntries);
    }

    @Override
    public boolean func_73868_f() {
        return false;
    }

    public class LoadoutComparator
    implements Comparator<LoadoutPool.LoadoutEntry> {
        @Override
        public int compare(LoadoutPool.LoadoutEntry a, LoadoutPool.LoadoutEntry b) {
            if (a.unlockLevel < b.unlockLevel) {
                return -1;
            }
            if (a.unlockLevel > b.unlockLevel) {
                return 1;
            }
            if (a instanceof LoadoutPool.LoadoutEntryPaintjob && b instanceof LoadoutPool.LoadoutEntryPaintjob) {
                if (((LoadoutPool.LoadoutEntryPaintjob)a).paintjob.rarity.ordinal() < ((LoadoutPool.LoadoutEntryPaintjob)b).paintjob.rarity.ordinal()) {
                    return -1;
                }
                if (((LoadoutPool.LoadoutEntryPaintjob)a).paintjob.rarity.ordinal() > ((LoadoutPool.LoadoutEntryPaintjob)b).paintjob.rarity.ordinal()) {
                    return 1;
                }
            }
            return 0;
        }
    }
}

