/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.common.utils.math.geo;

import com.creativemd.creativecore.common.utils.math.VectorUtils;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import net.minecraft.util.EnumFacing;

public class Ray3f {
    public final Vector3f origin;
    public final Vector3f direction;

    public Ray3f(Vector3f start, Vector3f end) {
        this.origin = start;
        this.direction = new Vector3f(end);
        this.direction.sub((Tuple3f)this.origin);
        this.direction.normalize();
    }

    public Ray3f(Vector3f origin, EnumFacing facing) {
        this.origin = origin;
        this.direction = new Vector3f();
        VectorUtils.set((Tuple3f)this.direction, (float)facing.func_176743_c().func_179524_a(), facing.func_176740_k());
    }

    public void set(float x, float y, float z, float x2, float y2, float z2) {
        this.origin.set(x, y, z);
        this.direction.set(x2, y2, z2);
        this.direction.sub((Tuple3f)this.origin);
    }

    public double getT(EnumFacing.Axis axis, double value) {
        return (value - (double)VectorUtils.get(axis, (Tuple3f)this.origin)) / (double)VectorUtils.get(axis, (Tuple3f)this.direction);
    }

    public Vector3f get(float t) {
        return new Vector3f(this.origin.x + this.direction.x * t, this.origin.y + this.direction.y * t, this.origin.z + this.direction.z * t);
    }
}

