/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.common.utils.math.collision;

import com.creativemd.creativecore.common.utils.math.VectorUtils;
import com.creativemd.creativecore.common.utils.math.geo.Ray2d;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.vecmath.Tuple2f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector2f;
import javax.vecmath.Vector3f;
import net.minecraft.util.EnumFacing;
import org.apache.commons.lang3.BooleanUtils;

public class IntersectionHelperSolid {
    public static List<Vector2f> cutMinMax(EnumFacing.Axis one, EnumFacing.Axis two, float minOne, float minTwo, float maxOne, float maxTwo, Vector3f[] corners) {
        boolean clockwise;
        if (corners.length < 3) {
            return Collections.EMPTY_LIST;
        }
        boolean insideOneMin = false;
        boolean insideTwoMin = false;
        boolean insideOneMax = false;
        boolean insideTwoMax = false;
        boolean allInside = true;
        int insideIndex = -1;
        InsideStatus[] status = new InsideStatus[corners.length];
        for (int i = 0; i < corners.length; ++i) {
            float valueOne = VectorUtils.get(one, (Tuple3f)corners[i]);
            float valueTwo = VectorUtils.get(two, (Tuple3f)corners[i]);
            status[i] = InsideStatus.get(valueOne, valueTwo, minOne, minTwo, maxOne, maxTwo);
            if (status[i].isInside()) {
                if (insideIndex == -1) {
                    insideIndex = i;
                }
                insideTwoMax = true;
                insideTwoMin = true;
                insideOneMax = true;
                insideOneMin = true;
                continue;
            }
            allInside = false;
            if (status[i].isOutsideOne()) {
                if (status[i].outsideDirectionOne().booleanValue()) {
                    insideOneMax = true;
                } else {
                    insideOneMin = true;
                }
            } else {
                insideOneMax = true;
                insideOneMin = true;
            }
            if (status[i].isOutsideTwo()) {
                if (status[i].outsideDirectionTwo().booleanValue()) {
                    insideTwoMax = true;
                    continue;
                }
                insideTwoMin = true;
                continue;
            }
            insideTwoMax = true;
            insideTwoMin = true;
        }
        float originOne = VectorUtils.get(one, (Tuple3f)corners[1]);
        float originTwo = VectorUtils.get(two, (Tuple3f)corners[1]);
        boolean bl = clockwise = (VectorUtils.get(one, (Tuple3f)corners[0]) - originOne) * (VectorUtils.get(two, (Tuple3f)corners[2]) - originTwo) - (VectorUtils.get(two, (Tuple3f)corners[0]) - originTwo) * (VectorUtils.get(one, (Tuple3f)corners[2]) - originOne) > 0.0f;
        if (allInside) {
            if (clockwise) {
                return Arrays.asList(new Vector2f(minOne, minTwo), new Vector2f(minOne, maxTwo), new Vector2f(maxOne, maxTwo), new Vector2f(maxOne, minTwo));
            }
            return Arrays.asList(new Vector2f(maxOne, minTwo), new Vector2f(maxOne, maxTwo), new Vector2f(minOne, maxTwo), new Vector2f(minOne, minTwo));
        }
        if (insideOneMin && insideOneMax && insideTwoMin && insideTwoMax) {
            Ray2d ray = new Ray2d(one, two, 0.0, 0.0, 0.0, 0.0);
            ArrayList<Vector2f> result = new ArrayList<Vector2f>();
            boolean hasFoundInside = insideIndex != -1;
            if (!hasFoundInside) {
                insideIndex = 0;
            }
            IntersectionHelperSolid.iterateLines(insideIndex, status.length, hasFoundInside, null, ray, one, two, minOne, minTwo, maxOne, maxTwo, clockwise, status, corners, result);
            if (result.isEmpty()) {
                boolean aboveOneAboveTwo = false;
                boolean aboveOneBelowTwo = false;
                boolean belowOneAboveTwo = false;
                boolean belowOneBelowTwo = false;
                for (int j = 0; j < corners.length; ++j) {
                    if (VectorUtils.get(one, (Tuple3f)corners[j]) > minOne) {
                        if (VectorUtils.get(two, (Tuple3f)corners[j]) > minTwo) {
                            aboveOneAboveTwo = true;
                            continue;
                        }
                        aboveOneBelowTwo = true;
                        continue;
                    }
                    if (VectorUtils.get(two, (Tuple3f)corners[j]) > minTwo) {
                        belowOneAboveTwo = true;
                        continue;
                    }
                    belowOneBelowTwo = true;
                }
                if (aboveOneAboveTwo && aboveOneBelowTwo && belowOneAboveTwo && belowOneBelowTwo) {
                    if (clockwise) {
                        return Arrays.asList(new Vector2f(minOne, minTwo), new Vector2f(minOne, maxTwo), new Vector2f(maxOne, maxTwo), new Vector2f(maxOne, minTwo));
                    }
                    return Arrays.asList(new Vector2f(maxOne, minTwo), new Vector2f(maxOne, maxTwo), new Vector2f(minOne, maxTwo), new Vector2f(minOne, minTwo));
                }
            }
            if (result.size() > 2) {
                return result;
            }
            return Collections.EMPTY_LIST;
        }
        return Collections.EMPTY_LIST;
    }

    private static Edge iterateLines(int offset, int count, boolean hasFoundInside, Edge edge, Ray2d ray, EnumFacing.Axis one, EnumFacing.Axis two, float minOne, float minTwo, float maxOne, float maxTwo, boolean clockwise, InsideStatus[] status, Vector3f[] corners, List<Vector2f> result) {
        float beforeOne = VectorUtils.get(one, (Tuple3f)corners[offset]);
        float beforeTwo = VectorUtils.get(two, (Tuple3f)corners[offset]);
        InsideStatus before = status[offset];
        boolean inside = before.isInside();
        if (inside) {
            IntersectionHelperSolid.add(new Vector2f(beforeOne, beforeTwo), result);
        }
        for (int i = 1; i <= count; ++i) {
            int currentIndex = (offset + i) % corners.length;
            Vector3f vec = corners[currentIndex];
            float nowOne = VectorUtils.get(one, (Tuple3f)vec);
            float nowTwo = VectorUtils.get(two, (Tuple3f)vec);
            InsideStatus current = status[currentIndex];
            if (inside) {
                if (current.isInside()) {
                    IntersectionHelperSolid.add(new Vector2f(nowOne, nowTwo), result);
                } else {
                    edge = IntersectionHelperSolid.findIntersection(ray, clockwise, minOne, minTwo, maxOne, maxTwo, current, beforeOne, beforeTwo, nowOne, nowTwo, null, result);
                    inside = false;
                }
            } else if (current.isInside()) {
                IntersectionHelperSolid.findIntersection(ray, clockwise, minOne, minTwo, maxOne, maxTwo, before, beforeOne, beforeTwo, nowOne, nowTwo, edge, result);
                IntersectionHelperSolid.add(new Vector2f(nowOne, nowTwo), result);
                edge = null;
                inside = true;
            } else {
                float tempT;
                ray.originOne = beforeOne;
                ray.originTwo = beforeTwo;
                ray.directionOne = nowOne - beforeOne;
                ray.directionTwo = nowTwo - beforeTwo;
                Edge inEdge = null;
                float inT = 1.0f;
                Edge outEdge = null;
                float outT = 0.0f;
                if (before.outsideDirectionOne() != current.outsideDirectionOne()) {
                    float valueTwo;
                    if (BooleanUtils.isFalse((Boolean)before.outsideDirectionOne()) || BooleanUtils.isFalse((Boolean)current.outsideDirectionOne())) {
                        tempT = (float)ray.getT(one, minOne);
                        valueTwo = (float)(ray.originTwo + ray.directionTwo * (double)tempT);
                        if (tempT >= 0.0f && tempT <= 1.0f && valueTwo >= minTwo && valueTwo <= maxTwo) {
                            if (tempT < inT) {
                                inEdge = Edge.MIN_ONE;
                                inT = tempT;
                            }
                            if (tempT > outT) {
                                outEdge = Edge.MIN_ONE;
                                outT = tempT;
                            }
                        }
                    }
                    if (BooleanUtils.isTrue((Boolean)before.outsideDirectionOne()) || BooleanUtils.isTrue((Boolean)current.outsideDirectionOne())) {
                        tempT = (float)ray.getT(one, maxOne);
                        valueTwo = (float)(ray.originTwo + ray.directionTwo * (double)tempT);
                        if (tempT >= 0.0f && tempT <= 1.0f && valueTwo >= minTwo && valueTwo <= maxTwo) {
                            if (tempT < inT) {
                                inEdge = Edge.MAX_ONE;
                                inT = tempT;
                            }
                            if (tempT > outT) {
                                outEdge = Edge.MAX_ONE;
                                outT = tempT;
                            }
                        }
                    }
                }
                if (before.outsideDirectionTwo() != current.outsideDirectionTwo()) {
                    float valueOne;
                    if (BooleanUtils.isFalse((Boolean)before.outsideDirectionTwo()) || BooleanUtils.isFalse((Boolean)current.outsideDirectionTwo())) {
                        tempT = (float)ray.getT(two, minTwo);
                        valueOne = (float)(ray.originOne + ray.directionOne * (double)tempT);
                        if (tempT >= 0.0f && tempT <= 1.0f && valueOne >= minOne && valueOne <= maxOne) {
                            if (tempT < inT) {
                                inEdge = Edge.MIN_TWO;
                                inT = tempT;
                            }
                            if (tempT > outT) {
                                outEdge = Edge.MIN_TWO;
                                outT = tempT;
                            }
                        }
                    }
                    if (BooleanUtils.isTrue((Boolean)before.outsideDirectionTwo()) || BooleanUtils.isTrue((Boolean)current.outsideDirectionTwo())) {
                        tempT = (float)ray.getT(two, maxTwo);
                        valueOne = (float)(ray.originOne + ray.directionOne * (double)tempT);
                        if (tempT >= 0.0f && tempT <= 1.0f && valueOne >= minOne && valueOne <= maxOne) {
                            if (tempT < inT) {
                                inEdge = Edge.MAX_TWO;
                                inT = tempT;
                            }
                            if (tempT > outT) {
                                outEdge = Edge.MAX_TWO;
                                outT = tempT;
                            }
                        }
                    }
                }
                if (inEdge != null && inEdge != outEdge) {
                    if (hasFoundInside) {
                        IntersectionHelperSolid.addCornersBetween(minOne, minTwo, maxOne, maxTwo, edge, inEdge, clockwise, result);
                        IntersectionHelperSolid.add(ray.getFloat(inT), result);
                        IntersectionHelperSolid.add(ray.getFloat(outT), result);
                        edge = outEdge;
                    } else {
                        Vector2f outVec = ray.getFloat(outT);
                        Vector2f inVec = ray.getFloat(inT);
                        IntersectionHelperSolid.add(outVec, result);
                        edge = IntersectionHelperSolid.iterateLines(currentIndex, status.length - 1, true, outEdge, ray, one, two, minOne, minTwo, maxOne, maxTwo, clockwise, status, corners, result);
                        IntersectionHelperSolid.addCornersBetween(minOne, minTwo, maxOne, maxTwo, edge, inEdge, clockwise, result);
                        IntersectionHelperSolid.add(inVec, result);
                        return null;
                    }
                }
            }
            before = current;
            beforeOne = nowOne;
            beforeTwo = nowTwo;
        }
        return edge;
    }

    private static Edge findIntersection(Ray2d ray, boolean clockwise, float minOne, float minTwo, float maxOne, float maxTwo, InsideStatus status, float beforeOne, float beforeTwo, float nowOne, float nowTwo, Edge before, List<Vector2f> result) {
        float edgeValue;
        float intersection;
        ray.originOne = beforeOne;
        ray.originTwo = beforeTwo;
        ray.directionOne = nowOne - beforeOne;
        ray.directionTwo = nowTwo - beforeTwo;
        if (status.isOutsideOne() && (intersection = (float)ray.get(ray.one, edgeValue = status.outsideDirectionOne() != false ? maxOne : minOne)) >= minTwo && intersection <= maxTwo) {
            if (before != null) {
                IntersectionHelperSolid.addCornersBetween(minOne, minTwo, maxOne, maxTwo, before, status.oneEdge(), clockwise, result);
            }
            IntersectionHelperSolid.add(new Vector2f(edgeValue, intersection), result);
            return status.oneEdge();
        }
        if (status.isOutsideTwo() && (intersection = (float)ray.get(ray.two, edgeValue = status.outsideDirectionTwo() != false ? maxTwo : minTwo)) >= minOne && intersection <= maxOne) {
            if (before != null) {
                IntersectionHelperSolid.addCornersBetween(minOne, minTwo, maxOne, maxTwo, before, status.twoEdge(), clockwise, result);
            }
            IntersectionHelperSolid.add(new Vector2f(intersection, edgeValue), result);
            return status.twoEdge();
        }
        throw new RuntimeException("Impossible");
    }

    private static void add(Vector2f vec, List<Vector2f> result) {
        if (result.isEmpty() || !result.get(result.size() - 1).epsilonEquals((Tuple2f)vec, 1.0E-4f)) {
            result.add(vec);
        }
    }

    private static void addCornersBetween(float minOne, float minTwo, float maxOne, float maxTwo, Edge start, Edge end, boolean clockwise, List<Vector2f> result) {
        Edge current = start;
        while (current != end) {
            Edge next;
            Edge edge = next = clockwise ? current.clockwise() : current.counterClockwise();
            if (current.one()) {
                IntersectionHelperSolid.add(new Vector2f(current.positive() ? maxOne : minOne, next.positive() ? maxTwo : minTwo), result);
            } else {
                IntersectionHelperSolid.add(new Vector2f(next.positive() ? maxOne : minOne, current.positive() ? maxTwo : minTwo), result);
            }
            current = next;
        }
    }

    private static enum InsideStatus {
        INSIDE{

            @Override
            public boolean isInside() {
                return true;
            }

            @Override
            public boolean isOutsideOne() {
                return false;
            }

            @Override
            public Boolean outsideDirectionOne() {
                return null;
            }

            @Override
            public boolean isOutsideTwo() {
                return false;
            }

            @Override
            public Boolean outsideDirectionTwo() {
                return null;
            }
        }
        ,
        OUTSIDE_MIN_ONE{

            @Override
            public boolean isInside() {
                return false;
            }

            @Override
            public boolean isOutsideOne() {
                return true;
            }

            @Override
            public Boolean outsideDirectionOne() {
                return false;
            }

            @Override
            public boolean isOutsideTwo() {
                return false;
            }

            @Override
            public Boolean outsideDirectionTwo() {
                return null;
            }
        }
        ,
        OUTSIDE_MAX_ONE{

            @Override
            public boolean isInside() {
                return false;
            }

            @Override
            public boolean isOutsideOne() {
                return true;
            }

            @Override
            public Boolean outsideDirectionOne() {
                return true;
            }

            @Override
            public boolean isOutsideTwo() {
                return false;
            }

            @Override
            public Boolean outsideDirectionTwo() {
                return null;
            }
        }
        ,
        OUTSIDE_MIN_TWO{

            @Override
            public boolean isInside() {
                return false;
            }

            @Override
            public boolean isOutsideOne() {
                return false;
            }

            @Override
            public Boolean outsideDirectionOne() {
                return null;
            }

            @Override
            public boolean isOutsideTwo() {
                return true;
            }

            @Override
            public Boolean outsideDirectionTwo() {
                return false;
            }
        }
        ,
        OUTSIDE_MAX_TWO{

            @Override
            public boolean isInside() {
                return false;
            }

            @Override
            public boolean isOutsideOne() {
                return false;
            }

            @Override
            public Boolean outsideDirectionOne() {
                return null;
            }

            @Override
            public boolean isOutsideTwo() {
                return true;
            }

            @Override
            public Boolean outsideDirectionTwo() {
                return true;
            }
        }
        ,
        OUTSIDE_MIN_ONE_MIN_TWO{

            @Override
            public boolean isInside() {
                return false;
            }

            @Override
            public boolean isOutsideOne() {
                return true;
            }

            @Override
            public Boolean outsideDirectionOne() {
                return false;
            }

            @Override
            public boolean isOutsideTwo() {
                return true;
            }

            @Override
            public Boolean outsideDirectionTwo() {
                return false;
            }
        }
        ,
        OUTSIDE_MIN_ONE_MAX_TWO{

            @Override
            public boolean isInside() {
                return false;
            }

            @Override
            public boolean isOutsideOne() {
                return true;
            }

            @Override
            public Boolean outsideDirectionOne() {
                return false;
            }

            @Override
            public boolean isOutsideTwo() {
                return true;
            }

            @Override
            public Boolean outsideDirectionTwo() {
                return true;
            }
        }
        ,
        OUTSIDE_MAX_ONE_MIN_TWO{

            @Override
            public boolean isInside() {
                return false;
            }

            @Override
            public boolean isOutsideOne() {
                return true;
            }

            @Override
            public Boolean outsideDirectionOne() {
                return true;
            }

            @Override
            public boolean isOutsideTwo() {
                return true;
            }

            @Override
            public Boolean outsideDirectionTwo() {
                return false;
            }
        }
        ,
        OUTSIDE_MAX_ONE_MAX_TWO{

            @Override
            public boolean isInside() {
                return false;
            }

            @Override
            public boolean isOutsideOne() {
                return true;
            }

            @Override
            public Boolean outsideDirectionOne() {
                return true;
            }

            @Override
            public boolean isOutsideTwo() {
                return true;
            }

            @Override
            public Boolean outsideDirectionTwo() {
                return true;
            }
        };


        public abstract boolean isInside();

        public abstract boolean isOutsideOne();

        public abstract Boolean outsideDirectionOne();

        public Edge oneEdge() {
            return this.outsideDirectionOne() != false ? Edge.MAX_ONE : Edge.MIN_ONE;
        }

        public abstract boolean isOutsideTwo();

        public abstract Boolean outsideDirectionTwo();

        public Edge twoEdge() {
            return this.outsideDirectionTwo() != false ? Edge.MAX_TWO : Edge.MIN_TWO;
        }

        public static InsideStatus get(float one, float two, float minOne, float minTwo, float maxOne, float maxTwo) {
            if (one >= minOne) {
                if (one <= maxOne) {
                    if (two >= minTwo) {
                        if (two <= maxTwo) {
                            return INSIDE;
                        }
                        return OUTSIDE_MAX_TWO;
                    }
                    return OUTSIDE_MIN_TWO;
                }
                if (two >= minTwo) {
                    if (two <= maxTwo) {
                        return OUTSIDE_MAX_ONE;
                    }
                    return OUTSIDE_MAX_ONE_MAX_TWO;
                }
                return OUTSIDE_MAX_ONE_MIN_TWO;
            }
            if (two >= minTwo) {
                if (two <= maxTwo) {
                    return OUTSIDE_MIN_ONE;
                }
                return OUTSIDE_MIN_ONE_MAX_TWO;
            }
            return OUTSIDE_MIN_ONE_MIN_TWO;
        }
    }

    private static enum Edge {
        MIN_ONE{

            @Override
            public Edge clockwise() {
                return MAX_TWO;
            }

            @Override
            public Edge counterClockwise() {
                return MIN_TWO;
            }

            @Override
            public boolean one() {
                return true;
            }

            @Override
            public boolean positive() {
                return false;
            }
        }
        ,
        MIN_TWO{

            @Override
            public Edge clockwise() {
                return MIN_ONE;
            }

            @Override
            public Edge counterClockwise() {
                return MAX_ONE;
            }

            @Override
            public boolean one() {
                return false;
            }

            @Override
            public boolean positive() {
                return false;
            }
        }
        ,
        MAX_ONE{

            @Override
            public Edge clockwise() {
                return MIN_TWO;
            }

            @Override
            public Edge counterClockwise() {
                return MAX_TWO;
            }

            @Override
            public boolean one() {
                return true;
            }

            @Override
            public boolean positive() {
                return true;
            }
        }
        ,
        MAX_TWO{

            @Override
            public Edge clockwise() {
                return MAX_ONE;
            }

            @Override
            public Edge counterClockwise() {
                return MIN_ONE;
            }

            @Override
            public boolean one() {
                return false;
            }

            @Override
            public boolean positive() {
                return true;
            }
        };


        public abstract boolean one();

        public abstract boolean positive();

        public abstract Edge clockwise();

        public abstract Edge counterClockwise();
    }
}

