/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.common.gui.controls.gui;

import com.creativemd.creativecore.common.gui.controls.gui.GuiComboBoxExtensionCategory;
import com.creativemd.creativecore.common.gui.controls.gui.GuiLabel;
import com.creativemd.creativecore.common.gui.event.gui.GuiControlChangedEvent;
import com.creativemd.creativecore.common.utils.type.Pair;
import com.creativemd.creativecore.common.utils.type.PairList;
import net.minecraft.init.SoundEvents;

public class GuiComboBoxCategory<T>
extends GuiLabel {
    public GuiComboBoxExtensionCategory<T> extension;
    public PairList<String, PairList<String, T>> elements;
    public int index;

    public GuiComboBoxCategory(String name, int x, int y, int width, PairList<String, PairList<String, T>> elements) {
        super(name, x, y, width, 14, -1);
        this.elements = elements;
        if (!this.select(0)) {
            this.caption = "";
            this.index = -1;
        }
    }

    public Pair<String, T> getSelected() {
        if (this.index == -1) {
            return null;
        }
        int currentIndex = 0;
        for (Pair pair : this.elements) {
            if (this.index >= currentIndex + ((PairList)pair.value).size()) {
                currentIndex += ((PairList)pair.value).size();
                continue;
            }
            return (Pair)((PairList)pair.value).get(this.index - currentIndex);
        }
        return null;
    }

    public boolean select(int index) {
        int currentIndex = 0;
        if (index == -1) {
            return false;
        }
        for (Pair pair : this.elements) {
            if (index >= currentIndex + ((PairList)pair.value).size()) {
                currentIndex += ((PairList)pair.value).size();
                continue;
            }
            this.caption = GuiComboBoxCategory.translate((String)((Pair)((PairList)pair.value).get((int)(index - currentIndex))).key);
            this.index = index;
            this.raiseEvent(new GuiControlChangedEvent(this));
            return true;
        }
        return false;
    }

    @Override
    public boolean hasBorder() {
        return true;
    }

    @Override
    public boolean hasBackground() {
        return true;
    }

    @Override
    public boolean mousePressed(int posX, int posY, int button) {
        if (this.extension == null) {
            this.openBox();
        } else {
            this.closeBox();
        }
        GuiComboBoxCategory.playSound(SoundEvents.field_187909_gi);
        return true;
    }

    public void openBox() {
        this.extension = this.createBox();
        this.getGui().controls.add(this.extension);
        this.extension.parent = this.getGui();
        this.extension.moveControlToTop();
        this.extension.onOpened();
        this.getGui().refreshControls();
        this.extension.rotation = this.rotation;
        this.extension.posX = this.getPixelOffsetX() - this.getGui().getPixelOffsetX() - this.getContentOffset();
        this.extension.posY = this.getPixelOffsetY() - this.getGui().getPixelOffsetY() - this.getContentOffset() + this.height;
        if (this.extension.posY + this.extension.height > this.getParent().height && this.posY >= this.extension.height) {
            this.extension.posY -= this.height + this.extension.height;
        }
    }

    protected GuiComboBoxExtensionCategory<T> createBox() {
        return new GuiComboBoxExtensionCategory(this.name + "extension", this, this.posX, this.posY + this.height, this.width - this.getContentOffset() * 2, 100);
    }

    public void closeBox() {
        if (this.extension != null) {
            this.getGui().controls.remove(this.extension);
            this.extension = null;
        }
    }
}

