/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.util;

import ipsis.woot.oss.LogHelper;
import ipsis.woot.plugins.enderio.EnderIO;
import ipsis.woot.util.WootMobName;
import ipsis.woot.util.WootMobNameBuilder;
import java.util.HashMap;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityWitherSkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;

public class SkullHelper {
    private static HashMap<SkullType, ItemStack> skulls = new HashMap();
    private static HashMap<WootMobName, ItemStack> wootSkulls = new HashMap();

    public static void postInit() {
        skulls.put(SkullType.VANILLA_SKELTON, new ItemStack(Items.field_151144_bL, 1, 0));
        skulls.put(SkullType.VANILLA_WITHER_SKELETON, new ItemStack(Items.field_151144_bL, 1, 1));
        skulls.put(SkullType.VANILLA_ZOMBIE, new ItemStack(Items.field_151144_bL, 1, 2));
        skulls.put(SkullType.VANILLA_CREEPER, new ItemStack(Items.field_151144_bL, 1, 4));
        wootSkulls.put(WootMobNameBuilder.create("minecraft:skeleton"), new ItemStack(Items.field_151144_bL, 1, 0));
        wootSkulls.put(WootMobNameBuilder.create("minecraft:wither_skeleton"), new ItemStack(Items.field_151144_bL, 1, 1));
        wootSkulls.put(WootMobNameBuilder.create("minecraft:zombie"), new ItemStack(Items.field_151144_bL, 1, 2));
        wootSkulls.put(WootMobNameBuilder.create("minecraft:creeper"), new ItemStack(Items.field_151144_bL, 1, 4));
        ItemStack enderioSkull = EnderIO.getEndermanSkull();
        if (!enderioSkull.func_190926_b()) {
            skulls.put(SkullType.ENDERIO_ENDERMAN, enderioSkull.func_77946_l());
            wootSkulls.put(WootMobNameBuilder.create("minecraft:enderman"), enderioSkull.func_77946_l());
            LogHelper.info("Adding EnderIO enderman skull");
        }
    }

    public static ItemStack getSkull(SkullType skullType) {
        if (skulls.containsKey((Object)skullType)) {
            return skulls.get((Object)skullType);
        }
        return ItemStack.field_190927_a;
    }

    public static ItemStack getSkull(WootMobName wootMobName) {
        if (wootSkulls.containsKey(wootMobName)) {
            return wootSkulls.get(wootMobName);
        }
        return ItemStack.field_190927_a;
    }

    public static ItemStack getSkull(EntityLiving entityLiving) {
        if (entityLiving instanceof EntityWitherSkeleton) {
            return SkullHelper.getSkull(SkullType.VANILLA_WITHER_SKELETON);
        }
        if (entityLiving instanceof EntityZombie) {
            return SkullHelper.getSkull(SkullType.VANILLA_ZOMBIE);
        }
        if (entityLiving instanceof EntitySkeleton) {
            return SkullHelper.getSkull(SkullType.VANILLA_SKELTON);
        }
        if (entityLiving instanceof EntityCreeper) {
            return SkullHelper.getSkull(SkullType.VANILLA_CREEPER);
        }
        if (entityLiving instanceof EntityEnderman) {
            return SkullHelper.getSkull(SkullType.ENDERIO_ENDERMAN);
        }
        return ItemStack.field_190927_a;
    }

    public static enum SkullType {
        VANILLA_SKELTON,
        VANILLA_CREEPER,
        VANILLA_ZOMBIE,
        VANILLA_WITHER_SKELETON,
        ENDERIO_ENDERMAN;

    }
}

