/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.util;

import ipsis.woot.oss.LogHelper;
import java.util.EnumSet;

public class DebugSetup {
    private EnumSet<EnumDebugType> debugFlags = EnumSet.noneOf(EnumDebugType.class);

    public void setDebug(EnumDebugType t) {
        this.debugFlags.add(t);
    }

    public void clearDebug(EnumDebugType t) {
        this.debugFlags.remove((Object)t);
    }

    public void trace(EnumDebugType t, String f, Object object) {
        if (this.debugFlags.contains((Object)t)) {
            LogHelper.info(f + ": " + object);
        }
    }

    public boolean areTracing(EnumDebugType t) {
        return this.debugFlags.contains((Object)t);
    }

    public String toString() {
        return " " + this.debugFlags.toString();
    }

    public static enum EnumDebugType {
        POWER,
        LOOT_EVENTS,
        CONFIG_LOAD,
        CONFIG_ACCESS,
        ANVIL_CRAFTING,
        FARM_SCAN,
        FARM_CLIENT_SYNC,
        FARM_BUILD,
        MULTIBLOCK,
        POWER_CALC,
        GEN_XP,
        GEN_ITEMS,
        GEN_BM_LE,
        GEN_BM_CRYSTAL,
        GEN_HEADS,
        GEN_EC,
        SPAWN,
        LEARN,
        TARTARUS,
        DECAP;

        public static final EnumSet<EnumDebugType> ALL_OPTS;

        static {
            ALL_OPTS = EnumSet.allOf(EnumDebugType.class);
        }
    }
}

