/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.tileentity;

import ipsis.Woot;
import ipsis.woot.block.BlockMobFactoryHeart;
import ipsis.woot.configuration.EnumConfigKey;
import ipsis.woot.farmblocks.IFarmBlockMaster;
import ipsis.woot.farming.IRecipeProgressTracker;
import ipsis.woot.farming.ISpawnRecipe;
import ipsis.woot.farming.ISpawnRecipeConsumer;
import ipsis.woot.farming.ITickTracker;
import ipsis.woot.farming.PowerRecipe;
import ipsis.woot.farming.SimpleRecipeProgressTracker;
import ipsis.woot.farming.SimpleTickTracker;
import ipsis.woot.farming.SpawnRecipe;
import ipsis.woot.farming.SpawnRecipeConsumer;
import ipsis.woot.farmstructure.FarmBuilder;
import ipsis.woot.farmstructure.FarmScanner2;
import ipsis.woot.farmstructure.IFarmSetup;
import ipsis.woot.farmstructure.IFarmStructure;
import ipsis.woot.farmstructure.ScannedFarm2;
import ipsis.woot.init.ModItems;
import ipsis.woot.loot.ILootLearner;
import ipsis.woot.loot.LootGenerationFarmInfo;
import ipsis.woot.loot.repository.ILootRepositoryLookup;
import ipsis.woot.loot.schools.TartarusSchool;
import ipsis.woot.multiblock.EnumMobFactoryTier;
import ipsis.woot.plugins.bloodmagic.BloodMagicTracker;
import ipsis.woot.plugins.bloodmagic.IBloodMagicHandler;
import ipsis.woot.power.calculation.BigIntegerCalculator;
import ipsis.woot.power.calculation.IPowerCalculator;
import ipsis.woot.tileentity.IMobFarm;
import ipsis.woot.tileentity.ui.FarmUIInfo;
import ipsis.woot.util.ConfigKeyHelper;
import ipsis.woot.util.EnumFarmUpgrade;
import ipsis.woot.util.LootHelper;
import ipsis.woot.util.SkullHelper;
import ipsis.woot.util.StringHelper;
import ipsis.woot.util.WootMobName;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fluids.FluidStack;

public class TileEntityMobFactoryHeart
extends TileEntity
implements ITickable,
IFarmBlockMaster,
IMobFarm,
IBloodMagicHandler {
    private ITickTracker tickTracker;
    private IFarmStructure farmStructure;
    private IFarmSetup farmSetup;
    private PowerRecipe powerRecipe;
    private ISpawnRecipe spawnRecipe;
    private IPowerCalculator powerCalculator;
    private IRecipeProgressTracker recipeProgressTracker;
    private ISpawnRecipeConsumer spawnRecipeConsumer;
    private ILootLearner lootLearner;
    private int storedXp = 0;
    private long nbtConsumedPower = 0L;
    private FarmUIInfo guiInfoOnly;
    public int guiProgress;
    public int guiStoredPower;
    public int guiRunning;
    private BloodMagicTracker bloodMagicTracker = new BloodMagicTracker();

    public TileEntityMobFactoryHeart() {
        this.tickTracker = new SimpleTickTracker();
        this.tickTracker.setLearnTickCount(Woot.wootConfiguration.getInteger(EnumConfigKey.LEARN_TICKS) + Woot.RANDOM.nextInt(11));
        this.tickTracker.setStructureTickCount(20);
        this.spawnRecipeConsumer = new SpawnRecipeConsumer();
        this.spawnRecipe = new SpawnRecipe();
        this.powerCalculator = new BigIntegerCalculator();
        this.recipeProgressTracker = new SimpleRecipeProgressTracker();
        this.lootLearner = new TartarusSchool();
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        if (this.farmStructure != null && this.farmStructure.isFormed()) {
            compound.func_74772_a("wootConsumedPowerLong", this.recipeProgressTracker.getConsumedPower());
        }
        compound.func_74768_a("storedXp", this.storedXp);
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (compound.func_74764_b("wootConsumedPower")) {
            this.nbtConsumedPower = compound.func_74762_e("wootConsumedPower");
        } else if (compound.func_74764_b("wootConsumedPowerLong")) {
            this.nbtConsumedPower = compound.func_74763_f("wootConsumedPowerLong");
        }
        this.storedXp = compound.func_74762_e("storedXp");
        if (this.storedXp < 0) {
            this.storedXp = 0;
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.farmStructure != null && this.farmStructure.isFormed()) {
            this.farmStructure.fullDisconnect();
        }
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        if (this.farmStructure != null && this.farmStructure.isFormed()) {
            this.farmStructure.fullDisconnect();
        }
    }

    private boolean isPowered() {
        return !this.func_145830_o() || !this.field_145850_b.func_175640_z(this.func_174877_v());
    }

    public int getRecipeProgress() {
        int progress = 0;
        if (this.farmStructure != null && this.farmStructure.isFormed()) {
            progress = this.recipeProgressTracker.getProgress();
        }
        return progress;
    }

    public int getStoredPower() {
        int power = 0;
        if (this.farmStructure != null && this.farmStructure.isFormed() && this.farmSetup != null) {
            power = this.farmSetup.getPowerStation().getEnergyStorage().getEnergyStored();
        }
        return power;
    }

    public int getRunning() {
        int running = 0;
        if (this.farmStructure != null && this.farmStructure.isFormed() && this.isPowered()) {
            running = 1;
        }
        return running;
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.farmStructure == null) {
            this.farmStructure = new FarmBuilder().setWorld(this.func_145831_w()).setPosition(this.func_174877_v());
            this.farmStructure.setStructureDirty();
        }
        this.tickTracker.tick(this.field_145850_b);
        this.farmStructure.tick(this.tickTracker);
        if (this.farmStructure.isFormed()) {
            if (this.farmStructure.hasChanged()) {
                this.farmSetup = this.farmStructure.createSetup();
                this.powerRecipe = this.powerCalculator.calculate(this.field_145850_b, this.farmSetup);
                this.spawnRecipe = Woot.spawnRecipeRepository.get(this.farmSetup.getWootMobName());
                this.recipeProgressTracker.setPowerStation(this.farmSetup.getPowerStation());
                this.recipeProgressTracker.setPowerRecipe(this.powerRecipe);
                this.farmStructure.clearChanged();
                this.farmSetup.setStoredXp(this.storedXp);
                if (this.nbtConsumedPower != 0L) {
                    this.recipeProgressTracker.setConsumedPower(this.nbtConsumedPower);
                    this.nbtConsumedPower = 0L;
                }
            }
            if (this.isPowered()) {
                this.lootLearner.tick(this.tickTracker, this.func_145831_w(), this.func_174877_v(), this.farmSetup);
                this.recipeProgressTracker.tick();
                if (this.recipeProgressTracker.isComplete()) {
                    if (this.spawnRecipeConsumer.consume(this.func_145831_w(), this.func_174877_v(), this.farmSetup.getConnectedImportTanks(), this.farmSetup.getConnectedImportChests(), this.spawnRecipe, this.farmSetup.getNumMobs(), false)) {
                        LootGenerationFarmInfo info = new LootGenerationFarmInfo();
                        info.keepAliveTankRitual = this.bloodMagicTracker.isTankAlive();
                        info.itemHandlerList = this.farmSetup.getConnectedExportChests();
                        info.fluidHandlerList = this.farmSetup.getConnectedExportTanks();
                        info.farmSetup = this.farmSetup;
                        info.difficultyInstance = this.field_145850_b.func_175649_E(this.func_174877_v());
                        Woot.lootGeneration.generate(this.func_145831_w(), info);
                        this.storedXp = this.farmSetup.getStoredXp();
                        this.bloodMagicTracker.clearTank();
                        this.bloodMagicTracker.setWootMobName(this.farmSetup.getWootMobName());
                        if (this.farmSetup.hasUpgrade(EnumFarmUpgrade.BM_LE_ALTAR)) {
                            this.bloodMagicTracker.setAltarMobCount(this.farmSetup.getNumMobs());
                        }
                        if (this.farmSetup.hasUpgrade(EnumFarmUpgrade.BM_CRYSTAL)) {
                            this.bloodMagicTracker.setCrystalMobCount(this.farmSetup.getNumMobs());
                        }
                    }
                    this.recipeProgressTracker.reset();
                }
            }
        }
    }

    public void outputFarmScan(EntityPlayer player) {
        Block b;
        if (this.farmStructure == null) {
            return;
        }
        player.func_146105_b((ITextComponent)new TextComponentString(StringHelper.localize("chat.woot.validate.outputs")), false);
        List<TileEntity> tanks = this.farmSetup.getConnectedExportTanksTiles();
        List<TileEntity> chests = this.farmSetup.getConnectedExportChestsTiles();
        for (TileEntity te : tanks) {
            b = te.func_145831_w().func_180495_p(te.func_174877_v()).func_177230_c();
            player.func_146105_b((ITextComponent)new TextComponentString(String.format("Found output tank [%s @ %d, %d, %d]", b.func_149732_F(), te.func_174877_v().func_177958_n(), te.func_174877_v().func_177956_o(), te.func_174877_v().func_177952_p())), false);
        }
        for (TileEntity te : chests) {
            b = te.func_145831_w().func_180495_p(te.func_174877_v()).func_177230_c();
            player.func_146105_b((ITextComponent)new TextComponentString(String.format("Found output inventory [%s @ %d, %d, %d]", b.func_149732_F(), te.func_174877_v().func_177958_n(), te.func_174877_v().func_177956_o(), te.func_174877_v().func_177952_p())), false);
        }
    }

    public void inputFarmScan(EntityPlayer player) {
        Block b;
        if (this.farmStructure == null) {
            return;
        }
        player.func_146105_b((ITextComponent)new TextComponentString(StringHelper.localize("chat.woot.validate.inputs")), false);
        List<TileEntity> tanks = this.farmSetup.getConnectedImportTanksTiles();
        List<TileEntity> chests = this.farmSetup.getConnectedImportChestsTiles();
        for (TileEntity te : tanks) {
            b = te.func_145831_w().func_180495_p(te.func_174877_v()).func_177230_c();
            player.func_146105_b((ITextComponent)new TextComponentString(String.format("Found input tank [%s @ %d, %d, %d]", b.func_149732_F(), te.func_174877_v().func_177958_n(), te.func_174877_v().func_177956_o(), te.func_174877_v().func_177952_p())), false);
        }
        for (TileEntity te : chests) {
            b = te.func_145831_w().func_180495_p(te.func_174877_v()).func_177230_c();
            player.func_146105_b((ITextComponent)new TextComponentString(String.format("Found input inventory [%s @ %d, %d, %d]", b.func_149732_F(), te.func_174877_v().func_177958_n(), te.func_174877_v().func_177956_o(), te.func_174877_v().func_177952_p())), false);
        }
    }

    public void manualFarmScan(EntityPlayer player, EnumMobFactoryTier tier) {
        player.func_146105_b((ITextComponent)new TextComponentString(StringHelper.localizeFormat("chat.woot.validate.validating", tier.getTranslated("info.woot.tier"))), false);
        EnumFacing facing = (EnumFacing)this.field_145850_b.func_180495_p(this.func_174877_v()).func_177229_b((IProperty)BlockMobFactoryHeart.FACING);
        FarmScanner2 farmScanner = new FarmScanner2();
        ScannedFarm2 scannedFarm = farmScanner.scanFarm(this.field_145850_b, this.func_174877_v(), facing, tier);
        if (!scannedFarm.remote.hasPower()) {
            player.func_146105_b((ITextComponent)new TextComponentString(StringHelper.localize("chat.woot.validate.nopower")), false);
        } else {
            player.func_146105_b((ITextComponent)new TextComponentString(StringHelper.localizeFormat("chat.woot.validate.power", scannedFarm.remote.getPowerPos().func_177958_n(), scannedFarm.remote.getPowerPos().func_177956_o(), scannedFarm.remote.getPowerPos().func_177952_p())), false);
        }
        if (!scannedFarm.remote.hasImport()) {
            player.func_146105_b((ITextComponent)new TextComponentString(StringHelper.localize("chat.woot.validate.noimporter")), false);
        } else {
            player.func_146105_b((ITextComponent)new TextComponentString(StringHelper.localizeFormat("chat.woot.validate.importer", scannedFarm.remote.getImportPos().func_177958_n(), scannedFarm.remote.getImportPos().func_177956_o(), scannedFarm.remote.getImportPos().func_177952_p())), false);
        }
        if (!scannedFarm.remote.hasExport()) {
            player.func_146105_b((ITextComponent)new TextComponentString(StringHelper.localize("chat.woot.validate.noexporter")), false);
        } else {
            player.func_146105_b((ITextComponent)new TextComponentString(StringHelper.localizeFormat("chat.woot.validate.exporter", scannedFarm.remote.getExportPos().func_177958_n(), scannedFarm.remote.getExportPos().func_177956_o(), scannedFarm.remote.getExportPos().func_177952_p())), false);
        }
        if (scannedFarm.isValidStructure() && scannedFarm.isValidCofiguration(this.field_145850_b)) {
            player.func_146105_b((ITextComponent)new TextComponentString(StringHelper.localizeFormat("chat.woot.validate.ok", tier.getTranslated("info.woot.tier"))), false);
        } else {
            if (!scannedFarm.controller.isPresent()) {
                BlockPos pos = farmScanner.getControllerPos(this.field_145850_b, this.func_174877_v(), facing);
                player.func_146105_b((ITextComponent)new TextComponentString(StringHelper.localizeFormat("chat.woot.validate.nocontroller", pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p())), false);
            } else if (!scannedFarm.controller.canGenerateFrom()) {
                player.func_146105_b((ITextComponent)new TextComponentString(StringHelper.localize("chat.woot.validate.invalidmob")), false);
            } else if (!scannedFarm.controller.isTierValid(this.field_145850_b, tier)) {
                player.func_146105_b((ITextComponent)new TextComponentString(StringHelper.localize("chat.woot.validate.invalidtier")), false);
            }
            for (FarmScanner2.BadFarmBlockInfo info : scannedFarm.getBadBlocks()) {
                ItemStack itemStack = new ItemStack(info.getCorrectBlock(), 1, info.getCorrectBlockMeta());
                if (info.getReason() == FarmScanner2.BadBlockReason.MISSING_BLOCK) {
                    player.func_146105_b((ITextComponent)new TextComponentString(StringHelper.localizeFormat("chat.woot.validate.missing", itemStack.func_82833_r(), info.getPos().func_177958_n(), info.getPos().func_177956_o(), info.getPos().func_177952_p())), false);
                    continue;
                }
                if (info.getReason() != FarmScanner2.BadBlockReason.WRONG_BLOCK && info.getReason() != FarmScanner2.BadBlockReason.WRONG_STRUCTURE_TYPE) continue;
                ItemStack itemStack1 = new ItemStack(info.getInvalidBlock(), 1, info.getInvalidBlockMeta());
                player.func_146105_b((ITextComponent)new TextComponentString(StringHelper.localizeFormat("chat.woot.validate.incorrect", itemStack.func_82833_r(), info.getPos().func_177958_n(), info.getPos().func_177956_o(), info.getPos().func_177952_p(), itemStack1.func_82833_r())), false);
            }
        }
    }

    public void showGui(EntityPlayer player, World world, int x, int y, int z) {
        if (this.farmStructure != null && this.farmStructure.isFormed()) {
            player.openGui((Object)Woot.instance, 0, world, x, y, z);
        }
    }

    @Override
    public void interruptFarmStructure() {
        if (this.farmStructure != null) {
            this.farmStructure.setStructureDirty();
        }
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (this.farmStructure != null && this.farmStructure.isFormed()) {
            return capability == CapabilityEnergy.ENERGY;
        }
        return false;
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY && this.farmStructure != null && this.farmStructure.isFormed()) {
            return (T)this.farmSetup.getPowerStation().getEnergyStorage();
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public void getUIInfo(FarmUIInfo info) {
        if (!this.farmStructure.isFormed()) {
            return;
        }
        info.mobName = this.farmSetup.getWootMob().getDisplayName();
        info.isRunning = this.isPowered();
        info.recipeTotalPower = this.powerRecipe.getTotalPower();
        info.recipeTotalTime = this.powerRecipe.getTicks();
        info.recipePowerPerTick = this.powerRecipe.getPowerPerTick();
        info.consumedPower = this.recipeProgressTracker.getConsumedPower();
        info.tier = this.farmSetup.getFarmTier();
        info.powerCapacity = this.farmSetup.getPowerStation().getEnergyStorage().getMaxEnergyStored();
        info.powerStored = this.farmSetup.getPowerStation().getEnergyStorage().getEnergyStored();
        info.mobCount = this.farmSetup.getNumMobs();
        boolean addedDropSkull = false;
        boolean canDropSkull = false;
        ItemStack skull = SkullHelper.getSkull(this.farmSetup.getWootMobName());
        if (!skull.func_190926_b() && this.farmSetup.hasUpgrade(EnumFarmUpgrade.DECAPITATE)) {
            canDropSkull = true;
        }
        List<ILootRepositoryLookup.LootItemStack> loot = LootHelper.getDrops(this.farmSetup.getWootMobName(), this.farmSetup.getEnchantKey());
        for (ILootRepositoryLookup.LootItemStack lootItemStack : loot) {
            if (!Woot.policyRepository.canDrop(lootItemStack.itemStack)) continue;
            ItemStack itemStack = lootItemStack.itemStack.func_77946_l();
            itemStack.func_190920_e(lootItemStack.dropChance);
            if (canDropSkull && itemStack.func_77969_a(skull)) {
                int decap = Woot.wootConfiguration.getInteger(this.farmSetup.getWootMobName(), ConfigKeyHelper.getDecapParam(this.farmSetup.getUpgradeLevel(EnumFarmUpgrade.DECAPITATE)));
                if (decap > itemStack.func_190916_E()) {
                    itemStack.func_190920_e(decap);
                }
                addedDropSkull = true;
            }
            info.drops.add(itemStack);
        }
        if (canDropSkull && !addedDropSkull) {
            int decap = Woot.wootConfiguration.getInteger(this.farmSetup.getWootMobName(), ConfigKeyHelper.getDecapParam(this.farmSetup.getUpgradeLevel(EnumFarmUpgrade.DECAPITATE)));
            ItemStack itemStack = skull.func_77946_l();
            itemStack.func_190920_e(decap);
            info.drops.add(itemStack);
        }
        if (Woot.wootConfiguration.getBoolean(EnumConfigKey.ALLOW_SHARD_RECIPES)) {
            ItemStack t2Stack = new ItemStack((Item)ModItems.itemShard, Woot.wootConfiguration.getInteger(EnumConfigKey.T2_SHARD_GEN), 4);
            ItemStack t3Stack = new ItemStack((Item)ModItems.itemShard, Woot.wootConfiguration.getInteger(EnumConfigKey.T3_SHARD_GEN), 5);
            ItemStack t4Stack = new ItemStack((Item)ModItems.itemShard, Woot.wootConfiguration.getInteger(EnumConfigKey.T4_SHARD_GEN), 6);
            if (this.farmSetup.getFarmTier() == EnumMobFactoryTier.TIER_ONE) {
                info.drops.add(t2Stack);
            } else if (this.farmSetup.getFarmTier() == EnumMobFactoryTier.TIER_TWO) {
                info.drops.add(t2Stack);
                info.drops.add(t3Stack);
            } else if (this.farmSetup.getFarmTier() == EnumMobFactoryTier.TIER_THREE || this.farmSetup.getFarmTier() == EnumMobFactoryTier.TIER_FOUR) {
                info.drops.add(t2Stack);
                info.drops.add(t3Stack);
                info.drops.add(t4Stack);
            }
        }
        if (this.spawnRecipe != null) {
            for (ItemStack itemStack : this.spawnRecipe.getItems()) {
                info.ingredientsItems.add(itemStack.func_77946_l());
            }
            for (FluidStack fluidStack : this.spawnRecipe.getFluids()) {
                info.ingredientsFluids.add(fluidStack.copy());
            }
            info.missingIngredients = !this.spawnRecipeConsumer.consume(this.func_145831_w(), this.func_174877_v(), this.farmSetup.getConnectedImportTanks(), this.farmSetup.getConnectedImportChests(), this.spawnRecipe, this.farmSetup.getNumMobs(), true);
        }
        this.getUpgradeUIInfo(info);
        info.setValid();
    }

    private void getUpgradeUIInfo(FarmUIInfo info) {
        int param1;
        int perTick;
        if (this.farmSetup.hasUpgrade(EnumFarmUpgrade.DECAPITATE)) {
            info.upgradeUIInfo.setUpgrade(EnumFarmUpgrade.DECAPITATE, this.farmSetup.getUpgradeLevel(EnumFarmUpgrade.DECAPITATE));
            perTick = Woot.wootConfiguration.getInteger(this.farmSetup.getWootMobName(), ConfigKeyHelper.getDecapPowerPerTick(this.farmSetup.getUpgradeLevel(EnumFarmUpgrade.DECAPITATE)));
            param1 = Woot.wootConfiguration.getInteger(this.farmSetup.getWootMobName(), ConfigKeyHelper.getDecapParam(this.farmSetup.getUpgradeLevel(EnumFarmUpgrade.DECAPITATE)));
            info.upgradeUIInfo.setPowerPerTick(EnumFarmUpgrade.DECAPITATE, perTick);
            info.upgradeUIInfo.setParam1(EnumFarmUpgrade.DECAPITATE, param1);
        }
        if (this.farmSetup.hasUpgrade(EnumFarmUpgrade.EFFICIENCY)) {
            info.upgradeUIInfo.setUpgrade(EnumFarmUpgrade.EFFICIENCY, this.farmSetup.getUpgradeLevel(EnumFarmUpgrade.EFFICIENCY));
            perTick = Woot.wootConfiguration.getInteger(this.farmSetup.getWootMobName(), ConfigKeyHelper.getEffPowerPerTick(this.farmSetup.getUpgradeLevel(EnumFarmUpgrade.EFFICIENCY)));
            param1 = Woot.wootConfiguration.getInteger(this.farmSetup.getWootMobName(), ConfigKeyHelper.getEffParam(this.farmSetup.getUpgradeLevel(EnumFarmUpgrade.EFFICIENCY)));
            info.upgradeUIInfo.setPowerPerTick(EnumFarmUpgrade.EFFICIENCY, perTick);
            info.upgradeUIInfo.setParam1(EnumFarmUpgrade.EFFICIENCY, param1);
        }
        if (this.farmSetup.hasUpgrade(EnumFarmUpgrade.LOOTING)) {
            info.upgradeUIInfo.setUpgrade(EnumFarmUpgrade.LOOTING, this.farmSetup.getUpgradeLevel(EnumFarmUpgrade.LOOTING));
            perTick = Woot.wootConfiguration.getInteger(this.farmSetup.getWootMobName(), ConfigKeyHelper.getLootingPowerPerTick(this.farmSetup.getUpgradeLevel(EnumFarmUpgrade.LOOTING)));
            param1 = Woot.wootConfiguration.getInteger(this.farmSetup.getWootMobName(), ConfigKeyHelper.getLootingParam(this.farmSetup.getUpgradeLevel(EnumFarmUpgrade.LOOTING)));
            info.upgradeUIInfo.setPowerPerTick(EnumFarmUpgrade.LOOTING, perTick);
            info.upgradeUIInfo.setParam1(EnumFarmUpgrade.LOOTING, param1);
        }
        if (this.farmSetup.hasUpgrade(EnumFarmUpgrade.MASS)) {
            info.upgradeUIInfo.setUpgrade(EnumFarmUpgrade.MASS, this.farmSetup.getUpgradeLevel(EnumFarmUpgrade.MASS));
            perTick = Woot.wootConfiguration.getInteger(this.farmSetup.getWootMobName(), ConfigKeyHelper.getMassPowerPerTick(this.farmSetup.getUpgradeLevel(EnumFarmUpgrade.MASS)));
            param1 = Woot.wootConfiguration.getInteger(this.farmSetup.getWootMobName(), ConfigKeyHelper.getMassParam(this.farmSetup.getUpgradeLevel(EnumFarmUpgrade.MASS)));
            info.upgradeUIInfo.setPowerPerTick(EnumFarmUpgrade.MASS, perTick);
            info.upgradeUIInfo.setParam1(EnumFarmUpgrade.MASS, param1);
        }
        if (this.farmSetup.hasUpgrade(EnumFarmUpgrade.RATE)) {
            info.upgradeUIInfo.setUpgrade(EnumFarmUpgrade.RATE, this.farmSetup.getUpgradeLevel(EnumFarmUpgrade.RATE));
            perTick = Woot.wootConfiguration.getInteger(this.farmSetup.getWootMobName(), ConfigKeyHelper.getRatePowerPerTick(this.farmSetup.getUpgradeLevel(EnumFarmUpgrade.RATE)));
            param1 = Woot.wootConfiguration.getInteger(this.farmSetup.getWootMobName(), ConfigKeyHelper.getRateParam(this.farmSetup.getUpgradeLevel(EnumFarmUpgrade.RATE)));
            info.upgradeUIInfo.setPowerPerTick(EnumFarmUpgrade.RATE, perTick);
            info.upgradeUIInfo.setParam1(EnumFarmUpgrade.RATE, param1);
        }
        if (this.farmSetup.hasUpgrade(EnumFarmUpgrade.XP)) {
            info.upgradeUIInfo.setUpgrade(EnumFarmUpgrade.XP, this.farmSetup.getUpgradeLevel(EnumFarmUpgrade.XP));
            perTick = Woot.wootConfiguration.getInteger(this.farmSetup.getWootMobName(), ConfigKeyHelper.getXpPowerPerTick(this.farmSetup.getUpgradeLevel(EnumFarmUpgrade.XP)));
            param1 = Woot.wootConfiguration.getInteger(this.farmSetup.getWootMobName(), ConfigKeyHelper.getXpParam(this.farmSetup.getUpgradeLevel(EnumFarmUpgrade.XP)));
            info.upgradeUIInfo.setPowerPerTick(EnumFarmUpgrade.XP, perTick);
            info.upgradeUIInfo.setParam1(EnumFarmUpgrade.XP, param1);
        }
        if (this.farmSetup.hasUpgrade(EnumFarmUpgrade.BM_LE_TANK)) {
            info.upgradeUIInfo.setUpgrade(EnumFarmUpgrade.BM_LE_TANK, this.farmSetup.getUpgradeLevel(EnumFarmUpgrade.BM_LE_TANK));
            perTick = Woot.wootConfiguration.getInteger(this.farmSetup.getWootMobName(), ConfigKeyHelper.getBmLeTankPowerPerTick(this.farmSetup.getUpgradeLevel(EnumFarmUpgrade.BM_LE_TANK)));
            param1 = Woot.wootConfiguration.getInteger(this.farmSetup.getWootMobName(), ConfigKeyHelper.getBmLeTankParam(this.farmSetup.getUpgradeLevel(EnumFarmUpgrade.BM_LE_TANK)));
            info.upgradeUIInfo.setPowerPerTick(EnumFarmUpgrade.BM_LE_TANK, perTick);
            info.upgradeUIInfo.setParam1(EnumFarmUpgrade.BM_LE_TANK, param1);
        }
        if (this.farmSetup.hasUpgrade(EnumFarmUpgrade.BM_LE_ALTAR)) {
            info.upgradeUIInfo.setUpgrade(EnumFarmUpgrade.BM_LE_ALTAR, this.farmSetup.getUpgradeLevel(EnumFarmUpgrade.BM_LE_ALTAR));
            perTick = Woot.wootConfiguration.getInteger(this.farmSetup.getWootMobName(), ConfigKeyHelper.getBmLeAltarPowerPerTick(this.farmSetup.getUpgradeLevel(EnumFarmUpgrade.BM_LE_ALTAR)));
            param1 = Woot.wootConfiguration.getInteger(this.farmSetup.getWootMobName(), ConfigKeyHelper.getBmLeAltarParam(this.farmSetup.getUpgradeLevel(EnumFarmUpgrade.BM_LE_ALTAR)));
            info.upgradeUIInfo.setPowerPerTick(EnumFarmUpgrade.BM_LE_ALTAR, perTick);
            info.upgradeUIInfo.setParam1(EnumFarmUpgrade.BM_LE_ALTAR, param1);
        }
        if (this.farmSetup.hasUpgrade(EnumFarmUpgrade.BM_CRYSTAL)) {
            info.upgradeUIInfo.setUpgrade(EnumFarmUpgrade.BM_CRYSTAL, this.farmSetup.getUpgradeLevel(EnumFarmUpgrade.BM_CRYSTAL));
            perTick = Woot.wootConfiguration.getInteger(this.farmSetup.getWootMobName(), ConfigKeyHelper.getBmCrystalPowerPerTick(this.farmSetup.getUpgradeLevel(EnumFarmUpgrade.BM_CRYSTAL)));
            param1 = Woot.wootConfiguration.getInteger(this.farmSetup.getWootMobName(), ConfigKeyHelper.getBmCrystalParam(this.farmSetup.getUpgradeLevel(EnumFarmUpgrade.BM_CRYSTAL)));
            info.upgradeUIInfo.setPowerPerTick(EnumFarmUpgrade.BM_CRYSTAL, perTick);
            info.upgradeUIInfo.setParam1(EnumFarmUpgrade.BM_CRYSTAL, param1);
        }
        if (this.farmSetup.hasUpgrade(EnumFarmUpgrade.EC_BLOOD)) {
            info.upgradeUIInfo.setUpgrade(EnumFarmUpgrade.EC_BLOOD, this.farmSetup.getUpgradeLevel(EnumFarmUpgrade.EC_BLOOD));
            perTick = Woot.wootConfiguration.getInteger(this.farmSetup.getWootMobName(), ConfigKeyHelper.getEcBloodPowerPerTick(this.farmSetup.getUpgradeLevel(EnumFarmUpgrade.EC_BLOOD)));
            param1 = Woot.wootConfiguration.getInteger(this.farmSetup.getWootMobName(), ConfigKeyHelper.getEcBloodParam(this.farmSetup.getUpgradeLevel(EnumFarmUpgrade.EC_BLOOD)));
            info.upgradeUIInfo.setPowerPerTick(EnumFarmUpgrade.EC_BLOOD, perTick);
            info.upgradeUIInfo.setParam1(EnumFarmUpgrade.EC_BLOOD, param1);
        }
    }

    public boolean canInteractWith(EntityPlayer entityPlayer) {
        if (!this.farmStructure.isFormed()) {
            return false;
        }
        return entityPlayer.func_174818_b(this.field_174879_c.func_177963_a(0.5, 0.5, 0.5)) <= 64.0;
    }

    public void setGuiFarmInfo(FarmUIInfo info) {
        this.guiInfoOnly = info;
    }

    public FarmUIInfo getGuiFarmInfo() {
        return this.guiInfoOnly;
    }

    @Override
    public void keepAliveTankRitual() {
        if (this.farmStructure.isFormed()) {
            this.bloodMagicTracker.tickTank();
        }
    }

    @Override
    public int getAltarSacrificeNumMobs() {
        int mobs = 0;
        if (this.farmStructure.isFormed()) {
            mobs = this.bloodMagicTracker.getAltarMobCount();
        }
        return mobs;
    }

    @Override
    public int getCrystalNumMobs() {
        int mobs = 0;
        if (this.farmStructure.isFormed()) {
            mobs = this.bloodMagicTracker.getCrystalMobCount();
        }
        return mobs;
    }

    @Override
    public void clearCrystalNumMobs() {
        this.bloodMagicTracker.clearCrystalMobCount();
    }

    @Override
    public void clearAltarSacrificeNumMobs() {
        this.bloodMagicTracker.clearAltarMobCount();
    }

    @Override
    public int getAltarSacrificePercentage() {
        int p = 0;
        if (this.farmStructure.isFormed()) {
            p = Woot.wootConfiguration.getInteger(this.farmSetup.getWootMobName(), ConfigKeyHelper.getBmLeAltarParam(this.farmSetup.getUpgradeLevel(EnumFarmUpgrade.BM_LE_ALTAR)));
        }
        return p;
    }

    @Override
    public int getCrystalMobHealthPercentage() {
        int p = 0;
        if (this.farmStructure.isFormed()) {
            p = Woot.wootConfiguration.getInteger(this.farmSetup.getWootMobName(), ConfigKeyHelper.getBmCrystalParam(this.farmSetup.getUpgradeLevel(EnumFarmUpgrade.BM_CRYSTAL)));
        }
        return p;
    }

    @Override
    @Nullable
    public WootMobName getWootMobName() {
        WootMobName wootMobName = null;
        if (this.farmStructure.isFormed()) {
            wootMobName = this.farmSetup.getWootMobName();
        }
        return wootMobName;
    }
}

