/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.tileentity;

import ipsis.Woot;
import ipsis.woot.init.ModBlocks;
import ipsis.woot.multiblock.EnumMobFactoryTier;
import ipsis.woot.tileentity.ControllerLayoutBlockInfo;
import ipsis.woot.tileentity.HeartLayoutBlockInfo;
import ipsis.woot.tileentity.ILayoutBlockInfo;
import ipsis.woot.tileentity.StructureLayoutBlockInfo;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityLayout
extends TileEntity {
    List<ILayoutBlockInfo> layoutBlockInfoList = new ArrayList<ILayoutBlockInfo>();
    EnumFacing facing = EnumFacing.SOUTH;
    EnumMobFactoryTier tier = EnumMobFactoryTier.TIER_ONE;
    int currLevel = -1;

    public List<ILayoutBlockInfo> getLayoutBlockInfoList() {
        return this.layoutBlockInfoList;
    }

    public void refreshLayout() {
        if (this.field_145850_b != null && this.field_145850_b.field_72995_K) {
            this.layoutBlockInfoList.clear();
            Woot.factoryPatternRepository.getFactoryLayout(this.tier, this.func_174877_v(), this.facing, this.layoutBlockInfoList);
            this.layoutBlockInfoList.add(new HeartLayoutBlockInfo(this.func_174877_v()));
            this.layoutBlockInfoList.add(new ControllerLayoutBlockInfo(this.func_174877_v().func_177984_a().func_177967_a(this.facing, -1)));
            for (ILayoutBlockInfo p : this.layoutBlockInfoList) {
                p.offsetY(2);
            }
        }
    }

    public void buildFactory() {
        if (this.func_145831_w() != null && !this.func_145831_w().field_72995_K) {
            this.layoutBlockInfoList.clear();
            Woot.factoryPatternRepository.getFactoryLayout(this.tier, this.func_174877_v(), this.facing, this.layoutBlockInfoList);
            for (ILayoutBlockInfo p : this.layoutBlockInfoList) {
                p.offsetY(2);
            }
            for (ILayoutBlockInfo pos : this.layoutBlockInfoList) {
                if (!(pos instanceof StructureLayoutBlockInfo)) continue;
                this.func_145831_w().func_175656_a(pos.getPos(), ModBlocks.blockStructure.func_176203_a(((StructureLayoutBlockInfo)pos).module.getMetadata()));
            }
        }
    }

    public void setFacing(EnumFacing facing) {
        this.facing = facing;
        this.func_70296_d();
    }

    public EnumFacing getFacing() {
        return this.facing;
    }

    public void setNextTier() {
        this.tier = this.tier.getNext();
        this.currLevel = -1;
        this.func_70296_d();
        this.refreshLayout();
    }

    public EnumMobFactoryTier getTier() {
        return this.tier;
    }

    public int getCurrLevel() {
        return this.currLevel;
    }

    public void setNextLevel() {
        ++this.currLevel;
        if (this.currLevel >= Woot.factoryPatternRepository.getTierHeight(this.tier)) {
            this.currLevel = -1;
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("facing", this.facing.ordinal());
        compound.func_74768_a("tier", this.tier.ordinal());
        compound.func_74768_a("level", this.currLevel);
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.facing = EnumFacing.func_82600_a((int)compound.func_74762_e("facing"));
        this.tier = EnumMobFactoryTier.getTier(compound.func_74762_e("tier"));
        this.currLevel = compound.func_74762_e("level");
        this.refreshLayout();
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbtTagCompound = this.func_189517_E_();
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, nbtTagCompound);
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound nbtTagCompound = new NBTTagCompound();
        this.func_189515_b(nbtTagCompound);
        return nbtTagCompound;
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        BlockPos pos = this.func_174877_v();
        return new AxisAlignedBB(pos.func_177982_a(-Woot.factoryPatternRepository.getMaxXZOffset(), -1, -Woot.factoryPatternRepository.getMaxXZOffset()), pos.func_177982_a(Woot.factoryPatternRepository.getMaxXZOffset(), Woot.factoryPatternRepository.getMaxYOffset() - 1, Woot.factoryPatternRepository.getMaxXZOffset()));
    }
}

