/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.spawning;

import ipsis.Woot;
import ipsis.woot.spawning.AbstractMobEntity;
import ipsis.woot.spawning.IEntitySpawner;
import ipsis.woot.spawning.MobEntityChargedCreeper;
import ipsis.woot.spawning.MobEntityMagmaCube;
import ipsis.woot.spawning.MobEntityPinkSlime;
import ipsis.woot.spawning.MobEntitySlime;
import ipsis.woot.util.DebugSetup;
import ipsis.woot.util.EnumEnchantKey;
import ipsis.woot.util.FakePlayerPool;
import ipsis.woot.util.WootMobName;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.ForgeEventFactory;

public class EntitySpawner
implements IEntitySpawner {
    private List<AbstractMobEntity> mobEntityList = new ArrayList<AbstractMobEntity>();

    public EntitySpawner() {
        this.mobEntityList.add(new MobEntityMagmaCube());
        this.mobEntityList.add(new MobEntitySlime());
        this.mobEntityList.add(new MobEntityChargedCreeper());
        this.mobEntityList.add(new MobEntityPinkSlime());
    }

    private void applyCustomConfig(Entity entity, WootMobName wootMobName, World world) {
        for (AbstractMobEntity abstractMobEntity : this.mobEntityList) {
            abstractMobEntity.runSetup(entity, wootMobName, world);
        }
    }

    @Nullable
    private Entity createEntity(WootMobName wootMobName, World world) {
        ResourceLocation resourceLocation = wootMobName.getResourceLocation();
        Entity entity = EntityList.func_188429_b((ResourceLocation)resourceLocation, (World)world);
        if (entity != null && entity instanceof EntityLiving) {
            this.applyCustomConfig(entity, wootMobName, world);
        } else {
            entity = null;
        }
        return entity;
    }

    @Nullable
    private Entity spawnEntity(WootMobName wootMobName, World world, BlockPos pos) {
        Entity entity = this.createEntity(wootMobName, world);
        if (entity != null) {
            if (!ForgeEventFactory.doSpecialSpawn((EntityLiving)((EntityLiving)entity), (World)world, (float)pos.func_177958_n(), (float)pos.func_177956_o(), (float)pos.func_177952_p())) {
                ((EntityLiving)entity).func_180482_a(world.func_175649_E(pos), null);
            }
            ((EntityLivingBase)entity).field_70718_bc = 100;
            entity.func_70107_b((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        }
        return entity;
    }

    @Override
    public void spawn(WootMobName wootMobName, EnumEnchantKey key, World world, BlockPos pos) {
        Entity entity = this.spawnEntity(wootMobName, world, pos);
        if (entity == null) {
            return;
        }
        FakePlayer fakePlayer = FakePlayerPool.getFakePlayer((WorldServer)world, key);
        if (fakePlayer == null) {
            return;
        }
        if (Woot.debugSetup.areTracing(DebugSetup.EnumDebugType.SPAWN)) {
            Woot.debugSetup.trace(DebugSetup.EnumDebugType.SPAWN, "spawn entity:", entity.func_70005_c_());
            for (ItemStack itemStack : entity.func_184193_aE()) {
                Woot.debugSetup.trace(DebugSetup.EnumDebugType.SPAWN, "spawn armour:", itemStack);
            }
            for (ItemStack itemStack : entity.func_184214_aD()) {
                Woot.debugSetup.trace(DebugSetup.EnumDebugType.SPAWN, "spawn equipment", itemStack);
            }
        }
        ((EntityLivingBase)entity).field_70717_bb = fakePlayer;
        ((EntityLivingBase)entity).func_70645_a(DamageSource.func_76365_a((EntityPlayer)fakePlayer));
    }
}

