/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.power.calculation.upgrades;

import ipsis.Woot;
import ipsis.woot.farmstructure.IFarmSetup;
import ipsis.woot.power.calculation.BigIntegerCalculator;
import ipsis.woot.power.calculation.upgrades.IUpgradePowerCalculator;
import ipsis.woot.util.ConfigKeyHelper;
import ipsis.woot.util.DebugSetup;
import ipsis.woot.util.EnumFarmUpgrade;
import java.math.BigInteger;

public class Efficiency
implements IUpgradePowerCalculator {
    @Override
    public boolean isActive(IFarmSetup iFarmSetup) {
        return iFarmSetup.hasUpgrade(EnumFarmUpgrade.EFFICIENCY);
    }

    @Override
    public BigInteger calculateUpgradeCost(IFarmSetup iFarmSetup, int spawnTicks) {
        int perTick = Woot.wootConfiguration.getInteger(iFarmSetup.getWootMobName(), ConfigKeyHelper.getEffPowerPerTick(iFarmSetup.getUpgradeLevel(EnumFarmUpgrade.EFFICIENCY)));
        BigInteger cost = BigInteger.valueOf(spawnTicks);
        cost = cost.multiply(BigInteger.valueOf(perTick));
        Woot.debugSetup.trace(DebugSetup.EnumDebugType.POWER_CALC, "efficiency", "upgrade cost:" + cost);
        return cost;
    }

    @Override
    public void updateCalculatorValues(IFarmSetup iFarmSetup, BigIntegerCalculator.CalculatorValues calculatorValues) {
        calculatorValues.efficiency = Woot.wootConfiguration.getInteger(iFarmSetup.getWootMobName(), ConfigKeyHelper.getEffParam(iFarmSetup.getUpgradeLevel(EnumFarmUpgrade.EFFICIENCY)));
        Woot.debugSetup.trace(DebugSetup.EnumDebugType.POWER_CALC, "efficiency", "upgrade value:" + calculatorValues.efficiency);
    }
}

