/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.policy;

import ipsis.woot.policy.IPolicy;
import ipsis.woot.util.ItemStackHelper;
import ipsis.woot.util.WootMobName;
import ipsis.woot.util.WootMobNameBuilder;
import net.minecraft.item.ItemStack;

public class InternalPolicyLoader {
    private static final String[] BLACKLIST_ENTITIES_FROM_MODS = new String[]{"cyberware", "withercrumbs"};
    private static final String[] BLACKLIST_ENTITIES = new String[]{"arsmagicsa2:Dryad", "abyssalcraft:lesserdreadbeast", "abyssalcraft:greaterdreadspawn", "abyssalcraft:chagaroth", "abyssalcraft:shadowboss", "abyssalcraft:Jzahar", "roots:spriteGuardian", "twilightforest:lich", "twilightforest:knight_phantom", "twilightforest:quest_ram", "forestry:butterflyge", "erebus:erebus.animated_block", "erebus:erebus.umber_golem"};
    private static final String[] BLACKLIST_DROPS_FROMS_MODS = new String[]{"eplus", "everlastingabilities", "cyberware"};
    private static final String[] BLACKLIST_ITEMS = new String[0];

    public void load(IPolicy policy) {
        for (String modName : BLACKLIST_ENTITIES_FROM_MODS) {
            policy.addModToEntityList(modName, true);
        }
        for (String entityName : BLACKLIST_ENTITIES) {
            WootMobName wootMobName = WootMobNameBuilder.createFromConfigString(entityName);
            if (!wootMobName.isValid()) continue;
            policy.addEntityToEntityList(wootMobName, true);
        }
        for (String modName : BLACKLIST_DROPS_FROMS_MODS) {
            policy.addModToDropList(modName, true);
        }
        for (String drop : BLACKLIST_ITEMS) {
            ItemStack itemStack = ItemStackHelper.getItemStackFromName(drop);
            if (itemStack.func_190926_b()) continue;
            policy.addItemToDropList(itemStack, true);
        }
    }
}

