/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.plugins.bloodmagic;

import WayofTime.bloodmagic.api.impl.BloodMagicAPI;
import WayofTime.bloodmagic.ritual.IMasterRitualStone;
import ipsis.Woot;
import ipsis.woot.plugins.bloodmagic.BloodMagic;
import ipsis.woot.util.DebugSetup;
import ipsis.woot.util.WootMobName;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class BloodMagicHelper {
    @Nonnull
    public static ItemStack createWill() {
        return ItemStack.field_190927_a;
    }

    public static int getLifeEssenceRatio(WootMobName wootMobName) {
        int lifeEssenceRatio = 0;
        if (!BloodMagicAPI.INSTANCE.getBlacklist().getSacrifice().contains(wootMobName.getResourceLocation())) {
            lifeEssenceRatio = BloodMagicAPI.INSTANCE.getValueManager().getSacrificial().getOrDefault(wootMobName.getResourceLocation(), 25);
        } else {
            Woot.debugSetup.trace(DebugSetup.EnumDebugType.GEN_BM_LE, "createBloodEssence", wootMobName + " is blacklisted by BM");
        }
        return lifeEssenceRatio;
    }

    @Nonnull
    public static FluidStack createBloodEssence(WootMobName wootMobName, int numMobs, int sacrificeRuneCount) {
        Woot.debugSetup.trace(DebugSetup.EnumDebugType.GEN_BM_LE, "createBloodEssence", wootMobName + ":" + numMobs + " sacrificeRuneCount:" + sacrificeRuneCount);
        FluidStack out = new FluidStack(BloodMagic.lifeEssence, 0);
        int lifeEssenceRatio = BloodMagicHelper.getLifeEssenceRatio(wootMobName);
        if (lifeEssenceRatio > 0) {
            float sacrificeEfficiencyMultiplier = (float)(0.1 * (double)sacrificeRuneCount);
            out.amount = (int)((float)numMobs * ((1.0f + sacrificeEfficiencyMultiplier) * (float)lifeEssenceRatio));
            Woot.debugSetup.trace(DebugSetup.EnumDebugType.GEN_BM_LE, "createBloodEssence", "lifeEssenceRate:" + lifeEssenceRatio + " sacrificeEfficiencyMultiplier:" + sacrificeEfficiencyMultiplier);
        }
        Woot.debugSetup.trace(DebugSetup.EnumDebugType.GEN_BM_LE, "createBloodEssence", out);
        return out;
    }

    public static boolean canPerformRitual(IMasterRitualStone masterRitualStone, int refreshCost) {
        int currentEssence = masterRitualStone.getOwnerNetwork().getCurrentEssence();
        if (currentEssence < refreshCost) {
            masterRitualStone.getOwnerNetwork().causeNausea();
            return false;
        }
        return true;
    }
}

