/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.loot.schools;

import ipsis.Woot;
import ipsis.woot.farming.ITickTracker;
import ipsis.woot.farmstructure.IFarmSetup;
import ipsis.woot.loot.ILootLearner;
import ipsis.woot.util.DebugSetup;
import ipsis.woot.util.EnumEnchantKey;
import ipsis.woot.util.WootMobName;
import java.util.List;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TartarusSchool
implements ILootLearner {
    private int spawnId = -1;

    @Override
    public void tick(ITickTracker tickTracker, World world, BlockPos origin, IFarmSetup farmSetup) {
        if (!tickTracker.hasLearnTickExpired()) {
            return;
        }
        WootMobName wootMobName = farmSetup.getWootMobName();
        EnumEnchantKey key = farmSetup.getEnchantKey();
        Woot.debugSetup.trace(DebugSetup.EnumDebugType.TARTARUS, "TartarusSchool:tick", wootMobName + "/" + (Object)((Object)key) + " spawnid: " + this.spawnId + " count: " + Woot.lootRepository.getSampleCount(wootMobName, key));
        if (this.spawnId != -1) {
            List<EntityItem> items = Woot.tartarusManager.getLootInBox(world, this.spawnId);
            Woot.debugSetup.trace(DebugSetup.EnumDebugType.TARTARUS, "TartarusSchool:tick", "collecting drops " + items);
            Woot.lootRepository.learn(wootMobName, key, items, false);
            for (EntityItem i : items) {
                i.func_70106_y();
            }
        }
        if (!Woot.lootRepository.isFull(wootMobName, key)) {
            if (this.spawnId == -1) {
                this.spawnId = Woot.tartarusManager.allocateSpawnBoxId();
            }
            Woot.debugSetup.trace(DebugSetup.EnumDebugType.TARTARUS, "TartarusSchool:tick", "spawning mob");
            Woot.tartarusManager.spawnInBox(world, this.spawnId, wootMobName, key);
        } else if (this.spawnId != -1) {
            this.spawnId = Woot.tartarusManager.freeSpawnBoxId(this.spawnId);
        }
        tickTracker.resetLearnTickCount();
    }
}

