/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.loot.schools;

import ipsis.Woot;
import ipsis.woot.command.ITextStatus;
import ipsis.woot.loot.schools.SpawnBox;
import ipsis.woot.oss.LogHelper;
import ipsis.woot.util.DebugSetup;
import ipsis.woot.util.EnumEnchantKey;
import ipsis.woot.util.WootMobName;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class TartarusManager
implements ITextStatus {
    public static final int INVALID_SPAWN_ID = -1;
    private HashMap<Integer, SpawnBox> spawnBoxMap = new HashMap();

    private void buildSpawnBox(World world, SpawnBox spawnBox) {
        Block b = Blocks.field_150359_w;
        for (int y = 0; y < 8; ++y) {
            for (int x = 0; x < 8; ++x) {
                for (int z = 0; z < 8; ++z) {
                    BlockPos pos;
                    if (y == 0 || y == 7) {
                        pos = new BlockPos(spawnBox.getBasePos().func_177958_n() + x, spawnBox.getBasePos().func_177956_o() + y, spawnBox.getBasePos().func_177952_p() + z);
                        world.func_175656_a(pos, b.func_176223_P());
                        continue;
                    }
                    if (x != 0 && x != 7 && z != 0 && z != 7) continue;
                    pos = new BlockPos(spawnBox.getBasePos().func_177958_n() + x, spawnBox.getBasePos().func_177956_o() + y, spawnBox.getBasePos().func_177952_p() + z);
                    world.func_175656_a(pos, b.func_176223_P());
                }
            }
        }
    }

    private void init() {
        BlockPos origin = new BlockPos(0, 0, 0);
        int[] xOffsets = new int[]{0, 8, 0, 8};
        int[] zOffsets = new int[]{0, 0, 8, 8};
        int spawnId = 0;
        for (int y = 0; y < 256; y += 8) {
            for (int i = 0; i < 4; ++i) {
                BlockPos basePos = new BlockPos(origin.func_177958_n() + xOffsets[i], y, origin.func_177952_p() + zOffsets[i]);
                BlockPos spawnPos = new BlockPos(basePos.func_177958_n() + 4, basePos.func_177956_o() + 4, basePos.func_177952_p() + 4);
                this.spawnBoxMap.put(spawnId++, new SpawnBox(basePos, spawnPos));
            }
        }
    }

    public TartarusManager() {
        this.init();
        Woot.debugSetup.trace(DebugSetup.EnumDebugType.TARTARUS, "TartatrusManager", this.spawnBoxMap.keySet());
    }

    public void build(World world) {
        for (SpawnBox spawnBox : this.spawnBoxMap.values()) {
            this.buildSpawnBox(world, spawnBox);
        }
    }

    public int allocateSpawnBoxId() {
        for (int id : this.spawnBoxMap.keySet()) {
            if (this.spawnBoxMap.get(id).isUsed()) continue;
            this.spawnBoxMap.get(id).setUsed();
            Woot.debugSetup.trace(DebugSetup.EnumDebugType.TARTARUS, "allocateSpawnBoxId", "Id:" + id);
            return id;
        }
        Woot.debugSetup.trace(DebugSetup.EnumDebugType.TARTARUS, "allocateSpawnBoxId", "Id:INVALID");
        return -1;
    }

    public int freeSpawnBoxId(int id) {
        Woot.debugSetup.trace(DebugSetup.EnumDebugType.TARTARUS, "freeSpawnBoxId", "Id:" + id);
        if (this.spawnBoxMap.containsKey(id)) {
            this.spawnBoxMap.get(id).clearUsed();
        } else {
            LogHelper.error("freeSpawnBoxId: id " + id + " not allocated");
        }
        return -1;
    }

    public void spawnInBox(World world, int id, WootMobName wootMobName, EnumEnchantKey key) {
        Woot.debugSetup.trace(DebugSetup.EnumDebugType.TARTARUS, "spawnInBox", "Id:" + id + " " + wootMobName + " " + (Object)((Object)key));
        Woot.wootDimensionManager.touchSpawnChunk(world);
        if (id == -1) {
            return;
        }
        if (!this.spawnBoxMap.containsKey(id)) {
            LogHelper.error("spawnInBox: id " + id + " not allocated");
            return;
        }
        WorldServer spawnWorldServer = Woot.wootDimensionManager.getWorldServer(world);
        if (spawnWorldServer != null) {
            SpawnBox spawnBox = this.spawnBoxMap.get(id);
            Woot.entitySpawner.spawn(wootMobName, key, (World)spawnWorldServer, spawnBox.getSpawnPos());
        }
    }

    public List<EntityItem> getLootInBox(World world, int id) {
        Woot.debugSetup.trace(DebugSetup.EnumDebugType.TARTARUS, "getLootInBox", "Id:" + id);
        Woot.wootDimensionManager.touchSpawnChunk(world);
        ArrayList<EntityItem> itemList = new ArrayList<EntityItem>();
        if (!this.spawnBoxMap.containsKey(id)) {
            LogHelper.error("getLootInBox: id " + id + " not allocated");
            return itemList;
        }
        SpawnBox spawnBox = this.spawnBoxMap.get(id);
        WorldServer spawnWorldServer = Woot.wootDimensionManager.getWorldServer(world);
        if (spawnWorldServer != null) {
            itemList.addAll(spawnWorldServer.func_175647_a(EntityItem.class, spawnBox.getAxisAlignedBB(), EntitySelectors.field_94557_a));
        }
        return itemList;
    }

    @Override
    public List<String> getStatus(WorldServer worldServer) {
        ArrayList<String> status = new ArrayList<String>();
        boolean canUnload = true;
        for (Integer spawnId : this.spawnBoxMap.keySet()) {
            if (!this.spawnBoxMap.get(spawnId).isUsed()) continue;
            status.add(String.format("%d: %s", spawnId, this.spawnBoxMap.get(spawnId)));
            canUnload = false;
        }
        status.add("Can unload tartarus: " + canUnload);
        return status;
    }

    @Override
    public List<String> getStatus() {
        return new ArrayList<String>();
    }
}

