/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.farming;

import ipsis.woot.farming.ISpawnRecipeRepository;
import ipsis.woot.farming.SpawnRecipe;
import ipsis.woot.oss.LogHelper;
import ipsis.woot.util.WootMobName;
import java.util.HashMap;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class SpawnRecipeRepository
implements ISpawnRecipeRepository {
    HashMap<WootMobName, SpawnRecipe> recipes = new HashMap();
    private SpawnRecipe defaultSpawnRecipe = new SpawnRecipe();

    public SpawnRecipeRepository() {
        this.defaultSpawnRecipe.setEfficiency(true);
    }

    @Override
    @Nullable
    public SpawnRecipe get(WootMobName wootMobName) {
        if (this.recipes.containsKey(wootMobName)) {
            return this.recipes.get(wootMobName);
        }
        return this.defaultSpawnRecipe;
    }

    @Override
    public void add(WootMobName wootMobName, SpawnRecipe recipe) {
        if (recipe.getItems().size() > 6) {
            LogHelper.error("Too many spawn recipe item ingredients max of 6 " + wootMobName.toString());
            return;
        }
        if (recipe.getFluids().size() > 6) {
            LogHelper.error("Too many spawn recipe fluid ingredients max of 6 " + wootMobName.toString());
            return;
        }
        LogHelper.info("Add spawn recipe ingredients for " + wootMobName + "->" + recipe);
        this.recipes.put(wootMobName, recipe);
    }

    @Override
    public Set<WootMobName> getAllMobs() {
        return this.recipes.keySet();
    }

    @Override
    public void addDefaultItem(ItemStack itemStack) {
        this.defaultSpawnRecipe.addIngredient(itemStack);
        LogHelper.info("Add default spawn recipe ingredient " + itemStack.func_82833_r() + "x" + itemStack.func_190916_E());
    }

    @Override
    public void addDefaultFluid(FluidStack fluidStack) {
        this.defaultSpawnRecipe.addIngredient(fluidStack);
        LogHelper.info("Add default spawn recipe fluid " + fluidStack.getLocalizedName() + "x" + fluidStack.amount + "mb");
    }

    @Override
    public void setDefaultEfficiency(boolean efficiency) {
        this.defaultSpawnRecipe.setEfficiency(efficiency);
        LogHelper.info("Setting default spawn recipe efficiency support " + efficiency);
    }
}

