/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.client.gui.element;

import ipsis.woot.client.gui.GuiContainerWoot;
import ipsis.woot.client.gui.element.ElementBase;
import ipsis.woot.client.gui.element.WidgetBar;
import ipsis.woot.client.gui.element.WidgetText;
import java.awt.Color;
import net.minecraft.client.gui.FontRenderer;

public class ElementProgress
extends ElementBase {
    private int tagX;
    private int tagY;
    private int barX;
    private int barY;
    private int barWidth;
    private int curr;
    private int max;
    private int color;
    private String tag;
    private int type;
    private final int PAD = 1;

    public ElementProgress(GuiContainerWoot guiContainerWoot, FontRenderer fontRenderer, String header, String tag, int type, int color, int baseX, int baseY, int sizeX, int sizeY) {
        super(guiContainerWoot, fontRenderer, header, baseX, baseY, sizeX, sizeY);
        this.tag = tag;
        this.type = type;
        this.color = color;
        this.curr = 0;
        int tagLen = fontRenderer.func_78256_a(tag);
        this.tagX = this.contentX;
        this.tagY = this.contentY;
        this.barX = this.contentX + tagLen + 2 + 1;
        this.barY = this.contentY;
        this.barWidth = this.contentSizeX - this.contentX - tagLen - 2 - 2;
    }

    @Override
    public void drawBackground(int mouseX, int mouseY) {
        super.drawBackground(mouseX, mouseY);
        int percentage = (int)(100.0f / (float)this.max * (float)this.curr);
        WidgetBar.draw(this.gui, this.gui.getGuiLeft() + this.barX, this.gui.getGuiTop() + this.barY, this.barWidth, percentage, this.color);
    }

    @Override
    public void drawForeground(int mouseX, int mouseY) {
        super.drawForeground(mouseX, mouseY);
        WidgetText.draw(this.fontRenderer, this.tag, this.tagX, this.tagY, Color.white.getRGB());
        String s = this.curr + "%";
        if (this.type == 1) {
            s = this.curr + "/" + this.max;
        }
        int textX = this.barX + this.barWidth / 2 - this.fontRenderer.func_78256_a(s) / 2;
        int textY = this.barY + 1;
        WidgetText.draw(this.fontRenderer, s, textX, textY, Color.white.getRGB());
    }

    public void setMax(int max) {
        this.max = max;
    }

    public void updateProgress(int curr) {
        this.curr = curr;
    }
}

