/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.client.gui;

import ipsis.woot.client.gui.GuiContainerWoot;
import ipsis.woot.client.gui.element.DisplayFluidStack;
import ipsis.woot.client.gui.element.DisplayItemStack;
import ipsis.woot.client.gui.element.ElementBase;
import ipsis.woot.client.gui.element.ElementProgress;
import ipsis.woot.client.gui.element.ElementStackBox;
import ipsis.woot.client.gui.element.ElementTextBox;
import ipsis.woot.client.gui.inventory.FactoryHeartContainer;
import ipsis.woot.network.PacketHandler;
import ipsis.woot.network.packets.PacketGetFarmInfo;
import ipsis.woot.oss.LogHelper;
import ipsis.woot.tileentity.TileEntityMobFactoryHeart;
import ipsis.woot.tileentity.ui.FarmUIInfo;
import java.awt.Color;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class FactoryHeartContainerGui
extends GuiContainerWoot {
    private static final int WIDTH = 256;
    private static final int HEIGHT = 224;
    private static final int GUI_X_MARGIN = 4;
    private static final int GUI_Y_MARGIN = 4;
    private TileEntityMobFactoryHeart te;
    private FactoryHeartContainer container;
    private static final ResourceLocation bg = new ResourceLocation("woot", "textures/gui/heart.png");
    private List<ElementBase> elementBaseList = new ArrayList<ElementBase>();
    private ElementTextBox recipeElement;
    private ElementProgress progressElementPower;
    private ElementProgress progressElementRecipe;
    private ElementStackBox ingredientElement;
    private ElementStackBox dropsElement;
    private boolean init = false;
    private static DecimalFormat dfCommas = new DecimalFormat("###,###");

    public void func_73866_w_() {
        super.func_73866_w_();
        this.requestFarmInfo();
        int panelWidth = 248;
        int panelMargin = 4;
        int recipeHeight = 55;
        int progressHeight0 = 18;
        int progressHeight1 = 18;
        int ingredientHeight = 40;
        int dropsHeight = 216 - recipeHeight - progressHeight0 - progressHeight1 - ingredientHeight - 4 * panelMargin;
        this.recipeElement = new ElementTextBox(this, this.field_146289_q, "Configuration", 4, 4, panelWidth, recipeHeight);
        this.progressElementPower = new ElementProgress(this, this.field_146289_q, null, "Power", 1, Color.red.getRGB(), 4, 4 + recipeHeight + panelMargin, panelWidth, progressHeight0);
        this.progressElementRecipe = new ElementProgress(this, this.field_146289_q, null, "Spawning", 0, Color.orange.getRGB(), 4, 4 + recipeHeight + progressHeight0 + panelMargin * 2, panelWidth, progressHeight0);
        this.ingredientElement = new ElementStackBox(this, this.field_146289_q, "Ingredients", 4, 4 + recipeHeight + progressHeight0 + progressHeight1 + panelMargin * 3, panelWidth, ingredientHeight);
        this.dropsElement = new ElementStackBox(this, this.field_146289_q, "Drops", 4, 4 + recipeHeight + progressHeight0 + progressHeight1 + ingredientHeight + panelMargin * 4, panelWidth, dropsHeight);
        this.elementBaseList.add(this.recipeElement);
        this.elementBaseList.add(this.progressElementPower);
        this.elementBaseList.add(this.progressElementRecipe);
        this.elementBaseList.add(this.ingredientElement);
        this.elementBaseList.add(this.dropsElement);
    }

    public FactoryHeartContainerGui(TileEntityMobFactoryHeart te, FactoryHeartContainer container) {
        super(container);
        this.field_146999_f = 256;
        this.field_147000_g = 224;
        this.container = container;
        this.te = te;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        FarmUIInfo info;
        if (!this.init && this.container.hasServerSync() && (info = this.te.getGuiFarmInfo()) != null) {
            DisplayItemStack displayItemStack;
            String s = info.tier.getTranslated("info.woot.tier");
            s = s + " " + info.mobName + " * " + info.mobCount;
            this.recipeElement.addString(s);
            String s1 = dfCommas.format(info.recipeTotalPower) + "RF";
            String s2 = dfCommas.format(info.recipePowerPerTick) + "RF/tick";
            this.recipeElement.addString(TextFormatting.GREEN + "Power: " + s1 + " @ " + s2);
            this.recipeElement.addString(TextFormatting.GREEN + "Time: " + info.recipeTotalTime + " ticks");
            if (info.missingIngredients) {
                LogHelper.info("Missing ingredients");
                this.ingredientElement.setShowFlag(true);
            }
            for (ItemStack itemStack : info.ingredientsItems) {
                displayItemStack = this.ingredientElement.addItemStack(itemStack);
                displayItemStack.appendTooltip(itemStack.func_190916_E() + " per mob");
            }
            for (FluidStack fluidStack : info.ingredientsFluids) {
                DisplayFluidStack displayFluidStack = this.ingredientElement.addFluidStack(fluidStack);
                displayFluidStack.appendTooltip(fluidStack.amount + "mb per mob");
            }
            for (ItemStack itemStack : info.drops) {
                displayItemStack = this.dropsElement.addItemStack(itemStack);
                displayItemStack.appendTooltip("Chance: " + itemStack.func_190916_E() + "%");
            }
            this.progressElementPower.setMax(info.powerCapacity);
            this.progressElementRecipe.setMax(100);
            this.init = true;
        }
        this.progressElementPower.updateProgress(this.te.guiStoredPower);
        this.progressElementRecipe.updateProgress(this.te.guiProgress);
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.field_146297_k.func_110434_K().func_110577_a(bg);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        for (ElementBase elementBase : this.elementBaseList) {
            elementBase.drawBackground(mouseX - this.field_147003_i, mouseY - this.field_147009_r);
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        for (ElementBase elementBase : this.elementBaseList) {
            elementBase.drawForeground(mouseX - this.field_147003_i, mouseY - this.field_147009_r);
        }
    }

    private void requestFarmInfo() {
        PacketHandler.INSTANCE.sendToServer((IMessage)new PacketGetFarmInfo(this.te.func_174877_v()));
    }
}

