/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.block;

import ipsis.Woot;
import ipsis.woot.block.BlockWoot;
import ipsis.woot.configuration.EnumConfigKey;
import ipsis.woot.power.storage.IPowerStation;
import ipsis.woot.tileentity.TileEntityMobFactoryCell;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockMobFactoryCell
extends BlockWoot
implements ITileEntityProvider {
    public static final String BASENAME = "cell";
    public static final PropertyBool FORMED = PropertyBool.func_177716_a((String)"formed");
    public static final PropertyEnum<EnumCellTier> TIER = PropertyEnum.func_177709_a((String)"tier", EnumCellTier.class);

    public BlockMobFactoryCell() {
        super(Material.field_151576_e, BASENAME);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(TIER, (Comparable)((Object)EnumCellTier.TIER_I)).func_177226_a((IProperty)FORMED, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public TileEntity func_149915_a(World worldIn, int meta) {
        TileEntityMobFactoryCell te = new TileEntityMobFactoryCell();
        te.setTier(EnumCellTier.byMetadata(meta));
        return te;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TIER, FORMED});
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TileEntityMobFactoryCell) {
            ((TileEntityMobFactoryCell)te).onBlockAdded();
        }
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        if (worldIn.func_175625_s(pos) instanceof TileEntityMobFactoryCell) {
            TileEntityMobFactoryCell te = (TileEntityMobFactoryCell)worldIn.func_175625_s(pos);
            boolean formed = false;
            if (te != null) {
                formed = te.isClientFormed();
            }
            return state.func_177226_a((IProperty)FORMED, (Comparable)Boolean.valueOf(formed));
        }
        return state;
    }

    public int func_180651_a(IBlockState state) {
        return ((EnumCellTier)((Object)state.func_177229_b(TIER))).getMetadata();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> items) {
        for (EnumCellTier t : EnumCellTier.values()) {
            items.add((Object)new ItemStack((Block)this, 1, t.getMetadata()));
        }
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(TIER, (Comparable)((Object)EnumCellTier.byMetadata(meta))).func_177226_a((IProperty)FORMED, (Comparable)Boolean.valueOf(false));
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return true;
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumCellTier)((Object)state.func_177229_b(TIER))).getMetadata();
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityMobFactoryCell) {
            List drops = super.getDrops(world, pos, state, fortune);
            IPowerStation powerStation = ((TileEntityMobFactoryCell)te).getPowerStation();
            if (powerStation != null && !drops.isEmpty()) {
                NBTTagCompound compound = ((ItemStack)drops.get(0)).func_77978_p();
                if (compound == null) {
                    compound = new NBTTagCompound();
                    ((ItemStack)drops.get(0)).func_77982_d(compound);
                }
                powerStation.writeToNBT(compound);
            }
            return drops;
        }
        return super.getDrops(world, pos, state, fortune);
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity te;
        super.func_180633_a(worldIn, pos, state, placer, stack);
        if (stack.func_77942_o() && !worldIn.field_72995_K && (te = worldIn.func_175625_s(pos)) instanceof TileEntityMobFactoryCell) {
            ((TileEntityMobFactoryCell)te).getPowerStation().readFromNBT(stack.func_77978_p());
        }
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        this.func_176206_d(world, pos, state);
        if (willHarvest) {
            this.func_180657_a(world, player, pos, state, world.func_175625_s(pos), player.func_184614_ca());
        }
        world.func_175698_g(pos);
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        Item itemBlockVariants = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation("woot", BASENAME));
        for (int i = 0; i < EnumCellTier.VALUES.length; ++i) {
            EnumCellTier e = EnumCellTier.VALUES[i];
            ModelResourceLocation itemModelResourceLocation = new ModelResourceLocation("woot:cell_" + (Object)((Object)e), "inventory");
            ModelLoader.setCustomModelResourceLocation((Item)itemBlockVariants, (int)i, (ModelResourceLocation)itemModelResourceLocation);
        }
    }

    public static enum EnumCellTier implements IStringSerializable
    {
        TIER_I("tier_i"),
        TIER_II("tier_ii"),
        TIER_III("tier_iii");

        String name;
        public static EnumCellTier[] VALUES;

        private EnumCellTier(String name) {
            this.name = name;
        }

        public String func_176610_l() {
            return this.name;
        }

        int getMetadata() {
            return this.ordinal();
        }

        public static EnumCellTier byMetadata(int metadata) {
            if (metadata < 0 || metadata >= VALUES.length) {
                return TIER_I;
            }
            return VALUES[metadata];
        }

        public static int getMaxPower(EnumCellTier tier) {
            if (tier == TIER_I) {
                return Woot.wootConfiguration.getInteger(EnumConfigKey.T1_POWER_MAX);
            }
            if (tier == TIER_II) {
                return Woot.wootConfiguration.getInteger(EnumConfigKey.T2_POWER_MAX);
            }
            return Woot.wootConfiguration.getInteger(EnumConfigKey.T3_POWER_MAX);
        }

        public static int getMaxTransfer(EnumCellTier tier) {
            if (tier == TIER_I) {
                return Woot.wootConfiguration.getInteger(EnumConfigKey.T1_POWER_RX_TICK);
            }
            if (tier == TIER_II) {
                return Woot.wootConfiguration.getInteger(EnumConfigKey.T2_POWER_RX_TICK);
            }
            return Woot.wootConfiguration.getInteger(EnumConfigKey.T3_POWER_RX_TICK);
        }

        static {
            VALUES = new EnumCellTier[]{TIER_I, TIER_II, TIER_III};
        }
    }
}

