/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.blocks;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.realmsclient.gui.ChatFormatting;
import com.rwtema.extrautils2.ExtraUtils2;
import com.rwtema.extrautils2.achievements.AchievementHelper;
import com.rwtema.extrautils2.backend.PropertyEnumSimple;
import com.rwtema.extrautils2.backend.XUBlockStateCreator;
import com.rwtema.extrautils2.backend.XUBlockStatic;
import com.rwtema.extrautils2.backend.entries.IItemStackMaker;
import com.rwtema.extrautils2.backend.entries.XU2Entries;
import com.rwtema.extrautils2.backend.model.BoxModel;
import com.rwtema.extrautils2.backend.model.XUBlockState;
import com.rwtema.extrautils2.blocks.BlockDecorativeSolid;
import com.rwtema.extrautils2.crafting.CraftingHelper;
import com.rwtema.extrautils2.items.ItemIngredients;
import com.rwtema.extrautils2.power.IWorldPowerMultiplier;
import com.rwtema.extrautils2.power.PowerMultipliers;
import com.rwtema.extrautils2.structure.PatternRecipe;
import com.rwtema.extrautils2.tile.TilePassiveGenerator;
import com.rwtema.extrautils2.tile.TilePower;
import com.rwtema.extrautils2.tile.TilePowerHandCrank;
import com.rwtema.extrautils2.utils.Lang;
import com.rwtema.extrautils2.utils.helpers.BlockStates;
import com.rwtema.extrautils2.utils.helpers.StringHelper;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.input.Keyboard;

public class BlockPassiveGenerator
extends XUBlockStatic {
    public static final PropertyEnumSimple<GeneratorType> GENERATOR_TYPE = new PropertyEnumSimple<GeneratorType>(GeneratorType.class);
    public static final int BASE_SOLAR_VALUE = 2;
    private static final float LOSS_1 = 0.6666666f;
    private static final float LOSS_2 = 0.5f;
    private static final float LOSS_3 = 0.2f;
    private static final float LOSS_4 = 0.1f;

    public BlockPassiveGenerator() {
        super(Material.field_151576_e);
    }

    private static int getBaseSolarPower(World world) {
        return world.func_72935_r() ? 2 : 0;
    }

    @Override
    @Nonnull
    protected XUBlockStateCreator createBlockState() {
        return new XUBlockStateCreator.Builder(this).addDropProperties(new IProperty[]{GENERATOR_TYPE}).addMetaProperty(TilePower.ENABLED_STATE).build();
    }

    @Override
    public BoxModel getModel(IBlockState baseState) {
        GeneratorType value = (GeneratorType)((Object)baseState.func_177229_b(GENERATOR_TYPE));
        BoxModel model = new BoxModel();
        value.createModel(model, false);
        return model;
    }

    @Override
    public BoxModel getModelInv(IBlockState baseState) {
        GeneratorType value = (GeneratorType)((Object)baseState.func_177229_b(GENERATOR_TYPE));
        BoxModel model = new BoxModel();
        value.createModel(model, true);
        return model;
    }

    @Nonnull
    public TileEntity createTileEntity(@Nonnull World world, @Nonnull IBlockState state) {
        return ((GeneratorType)((Object)state.func_177229_b(GENERATOR_TYPE))).createTileEntity(world);
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nonnull
    public BlockRenderLayer func_180664_k() {
        return super.func_180664_k();
    }

    @Override
    public boolean canReplaceBase(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull EnumFacing side, ItemStack stack) {
        if (!super.canReplaceBase(worldIn, pos, side, stack)) {
            return false;
        }
        XUBlockState state = this.xuBlockState.getStateFromItemStack(stack);
        return ((GeneratorType)((Object)state.func_177229_b((IProperty)GENERATOR_TYPE))).validPos(worldIn, pos);
    }

    @Override
    public void neighborChangedBase(IBlockState state, World worldIn, BlockPos pos, Block neighborBlock) {
        if (!((GeneratorType)((Object)state.func_177229_b(GENERATOR_TYPE))).validPos(worldIn, pos)) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
            return;
        }
        super.neighborChangedBase(state, worldIn, pos, neighborBlock);
    }

    @Override
    public void addInformation(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        ((GeneratorType)((Object)this.xuBlockState.getStateFromItemStack(stack).func_177229_b((IProperty)GENERATOR_TYPE))).addInformation(stack, playerIn, tooltip, advanced);
    }

    public float func_176195_g(IBlockState blockState, World worldIn, BlockPos pos) {
        if (blockState == this.func_176223_P().func_177226_a(GENERATOR_TYPE, (Comparable)((Object)GeneratorType.CREATIVE)) && !ExtraUtils2.allowCreativeBlocksToBeBroken) {
            return -1.0f;
        }
        return super.func_176195_g(blockState, worldIn, pos);
    }

    public static enum GeneratorType implements IItemStackMaker,
    IWorldPowerMultiplier
    {
        SOLAR(PowerMultipliers.SOLAR, new float[]{80.0f, 0.6666666f, 160.0f, 0.5f, 320.0f, 0.2f}){

            @Override
            public void registerAchievements() {
                AchievementHelper.addAchievement("Solar Panel", "The sun gives power to all!", this, ItemIngredients.Type.REDSTONE_CRYSTAL);
            }

            @Override
            public float getPowerLevel(TilePassiveGenerator generator, World world) {
                if (!world.func_175678_i(generator.func_174877_v().func_177984_a())) {
                    return 0.0f;
                }
                return 1.0f;
            }

            @Override
            public void createModel(BoxModel model, boolean isInv) {
                model.addBoxI(0, 0, 0, 16, 4, 16).setTextureSides("panel_side", 0, "panel_bottom", 1, "panel_solar");
            }

            @Override
            public boolean validPos(World world, BlockPos pos) {
                return world.isSideSolid(pos.func_177977_b(), EnumFacing.UP);
            }

            @Override
            public void addRecipe() {
                CraftingHelper.addShaped("mill_solar", this.newStack(3), "LLL", "BRB", Character.valueOf('L'), "gemLapis", Character.valueOf('R'), ItemIngredients.Type.REDSTONE_CRYSTAL.newStack(1), Character.valueOf('B'), BlockDecorativeSolid.DecorStates.stoneslab.newStack(1));
            }

            @Override
            @SideOnly(value=Side.CLIENT)
            public void addInformation(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
                tooltip.add(Lang.translate("Gives power during daylight hours."));
                tooltip.add(Lang.translate("Must have clear line of sight to sky."));
                tooltip.add(Lang.translate("Power reduced by rain."));
                super.addInformation(stack, playerIn, tooltip, advanced);
            }
        }
        ,
        LUNAR(PowerMultipliers.LUNAR, new float[]{80.0f, 0.6666666f, 160.0f, 0.5f, 320.0f, 0.2f}){

            @Override
            public void registerAchievements() {
                AchievementHelper.addAchievement("Lunar Panel", "The moon gives power to all!", this, ItemIngredients.Type.DYE_POWDER_LUNAR);
            }

            @Override
            public float getPowerLevel(TilePassiveGenerator generator, World world) {
                if (!world.func_175678_i(generator.func_174877_v().func_177984_a())) {
                    return 0.0f;
                }
                return 1.0f;
            }

            @Override
            public void createModel(BoxModel model, boolean isInv) {
                model.addBoxI(0, 0, 0, 16, 4, 16).setTexture("panel_side").setTextureSides(0, "panel_bottom", 1, "panel_lunar");
            }

            @Override
            public boolean validPos(World worldIn, BlockPos pos) {
                return worldIn.isSideSolid(pos.func_177977_b(), EnumFacing.UP);
            }

            @Override
            public void addRecipe() {
                CraftingHelper.addShaped("mill_lunar", this.newStack(3), "LLL", "BrB", Character.valueOf('L'), ItemIngredients.Type.DYE_POWDER_LUNAR.newStack(1), Character.valueOf('r'), ItemIngredients.Type.REDSTONE_CRYSTAL.newStack(1), Character.valueOf('B'), BlockDecorativeSolid.DecorStates.stoneslab.newStack(1));
            }

            @Override
            @SideOnly(value=Side.CLIENT)
            public void addInformation(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
                tooltip.add(Lang.translate("Gives power during night hours."));
                tooltip.add(Lang.translate("Must have clear line of sight to sky."));
                tooltip.add(Lang.translate("Power boosted by full moon."));
                tooltip.add(Lang.translate("Power reduced by rain."));
                super.addInformation(stack, playerIn, tooltip, advanced);
            }
        }
        ,
        LAVA(IWorldPowerMultiplier.CONSTANT, new float[]{200.0f, 0.6666666f, 400.0f, 0.5f, 800.0f, 0.2f}){

            @Override
            public void registerAchievements() {
                AchievementHelper.addAchievement("Lava XUMachineGenerators", "Adjacent heat! It burns!", this, BlockDecorativeSolid.DecorStates.stoneburnt);
            }

            @Override
            public float getPowerLevel(TilePassiveGenerator generator, World world) {
                float h = 0.0f;
                for (EnumFacing enumFacing : EnumFacing.field_176754_o) {
                    BlockPos offset = generator.func_174877_v().func_177972_a(enumFacing);
                    IBlockState blockState = generator.func_145831_w().func_180495_p(offset);
                    Block block = blockState.func_177230_c();
                    if (block != Blocks.field_150353_l && block != Blocks.field_150356_k || (h = Math.max(h, (float)(8 - (Integer)blockState.func_177229_b((IProperty)BlockLiquid.field_176367_b)))) != 8.0f) continue;
                    return 2.0f;
                }
                return h / 2.0f;
            }

            @Override
            public float basePowerGen() {
                return 4.0f;
            }

            @Override
            @SideOnly(value=Side.CLIENT)
            public void addInformation(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
                tooltip.add(Lang.translate("Operates when adjacent to lava."));
                super.addInformation(stack, playerIn, tooltip, advanced);
            }

            @Override
            public void createModel(BoxModel model, boolean isInv) {
                model.addBoxI(0, 0, 0, 16, 16, 16, "panel_base").setTextureSides(0, "panel_lava", 1, "panel_lava");
            }

            @Override
            public void addRecipe() {
                CraftingHelper.addShaped("mill_lava", this.newStack(1), "BBB", "BRB", "BgB", Character.valueOf('g'), "ingotGold", Character.valueOf('R'), ItemIngredients.Type.REDSTONE_CRYSTAL.newStack(1), Character.valueOf('B'), BlockDecorativeSolid.DecorStates.stoneburnt.newStack(1));
                PatternRecipe.register(new String[][]{{"bbb", "bbb", "bbb"}, {" g ", "glg", " g "}}, (Map<Character, Object>)ImmutableMap.builder().put((Object)Character.valueOf('l'), (Object)BlockStates.LAVA_LEVEL_0).put((Object)Character.valueOf('g'), (Object)this.getMyBlockState()).put((Object)Character.valueOf('b'), (Object)Blocks.field_180401_cv).build(), this.newStack());
            }
        }
        ,
        WATER(IWorldPowerMultiplier.CONSTANT, new float[]{64.0f, 0.6666666f, 128.0f, 0.5f, 512.0f, 0.1f}){

            @Override
            public float basePowerGen() {
                return 4.0f;
            }

            @Override
            public void registerAchievements() {
                AchievementHelper.addAchievement("Water Mill", "The Flow of Water", this, BlockDecorativeSolid.DecorStates.stoneburnt);
            }

            @Override
            public float getPowerLevel(TilePassiveGenerator generator, World world) {
                float v = 0.0f;
                for (EnumFacing enumFacing : EnumFacing.field_176754_o) {
                    int value;
                    BlockPos offset = generator.func_174877_v().func_177972_a(enumFacing);
                    IBlockState blockState = world.func_180495_p(offset);
                    Block block = blockState.func_177230_c();
                    if (!this.isWater(block) || this.isWater(world.func_180495_p(offset.func_177984_a()).func_177230_c()) || (value = 8 - (Integer)blockState.func_177229_b((IProperty)BlockLiquid.field_176367_b)) >= 8) continue;
                    v += (float)((value + 1) / 2);
                }
                return v;
            }

            @Override
            @SideOnly(value=Side.CLIENT)
            public void addInformation(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
                tooltip.add(Lang.translate("Gives GP for adjacent flowing water blocks."));
                tooltip.add(Lang.translate("The higher the level, the more GP."));
                tooltip.add(Lang.translate("Source/full water blocks do not count."));
                super.addInformation(stack, playerIn, tooltip, advanced);
            }

            private boolean isWater(Block block) {
                return block == Blocks.field_150355_j || block == Blocks.field_150358_i;
            }

            @Override
            public void createModel(BoxModel model, boolean isInv) {
                model.addBoxI(0, 0, 0, 16, 16, 16, "panel_base").setTextureSides(1, "panel_water");
                model.addBoxOverlay(0.0f).setTexture("fan_spinning_small").setInvisible(3).setLayer(BlockRenderLayer.CUTOUT);
            }

            @Override
            public void addRecipe() {
                CraftingHelper.addShaped("mill_water", this.newStack(1), "BBB", "gRg", "BBB", Character.valueOf('g'), ItemIngredients.Type.REDSTONE_GEAR.newStack(1), Character.valueOf('R'), ItemIngredients.Type.REDSTONE_CRYSTAL.newStack(1), Character.valueOf('B'), BlockDecorativeSolid.DecorStates.stoneburnt.newStack(1));
                PatternRecipe.register(new String[][]{{"bbbbb", "bbbbb", "bbbbb", "bbbbb", "bbbbb"}, {"bbbbb", "bWwbb", "bwgwb", "bbwWb", "bbbbb"}}, (Map<Character, Object>)ImmutableMap.builder().put((Object)Character.valueOf('W'), (Object)BlockStates.WATER_LEVEL_0).put((Object)Character.valueOf('w'), (Object)BlockStates.WATER_LEVEL_1).put((Object)Character.valueOf('g'), (Object)this.getMyBlockState()).put((Object)Character.valueOf('b'), (Object)Blocks.field_180401_cv).build(), this.newStack());
            }
        }
        ,
        WIND(PowerMultipliers.WIND, new float[]{512.0f, 0.5f, 1024.0f, 0.2f}){
            EnumFacing[] sides = new EnumFacing[]{EnumFacing.SOUTH, EnumFacing.NORTH};

            @Override
            public void registerAchievements() {
                AchievementHelper.addAchievement("Wind Mill", "Winds light to variable", this, BlockDecorativeSolid.DecorStates.stoneburnt);
            }

            @Override
            public float getPowerLevel(TilePassiveGenerator generator, World world) {
                for (EnumFacing enumFacing : this.sides) {
                    if (world.func_175623_d(generator.func_174877_v().func_177972_a(enumFacing))) continue;
                    return 0.0f;
                }
                return this.basePowerGen();
            }

            @Override
            public void createModel(BoxModel model, boolean isInv) {
                model.addBoxI(0, 0, 0, 16, 1, 16, "panel_base").setTextureSides(0, "panel_air");
                model.addBoxI(0, 15, 0, 16, 16, 16, "panel_base").setTextureSides(1, "panel_air");
                model.addBoxI(0, 1, 0, 1, 15, 16, "panel_base");
                model.addBoxI(15, 1, 0, 16, 15, 16, "panel_base");
                model.addBoxI(1, 1, 8, 15, 15, 8, "fan_spinning").setInvisible(true, true, false, false, true, true).setLayer(BlockRenderLayer.CUTOUT);
            }

            @Override
            public void addRecipe() {
                CraftingHelper.addShaped("mill_wind", this.newStack(1), true, "BBB", " gR", "BBB", Character.valueOf('g'), ItemIngredients.Type.REDSTONE_GEAR.newStack(1), Character.valueOf('R'), ItemIngredients.Type.REDSTONE_CRYSTAL.newStack(1), Character.valueOf('B'), BlockDecorativeSolid.DecorStates.stoneburnt.newStack(1));
            }

            @Override
            public void addInformation(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
                tooltip.add(Lang.translate("Generates power from wind."));
                tooltip.add(Lang.translate("Power boosted by rain."));
                tooltip.add(Lang.translate("North/south blocks must be clear"));
                super.addInformation(stack, playerIn, tooltip, advanced);
            }
        }
        ,
        FIRE(IWorldPowerMultiplier.CONSTANT, new float[]{40.0f, 0.6666666f, 320.0f, 0.5f, 640.0f, 0.2f}){

            @Override
            public void registerAchievements() {
                AchievementHelper.addAchievement("Fire Mill", "Rising Heat!", this, BlockDecorativeSolid.DecorStates.stoneburnt);
            }

            @Override
            public float getPowerLevel(TilePassiveGenerator generator, World world) {
                IBlockState blockState = world.func_180495_p(generator.func_174877_v().func_177977_b());
                if (blockState.func_177230_c() != Blocks.field_150480_ab) {
                    return 0.0f;
                }
                return 4.0f;
            }

            @Override
            public float basePowerGen() {
                return 4.0f;
            }

            @Override
            public void createModel(BoxModel model, boolean isInv) {
                model.addBoxI(0, 0, 0, 16, 16, 1, "panel_base").setTextureSides(2, "panel_fire");
                model.addBoxI(0, 0, 15, 16, 16, 16, "panel_base").setTextureSides(3, "panel_fire");
                model.addBoxI(0, 0, 1, 1, 16, 15, "panel_base").setTextureSides(4, "panel_fire");
                model.addBoxI(15, 0, 1, 16, 16, 15, "panel_base").setTextureSides(5, "panel_fire");
                model.addBoxI(1, 8, 1, 15, 8, 15, "fan_spinning").setInvisible(false, false, true, true, true, true).setLayer(BlockRenderLayer.CUTOUT);
            }

            @Override
            public void addRecipe() {
                CraftingHelper.addShaped("mill_fire", this.newStack(1), true, "BRB", "BgB", "BNB", Character.valueOf('g'), ItemIngredients.Type.REDSTONE_GEAR.newStack(1), Character.valueOf('R'), ItemIngredients.Type.REDSTONE_CRYSTAL.newStack(1), Character.valueOf('B'), BlockDecorativeSolid.DecorStates.stoneburnt.newStack(1), Character.valueOf('N'), Blocks.field_150386_bk);
                PatternRecipe.register(new String[][]{{"n"}, {"f"}, {"g"}}, (Map<Character, Object>)ImmutableMap.builder().put((Object)Character.valueOf('n'), (Object)Blocks.field_150424_aL).put((Object)Character.valueOf('f'), (Object)Blocks.field_150480_ab).put((Object)Character.valueOf('g'), (Object)this.getMyBlockState()).put((Object)Character.valueOf('b'), (Object)Blocks.field_180401_cv).build(), new ItemStack[0]);
            }

            @Override
            public void addInformation(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
                tooltip.add(Lang.translate("Operates when placed over fire."));
                super.addInformation(stack, playerIn, tooltip, advanced);
            }
        }
        ,
        CREATIVE(IWorldPowerMultiplier.CONSTANT, new float[0]){

            @Override
            public void registerAchievements() {
            }

            @Override
            public float getPowerLevel(TilePassiveGenerator generator, World world) {
                return 10000.0f;
            }

            @Override
            @SideOnly(value=Side.CLIENT)
            public void addInformation(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
                tooltip.add(Lang.translate("Creative-only item."));
            }

            @Override
            public void createModel(BoxModel model, boolean isInv) {
                model.addBoxI(0, 0, 0, 16, 16, 16, "panel_creative").setTextureSides(0, "panel_creative_top", 1, "panel_creative_top");
            }

            @Override
            public void addRecipe() {
            }
        }
        ,
        PLAYER_WIND_UP(IWorldPowerMultiplier.CONSTANT, new float[0]){

            @Override
            public float getPowerLevel(TilePassiveGenerator generator, World world) {
                return 1.0f;
            }

            @Override
            public float basePowerGen() {
                return 15.0f;
            }

            @Override
            public void createModel(BoxModel model, boolean isInv) {
                model.addBoxI(0, 0, 0, 16, 6, 16, "panel_stone_side").setTextureSides(0, "panel_stone_base", 1, "panel_stone_base");
                if (isInv) {
                    model.addBoxI(6, 6, 6, 10, 10, 10, "redstone_gear");
                    model.addBoxI(2, 7, 7, 14, 9, 9, "redstone_gear");
                    model.addBoxI(7, 7, 2, 9, 9, 14, "redstone_gear");
                    model.addBoxI(1, 7, 1, 15, 9, 15, "redstone_gear").setInvisible(-4);
                    model.addBoxI(1, 6, 7, 15, 10, 9, "redstone_gear").setInvisible(-13);
                    model.addBoxI(7, 6, 1, 9, 10, 15, "redstone_gear").setInvisible(-49);
                } else {
                    model.addBoxI(1, 6, 1, 15, 10, 15, "redstone_gear").setInvisible(-1);
                }
            }

            @Override
            public void addRecipe() {
                CraftingHelper.addShaped("mill_manual", this.newStack(), " R ", "BCB", Character.valueOf('R'), ItemIngredients.Type.REDSTONE_GEAR, Character.valueOf('B'), BlockDecorativeSolid.DecorStates.stoneslab, Character.valueOf('C'), ItemIngredients.Type.REDSTONE_CRYSTAL);
            }

            @Override
            public void registerAchievements() {
                AchievementHelper.addAchievement("Manual Mill", "Hold right click to temporarily generate power.", this, ItemIngredients.Type.REDSTONE_CRYSTAL);
            }

            @Override
            public TilePassiveGenerator createTileEntity(World world) {
                return new TilePowerHandCrank();
            }
        }
        ,
        DRAGON_EGG(IWorldPowerMultiplier.CONSTANT, new float[]{500.0f, 0.5f, 1000.0f, 0.25f, 1500.0f, 0.05f}){

            @Override
            public float getPowerLevel(TilePassiveGenerator generator, World world) {
                IBlockState blockState = world.func_180495_p(generator.func_174877_v().func_177984_a());
                if (blockState.func_177230_c() != Blocks.field_150380_bt) {
                    return 0.0f;
                }
                return 500.0f;
            }

            @Override
            public float basePowerGen() {
                return 500.0f;
            }

            @Override
            public void createModel(BoxModel model, boolean isInv) {
                model.addBoxI(0, 0, 0, 16, 16, 16, "panel_egg_side").setTextureSides(0, "panel_egg", 1, "panel_egg");
            }

            @Override
            public void addRecipe() {
                CraftingHelper.addShaped("mill_dragon", this.newStack(1), true, "BEB", "NgN", "BRB", Character.valueOf('g'), ItemIngredients.Type.REDSTONE_GEAR.newStack(1), Character.valueOf('R'), ItemIngredients.Type.EYE_REDSTONE.newStack(1), Character.valueOf('B'), BlockDecorativeSolid.DecorStates.stoneburnt.newStack(1), Character.valueOf('N'), Items.field_151156_bN, Character.valueOf('E'), Items.field_151079_bi);
                PatternRecipe.register(new String[][]{{"g"}, {"d"}}, (Map<Character, Object>)ImmutableMap.builder().put((Object)Character.valueOf('d'), (Object)Blocks.field_150380_bt).put((Object)Character.valueOf('g'), (Object)this.getMyBlockState()).put((Object)Character.valueOf('b'), (Object)Blocks.field_180401_cv).build(), this.newStack());
            }

            @Override
            public void registerAchievements() {
            }
        };

        public final IWorldPowerMultiplier powerMultiplier;
        public final Collection<ResourceLocation> types;
        final ResourceLocation key;
        @Nullable
        private final TreeMap<Float, Pair<Float, Float>> caps;

        private GeneratorType(IWorldPowerMultiplier powerMultiplier, float ... capsInput) {
            this.powerMultiplier = powerMultiplier;
            this.key = new ResourceLocation("generators", this.name());
            this.types = ImmutableList.of((Object)new ResourceLocation("generators", "any"), (Object)this.key);
            float[][] caps = new float[capsInput.length / 2][2];
            for (int i = 0; i < capsInput.length; i += 2) {
                caps[i / 2][0] = capsInput[i];
                caps[i / 2][1] = capsInput[i + 1];
            }
            this.caps = IWorldPowerMultiplier.createCapsTree(caps);
        }

        @Override
        public ItemStack newStack(int i) {
            return XU2Entries.passiveGenerator.newStack(i, new Object[]{GENERATOR_TYPE, this});
        }

        public abstract float getPowerLevel(TilePassiveGenerator var1, World var2);

        public abstract void createModel(BoxModel var1, boolean var2);

        public boolean validPos(World worldIn, BlockPos pos) {
            return true;
        }

        public abstract void addRecipe();

        public IBlockState getMyBlockState() {
            return ((BlockPassiveGenerator)XU2Entries.passiveGenerator.value).func_176223_P().func_177226_a(GENERATOR_TYPE, (Comparable)((Object)this));
        }

        public float basePowerGen() {
            return 1.0f;
        }

        @SideOnly(value=Side.CLIENT)
        public void addInformation(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
            if (this.powerMultiplier != IWorldPowerMultiplier.CONSTANT) {
                tooltip.add(Lang.translateArgs("Base Power Given: %s GP", Float.valueOf(this.basePowerGen())));
                WorldClient theWorld = Minecraft.func_71410_x().field_71441_e;
                if (theWorld != null) {
                    tooltip.add(Lang.translateArgs("Cur Power Given: %s GP", StringHelper.niceFormat(this.basePowerGen() * this.powerMultiplier.multiplier((World)theWorld))));
                }
            } else {
                tooltip.add(Lang.translateArgs("Power Given: %s GP", Float.valueOf(this.basePowerGen())));
            }
            if (this.caps != null) {
                String reset = ChatFormatting.RESET.toString() + ChatFormatting.GRAY.toString();
                String tab = "   ";
                if (!Keyboard.isKeyDown((int)42) && !Keyboard.isKeyDown((int)54)) {
                    ChatFormatting col = ChatFormatting.DARK_GRAY;
                    tooltip.add(col + Lang.translate("Progressive Efficiency Loss:"));
                    tooltip.add(col.toString() + ChatFormatting.ITALIC + tab + Lang.translate("<Press Shift for more details>") + reset);
                } else {
                    ChatFormatting col = ChatFormatting.GRAY;
                    tooltip.add(col + Lang.translate("Progressive Efficiency Loss:") + reset);
                    for (Map.Entry<Float, Pair<Float, Float>> entry2 : this.caps.entrySet()) {
                        Float lower = entry2.getKey();
                        Float upper = this.caps.higherKey(lower);
                        String lowerFormat = StringHelper.format(lower.floatValue());
                        String efficiencyFormat = StringHelper.formatPercent(1.0f - ((Float)entry2.getValue().getValue()).floatValue());
                        if (upper == null) {
                            tooltip.add(col + tab + Lang.translateArgs("Above %s GP: %s", lowerFormat, efficiencyFormat) + reset);
                            continue;
                        }
                        tooltip.add(col + tab + Lang.translateArgs("%s GP to %s GP: %s", lowerFormat, StringHelper.format(upper.floatValue()), efficiencyFormat) + reset);
                    }
                }
            }
        }

        @Override
        public ItemStack newStack() {
            return this.newStack(1);
        }

        public abstract void registerAchievements();

        public TilePassiveGenerator createTileEntity(World world) {
            return new TilePassiveGenerator();
        }

        @Override
        public float multiplier(World world) {
            return this.powerMultiplier.multiplier(world);
        }

        @Override
        public IWorldPowerMultiplier getStaticVariation() {
            return this;
        }

        @Override
        public float alterTotal(float value) {
            return IWorldPowerMultiplier.capPower(value, this.caps);
        }

        @Override
        public boolean hasInefficiencies() {
            return true;
        }
    }
}

