/*
 * Decompiled with CFR 0.152.
 */
package codechicken.wirelessredstone.part;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.raytracer.CuboidRayTraceResult;
import codechicken.lib.vec.Vector3;
import codechicken.wirelessredstone.WirelessRedstone;
import codechicken.wirelessredstone.api.ITileWireless;
import codechicken.wirelessredstone.client.render.RenderWireless;
import codechicken.wirelessredstone.manager.RedstoneEther;
import codechicken.wirelessredstone.part.WirelessPart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class TransceiverPart
extends WirelessPart
implements ITileWireless {
    public byte deadmap;
    public int currentfreq;

    @Override
    public int getFreq() {
        return this.currentfreq;
    }

    @Override
    public void setFreq(int newfreq) {
        this.removeFromEther();
        this.currentfreq = newfreq;
        this.addToEther();
        if (this.disabled()) {
            RedstoneEther.server().jamNode(this.world(), this.pos(), newfreq);
        }
        this.updateChange();
    }

    @Override
    public void load(NBTTagCompound tag) {
        super.load(tag);
        this.currentfreq = tag.func_74762_e("freq");
        this.deadmap = tag.func_74771_c("deadmap");
    }

    @Override
    public void save(NBTTagCompound tag) {
        super.save(tag);
        tag.func_74768_a("freq", this.currentfreq);
        tag.func_74774_a("deadmap", this.deadmap);
    }

    @Override
    public void writeDesc(MCDataOutput packet) {
        super.writeDesc(packet);
        packet.writeShort(this.currentfreq);
    }

    @Override
    public void readDesc(MCDataInput packet) {
        super.readDesc(packet);
        this.currentfreq = packet.readUShort();
    }

    @Override
    public void jamTile() {
        this.setDisabled(true);
        this.deadmap = (byte)this.world().field_73012_v.nextInt(256);
        this.scheduleTick(3);
    }

    @Override
    public void unjamTile() {
        if (this.disabled()) {
            this.deadmap = (byte)this.world().field_73012_v.nextInt(256);
            this.scheduleTick(3);
        }
        this.setDisabled(false);
    }

    public void scheduledTick() {
        if (this.deadmap != 0) {
            this.deadmap = (byte)((this.deadmap & 0xFF) >> 1);
            if (this.deadmap != 0) {
                this.scheduleTick(3);
            }
            this.updateChange();
        }
    }

    @Override
    public boolean activate(EntityPlayer player, CuboidRayTraceResult hit, ItemStack held, EnumHand hand) {
        if (super.activate(player, hit, held, hand)) {
            return true;
        }
        if (hit.field_178784_b.ordinal() == (this.side() ^ 1) && !player.func_70093_af()) {
            if (this.world().field_72995_K) {
                WirelessRedstone.proxy.openTileWirelessGui(player, (ITileWireless)this.tile());
            }
            return true;
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderDynamic(Vector3 pos, int pass, float frame) {
        super.renderDynamic(pos, pass, frame);
        if (pass == 0) {
            RenderWireless.renderFreq(pos, this);
        }
    }
}

