/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.spatial;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.YesNo;
import appeng.api.implementations.TransitionResult;
import appeng.api.implementations.items.ISpatialStorageCell;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGrid;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.events.MENetworkEvent;
import appeng.api.networking.events.MENetworkSpatialEvent;
import appeng.api.networking.spatial.ISpatialCache;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import appeng.api.util.DimensionalCoord;
import appeng.hooks.TickHandler;
import appeng.me.cache.SpatialPylonCache;
import appeng.tile.grid.AENetworkInvTile;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.util.IWorldCallable;
import appeng.util.Platform;
import appeng.util.inv.InvOperation;
import appeng.util.inv.WrapperFilteredItemHandler;
import appeng.util.inv.filter.IAEItemFilter;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;

public class TileSpatialIOPort
extends AENetworkInvTile
implements IWorldCallable<Void> {
    private final AppEngInternalInventory inv = new AppEngInternalInventory(this, 2);
    private final IItemHandler invExt = new WrapperFilteredItemHandler((IItemHandler)this.inv, new SpatialIOFilter());
    private YesNo lastRedstoneState = YesNo.UNDECIDED;

    public TileSpatialIOPort() {
        this.getProxy().setFlags(GridFlags.REQUIRE_CHANNEL);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound data) {
        super.func_189515_b(data);
        data.func_74768_a("lastRedstoneState", this.lastRedstoneState.ordinal());
        return data;
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        if (data.func_74764_b("lastRedstoneState")) {
            this.lastRedstoneState = YesNo.values()[data.func_74762_e("lastRedstoneState")];
        }
    }

    public boolean getRedstoneState() {
        if (this.lastRedstoneState == YesNo.UNDECIDED) {
            this.updateRedstoneState();
        }
        return this.lastRedstoneState == YesNo.YES;
    }

    public void updateRedstoneState() {
        YesNo currentState;
        YesNo yesNo = currentState = this.field_145850_b.func_175687_A(this.field_174879_c) != 0 ? YesNo.YES : YesNo.NO;
        if (this.lastRedstoneState != currentState) {
            this.lastRedstoneState = currentState;
            if (this.lastRedstoneState == YesNo.YES) {
                this.triggerTransition();
            }
        }
    }

    private void triggerTransition() {
        ItemStack cell;
        if (Platform.isServer() && this.isSpatialCell(cell = this.inv.getStackInSlot(0))) {
            TickHandler.INSTANCE.addCallable(null, this);
        }
    }

    private boolean isSpatialCell(ItemStack cell) {
        if (!cell.func_190926_b() && cell.func_77973_b() instanceof ISpatialStorageCell) {
            ISpatialStorageCell sc = (ISpatialStorageCell)cell.func_77973_b();
            return sc != null && sc.isSpatialStorage(cell);
        }
        return false;
    }

    @Override
    public Void call(World world) throws Exception {
        ItemStack cell = this.inv.getStackInSlot(0);
        if (this.isSpatialCell(cell) && this.inv.getStackInSlot(1).func_190926_b()) {
            MENetworkEvent res;
            double req;
            double pr;
            IGrid gi = this.getProxy().getGrid();
            IEnergyGrid energy = this.getProxy().getEnergy();
            ISpatialStorageCell sc = (ISpatialStorageCell)cell.func_77973_b();
            SpatialPylonCache spc = (SpatialPylonCache)gi.getCache(ISpatialCache.class);
            if (spc.hasRegion() && spc.isValidRegion() && Math.abs((pr = energy.extractAEPower(req = (double)spc.requiredPower(), Actionable.SIMULATE, PowerMultiplier.CONFIG)) - req) < req * 0.001 && !(res = gi.postEvent(new MENetworkSpatialEvent(this, req))).isCanceled()) {
                int playerId = -1;
                if (this.getProxy().getSecurity().isAvailable()) {
                    playerId = this.getProxy().getSecurity().getOwner();
                }
                TransitionResult tr = sc.doSpatialTransition(cell, this.field_145850_b, spc.getMin(), spc.getMax(), playerId);
                if (tr.success) {
                    energy.extractAEPower(req, Actionable.MODULATE, PowerMultiplier.CONFIG);
                    this.inv.setStackInSlot(0, ItemStack.field_190927_a);
                    this.inv.setStackInSlot(1, cell);
                }
            }
        }
        return null;
    }

    @Override
    public AECableType getCableConnectionType(AEPartLocation dir) {
        return AECableType.SMART;
    }

    @Override
    public DimensionalCoord getLocation() {
        return new DimensionalCoord(this);
    }

    @Override
    @Nonnull
    protected IItemHandler getItemHandlerForSide(@Nonnull EnumFacing side) {
        return this.invExt;
    }

    @Override
    public IItemHandler getInternalInventory() {
        return this.inv;
    }

    @Override
    public void onChangeInventory(IItemHandler inv, int slot, InvOperation mc, ItemStack removed, ItemStack added) {
    }

    private class SpatialIOFilter
    implements IAEItemFilter {
        private SpatialIOFilter() {
        }

        @Override
        public boolean allowExtract(IItemHandler inv, int slot, int amount) {
            return slot == 1;
        }

        @Override
        public boolean allowInsert(IItemHandler inv, int slot, ItemStack stack) {
            return slot == 0 && TileSpatialIOPort.this.isSpatialCell(stack);
        }
    }
}

