/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync;

import appeng.core.sync.AppEngPacket;
import appeng.core.sync.packets.PacketAssemblerAnimation;
import appeng.core.sync.packets.PacketClick;
import appeng.core.sync.packets.PacketCompassRequest;
import appeng.core.sync.packets.PacketCompassResponse;
import appeng.core.sync.packets.PacketCompressedNBT;
import appeng.core.sync.packets.PacketConfigButton;
import appeng.core.sync.packets.PacketCraftRequest;
import appeng.core.sync.packets.PacketFluidSlot;
import appeng.core.sync.packets.PacketInventoryAction;
import appeng.core.sync.packets.PacketJEIRecipe;
import appeng.core.sync.packets.PacketLightning;
import appeng.core.sync.packets.PacketMEFluidInventoryUpdate;
import appeng.core.sync.packets.PacketMEInventoryUpdate;
import appeng.core.sync.packets.PacketMatterCannon;
import appeng.core.sync.packets.PacketMockExplosion;
import appeng.core.sync.packets.PacketPaintedEntity;
import appeng.core.sync.packets.PacketPartPlacement;
import appeng.core.sync.packets.PacketPatternSlot;
import appeng.core.sync.packets.PacketProgressBar;
import appeng.core.sync.packets.PacketSwapSlots;
import appeng.core.sync.packets.PacketSwitchGuis;
import appeng.core.sync.packets.PacketTargetFluidStack;
import appeng.core.sync.packets.PacketTargetItemStack;
import appeng.core.sync.packets.PacketTransitionEffect;
import appeng.core.sync.packets.PacketValueConfig;
import io.netty.buffer.ByteBuf;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;

public class AppEngPacketHandlerBase {
    private static final Map<Class<? extends AppEngPacket>, PacketTypes> REVERSE_LOOKUP = new HashMap<Class<? extends AppEngPacket>, PacketTypes>();

    public static enum PacketTypes {
        PACKET_COMPASS_REQUEST(PacketCompassRequest.class),
        PACKET_COMPASS_RESPONSE(PacketCompassResponse.class),
        PACKET_INVENTORY_ACTION(PacketInventoryAction.class),
        PACKET_ME_INVENTORY_UPDATE(PacketMEInventoryUpdate.class),
        PACKET_ME_FLUID_INVENTORY_UPDATE(PacketMEFluidInventoryUpdate.class),
        PACKET_CONFIG_BUTTON(PacketConfigButton.class),
        PACKET_PART_PLACEMENT(PacketPartPlacement.class),
        PACKET_LIGHTNING(PacketLightning.class),
        PACKET_MATTER_CANNON(PacketMatterCannon.class),
        PACKET_MOCK_EXPLOSION(PacketMockExplosion.class),
        PACKET_VALUE_CONFIG(PacketValueConfig.class),
        PACKET_TRANSITION_EFFECT(PacketTransitionEffect.class),
        PACKET_PROGRESS_VALUE(PacketProgressBar.class),
        PACKET_CLICK(PacketClick.class),
        PACKET_SWITCH_GUIS(PacketSwitchGuis.class),
        PACKET_SWAP_SLOTS(PacketSwapSlots.class),
        PACKET_PATTERN_SLOT(PacketPatternSlot.class),
        PACKET_RECIPE_JEI(PacketJEIRecipe.class),
        PACKET_TARGET_ITEM(PacketTargetItemStack.class),
        PACKET_TARGET_FLUID(PacketTargetFluidStack.class),
        PACKET_CRAFTING_REQUEST(PacketCraftRequest.class),
        PACKET_ASSEMBLER_ANIMATION(PacketAssemblerAnimation.class),
        PACKET_COMPRESSED_NBT(PacketCompressedNBT.class),
        PACKET_PAINTED_ENTITY(PacketPaintedEntity.class),
        PACKET_FLUID_TANK(PacketFluidSlot.class);

        private final Class<? extends AppEngPacket> packetClass;
        private final Constructor<? extends AppEngPacket> packetConstructor;

        private PacketTypes(Class<? extends AppEngPacket> c) {
            this.packetClass = c;
            Constructor<? extends AppEngPacket> x = null;
            try {
                x = this.packetClass.getConstructor(ByteBuf.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            this.packetConstructor = x;
            REVERSE_LOOKUP.put(this.packetClass, this);
            if (this.packetConstructor == null) {
                throw new IllegalStateException("Invalid Packet Class " + c + ", must be constructable on DataInputStream");
            }
        }

        public static PacketTypes getPacket(int id) {
            return PacketTypes.values()[id];
        }

        static PacketTypes getID(Class<? extends AppEngPacket> c) {
            return (PacketTypes)((Object)REVERSE_LOOKUP.get(c));
        }

        public AppEngPacket parsePacket(ByteBuf in) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            return this.packetConstructor.newInstance(in);
        }
    }
}

