/*
 * Decompiled with CFR 0.152.
 */
package openmods.sync;

import com.google.common.base.Preconditions;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import openmods.sync.SyncableObjectBase;
import openmods.utils.ByteUtils;
import openmods.utils.bitmap.IBitMap;
import openmods.utils.bitmap.IRpcIntBitMap;

public abstract class SyncableFlags
extends SyncableObjectBase
implements IRpcIntBitMap,
IBitMap<Integer> {
    protected int value;
    private int previousValue;

    public static SyncableFlags create(int bitCount) {
        Preconditions.checkArgument((bitCount > 0 ? 1 : 0) != 0, (Object)"Bit count must be positive");
        if (bitCount <= 8) {
            return new ByteFlags();
        }
        if (bitCount <= 16) {
            return new ShortFlags();
        }
        if (bitCount <= 32) {
            return new IntFlags();
        }
        throw new IllegalArgumentException("Too many bits. Split some fields or implement LongFlags or BigIntFlags");
    }

    protected SyncableFlags() {
    }

    public void on(Enum<?> slot) {
        this.on(slot.ordinal());
    }

    public void on(int slot) {
        this.set(slot, true);
    }

    @Override
    public void mark(Integer value) {
        this.on(value);
    }

    public void off(Enum<?> slot) {
        this.off(slot.ordinal());
    }

    public void off(int slot) {
        this.set(slot, false);
    }

    @Override
    public void clear(Integer value) {
        this.off(value);
    }

    @Override
    public void set(Enum<?> slot, boolean bool) {
        this.set(slot.ordinal(), bool);
    }

    @Override
    public void toggle(int slot) {
        this.set(this.value ^ 1 << slot);
    }

    @Override
    public void toggle(Integer value) {
        this.toggle((int)value);
    }

    @Override
    public void toggle(Enum<?> slot) {
        this.toggle(slot.ordinal());
    }

    private void set(int value) {
        if (value != this.value) {
            this.markDirty();
            this.value = (short)value;
        }
    }

    @Override
    public void set(int slot, boolean bool) {
        short newVal = (short)ByteUtils.set(this.value, slot, bool);
        if (newVal != this.value) {
            this.markDirty();
            this.value = newVal;
        }
    }

    @Override
    public void set(Integer slot, boolean bool) {
        this.set((int)slot, bool);
    }

    @Override
    public boolean get(Enum<?> slot) {
        return this.get(slot.ordinal());
    }

    @Override
    public boolean get(int slot) {
        return ByteUtils.get(this.value, slot);
    }

    @Override
    public boolean get(Integer value) {
        return this.get((int)value);
    }

    public boolean hasSlotChanged(Enum<?> slot) {
        return this.hasSlotChanged(slot.ordinal());
    }

    public boolean hasSlotChanged(int slot) {
        int mask = 1 << slot;
        return (this.value & mask) == (this.previousValue & mask);
    }

    @Override
    public void markClean() {
        this.previousValue = this.value;
        this.dirty = false;
    }

    @Override
    public void clearAll() {
        this.value = 0;
        this.markDirty();
    }

    public static class IntFlags
    extends SyncableFlags {
        @Override
        public void readFromStream(PacketBuffer stream) {
            this.value = stream.readInt();
        }

        @Override
        public void writeToStream(PacketBuffer stream) {
            stream.writeInt(this.value);
        }

        @Override
        public void writeToNBT(NBTTagCompound tag, String name) {
            tag.func_74768_a(name, this.value);
        }

        @Override
        public void readFromNBT(NBTTagCompound tag, String name) {
            this.value = tag.func_74762_e(name);
        }
    }

    public static class ShortFlags
    extends SyncableFlags {
        @Override
        public void readFromStream(PacketBuffer stream) {
            this.value = stream.readShort();
        }

        @Override
        public void writeToStream(PacketBuffer stream) {
            stream.writeShort(this.value);
        }

        @Override
        public void writeToNBT(NBTTagCompound tag, String name) {
            tag.func_74777_a(name, (short)this.value);
        }

        @Override
        public void readFromNBT(NBTTagCompound tag, String name) {
            this.value = tag.func_74765_d(name);
        }
    }

    public static class ByteFlags
    extends SyncableFlags {
        @Override
        public void readFromStream(PacketBuffer stream) {
            this.value = stream.readByte();
        }

        @Override
        public void writeToStream(PacketBuffer stream) {
            stream.writeByte(this.value);
        }

        @Override
        public void writeToNBT(NBTTagCompound tag, String name) {
            tag.func_74774_a(name, (byte)this.value);
        }

        @Override
        public void readFromNBT(NBTTagCompound tag, String name) {
            this.value = tag.func_74771_c(name);
        }
    }
}

