/*
 * Decompiled with CFR 0.152.
 */
package openmods.config.game;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.datafix.DataFixer;
import net.minecraftforge.common.util.CompoundDataFixer;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import openmods.Log;
import openmods.OpenMods;
import openmods.config.BlockInstances;
import openmods.config.InstanceContainer;
import openmods.config.ItemInstances;
import openmods.config.game.AbstractFeatureManager;
import openmods.config.game.FactoryRegistry;
import openmods.config.game.ICustomItemModelProvider;
import openmods.config.game.IRegisterableBlock;
import openmods.config.game.IgnoreFeature;
import openmods.config.game.RegisterBlock;
import openmods.config.game.RegisterItem;
import openmods.fixers.IFixerFactory;
import openmods.fixers.RegisterFixer;
import openmods.utils.CachedInstanceFactory;

public class GameRegistryObjectsProvider {
    private static final AbstractFeatureManager NULL_FEATURE_MANAGER = new AbstractFeatureManager(){

        @Override
        public boolean isEnabled(String category, String name) {
            return true;
        }

        @Override
        public Set<String> getCategories() {
            return ImmutableSet.of();
        }

        @Override
        public Set<String> getFeaturesInCategory(String category) {
            return ImmutableSet.of();
        }
    };
    private AbstractFeatureManager features = NULL_FEATURE_MANAGER;
    private boolean remapFromLegacy = true;
    private final FactoryRegistry<Block> blockFactory = new FactoryRegistry();
    private final FactoryRegistry<Item> itemFactory = new FactoryRegistry();
    private final Map<ResourceLocation, Item> itemRemaps = Maps.newHashMap();
    private final Map<ResourceLocation, Block> blockRemaps = Maps.newHashMap();
    private final Map<Item, ResourceLocation> itemModelIds = Maps.newHashMap();
    private Supplier<CreativeTabs> creativeTabSupplier;
    private CreativeTabs creativeTab;
    private final IdDecorator langDecorator = new IdDecorator(".");
    private final ResourceLocationBuilder itemModelDecorator = new ResourceLocationBuilder();
    private final IdDecorator legacyItemDecorator = new IdDecorator(".");
    private final IdDecorator legacyBlockDecorator = new IdDecorator("_");
    private final String modId;
    private final Set<String> legacyModIds = Sets.newHashSet();
    private final ModContainer modContainer;
    private static Class<?>[] ITEM_BLOCK_CTOR_ARGS = new Class[]{Block.class};

    private CreativeTabs creativeTab() {
        if (this.creativeTab == null && this.creativeTabSupplier != null) {
            this.creativeTab = this.creativeTabSupplier.get();
            Preconditions.checkNotNull((Object)this.creativeTab);
        }
        return this.creativeTab;
    }

    public GameRegistryObjectsProvider(String modPrefix) {
        this.langDecorator.setMod(modPrefix);
        this.itemModelDecorator.setMod(modPrefix);
        this.legacyBlockDecorator.setMod(modPrefix);
        this.legacyItemDecorator.setMod(modPrefix);
        this.modContainer = Loader.instance().activeModContainer();
        Preconditions.checkNotNull((Object)this.modContainer, (Object)"This class can only be initialized in mod init");
        this.modId = this.modContainer.getModId();
    }

    public void setCreativeTab(Supplier<CreativeTabs> creativeTab) {
        this.creativeTabSupplier = creativeTab;
    }

    public void setCreativeTab(CreativeTabs creativeTab) {
        this.creativeTab = creativeTab;
    }

    public void setLanguageModId(String modId) {
        this.langDecorator.setMod(modId);
    }

    public void setItemModelId(String modId) {
        this.itemModelDecorator.setMod(modId);
    }

    public void setFeatures(AbstractFeatureManager features) {
        this.features = features;
    }

    public void setRemapFromLegacy(boolean remapFromLegacy) {
        this.remapFromLegacy = remapFromLegacy;
    }

    public void addModIdToRemap(String legacyModId) {
        Preconditions.checkArgument((!legacyModId.equals(this.modId) ? 1 : 0) != 0);
        this.legacyModIds.add(legacyModId);
    }

    public FactoryRegistry<Block> getBlockFactory() {
        return this.blockFactory;
    }

    public FactoryRegistry<Item> getItemFactory() {
        return this.itemFactory;
    }

    private static <I, A extends Annotation> void processAnnotations(Class<? extends InstanceContainer<?>> config, Class<I> baseClass, Class<A> annotationClass, FactoryRegistry<I> factory, IAnnotationAccess<A, I> annotationAccess, IObjectVisitor<I, A> visitor) {
        for (Field f : config.getFields()) {
            A annotation;
            if (f.isAnnotationPresent(IgnoreFeature.class) || (annotation = f.getAnnotation(annotationClass)) == null) continue;
            Preconditions.checkState((boolean)Modifier.isStatic(f.getModifiers()), (String)"Field %s marked with %s must be static", (Object)f, annotationClass);
            Class<I> fieldType = GameRegistryObjectsProvider.getFieldType(f, baseClass);
            Class<I> targetCls = annotationAccess.getObjectType(annotation);
            if (targetCls == baseClass) {
                targetCls = fieldType;
            }
            Preconditions.checkState((targetCls != baseClass ? 1 : 0) != 0, (String)"Invalid field %s type - got base class", (Object)f);
            String name = annotationAccess.getEntryId(annotation);
            if (!annotationAccess.isEnabled(name)) {
                Log.info("Object %s (from field %s) is disabled", name, f);
                continue;
            }
            I entry = factory.construct(name, targetCls);
            if (entry == null) continue;
            try {
                f.set(null, entry);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            visitor.visit(entry, annotation);
        }
    }

    private static <I> Class<? extends I> getFieldType(Field field, Class<I> baseClass) {
        Class<?> type = field.getType();
        Preconditions.checkState((boolean)baseClass.isAssignableFrom(type), (String)"Field %s must have type assignable to %s", (Object)field, baseClass);
        return type;
    }

    private static void setPrefixedId(String id, String objectName, IdDecorator decorator, IdSetter setter, String noneValue, String defaultValue) {
        if (!id.equals("[none]")) {
            id = id.equals("[default]") ? decorator.decorate(objectName) : decorator.decorate(id);
            setter.setId(id);
        }
    }

    private static void setItemPrefixedId(String id, String itemName, IdDecorator decorator, IdSetter setter) {
        GameRegistryObjectsProvider.setPrefixedId(id, itemName, decorator, setter, "[none]", "[default]");
    }

    private <E> void registerRemaps(Map<ResourceLocation, E> output, E object, String currentName, Iterable<String> legacyObjectNames, Iterable<String> legacyModIds) {
        for (String legacyName : legacyObjectNames) {
            output.put(new ResourceLocation(this.modId, legacyName), object);
        }
        for (String legacyModId : legacyModIds) {
            output.put(new ResourceLocation(legacyModId, currentName), object);
            for (String legacyName : legacyObjectNames) {
                output.put(new ResourceLocation(legacyModId, legacyName), object);
            }
        }
    }

    public void registerItems(Class<? extends ItemInstances> klazz, IForgeRegistry<Item> items) {
        GameRegistryObjectsProvider.processAnnotations(klazz, Item.class, RegisterItem.class, this.itemFactory, new IAnnotationAccess<RegisterItem, Item>(){

            @Override
            public String getEntryId(RegisterItem annotation) {
                return annotation.id();
            }

            @Override
            public Class<? extends Item> getObjectType(RegisterItem annotation) {
                return annotation.type();
            }

            @Override
            public boolean isEnabled(String id) {
                return GameRegistryObjectsProvider.this.features.isItemEnabled(id);
            }
        }, (item, annotation) -> {
            String selectedId;
            String id = annotation.id();
            HashSet legacyIds = Sets.newHashSet((Object[])annotation.legacyIds());
            String legacyPrefixedId = this.legacyItemDecorator.decorate(id);
            if (this.remapFromLegacy) {
                selectedId = id;
                legacyIds.add(legacyPrefixedId);
            } else {
                selectedId = legacyPrefixedId;
            }
            items.register(item.setRegistryName(new ResourceLocation(this.modId, selectedId)));
            this.registerRemaps(this.itemRemaps, item, selectedId, legacyIds, this.legacyModIds);
            GameRegistryObjectsProvider.setItemPrefixedId(annotation.unlocalizedName(), id, this.langDecorator, arg_0 -> ((Item)item).func_77655_b(arg_0));
            ResourceLocation itemLocation = this.itemModelDecorator.build(id);
            if (annotation.registerDefaultModel()) {
                this.itemModelIds.put((Item)item, itemLocation);
            }
            if (annotation.customItemModels() != ICustomItemModelProvider.class) {
                GameRegistryObjectsProvider.registerCustomItemModels(item, itemLocation, annotation.customItemModels());
            }
            if (annotation.addToModCreativeTab()) {
                item.func_77637_a(this.creativeTab());
            }
        });
    }

    private static void registerCustomItemModels(Item item, ResourceLocation itemLocation, Class<? extends ICustomItemModelProvider> providerCls) {
        OpenMods.proxy.runCustomItemModelProvider(itemLocation, item, providerCls);
    }

    private static void setBlockPrefixedId(String id, String blockName, IdDecorator decorator, IdSetter setter) {
        GameRegistryObjectsProvider.setPrefixedId(id, blockName, decorator, setter, "[none]", "[default]");
    }

    private static ItemBlock initializeItemBlock(Class<? extends ItemBlock> cls, Block block) {
        try {
            Constructor<? extends ItemBlock> itemBlockCtor = cls.getConstructor(ITEM_BLOCK_CTOR_ARGS);
            return itemBlockCtor.newInstance(block);
        }
        catch (Exception e) {
            Log.warn("Failed to initialize block item for %s, class %s", block, cls);
            return null;
        }
    }

    public void registerBlocks(Class<? extends BlockInstances> klazz, final IForgeRegistry<Block> blocks, final IForgeRegistry<Item> items) {
        final CachedInstanceFactory fixerFactories = CachedInstanceFactory.create();
        CompoundDataFixer fixerRegistry = FMLCommonHandler.instance().getDataFixer();
        GameRegistryObjectsProvider.processAnnotations(klazz, Block.class, RegisterBlock.class, this.blockFactory, new IAnnotationAccess<RegisterBlock, Block>(){

            @Override
            public String getEntryId(RegisterBlock annotation) {
                return annotation.id();
            }

            @Override
            public Class<? extends Block> getObjectType(RegisterBlock annotation) {
                return annotation.type();
            }

            @Override
            public boolean isEnabled(String id) {
                return GameRegistryObjectsProvider.this.features.isBlockEnabled(id);
            }
        }, new IObjectVisitor<Block, RegisterBlock>((DataFixer)fixerRegistry){
            final /* synthetic */ DataFixer val$fixerRegistry;
            {
                this.val$fixerRegistry = dataFixer;
            }

            @Override
            public void visit(Block block, RegisterBlock annotation) {
                ItemBlock itemBlock;
                String selectedId;
                String id = annotation.id();
                Class<? extends ItemBlock> itemBlockClass = annotation.itemBlock();
                Class<? extends TileEntity> teClass = annotation.tileEntity();
                if (teClass == TileEntity.class) {
                    teClass = null;
                }
                HashSet legacyIds = Sets.newHashSet((Object[])annotation.legacyIds());
                String legacyPrefixedId = GameRegistryObjectsProvider.this.legacyItemDecorator.decorate(id);
                if (GameRegistryObjectsProvider.this.remapFromLegacy) {
                    selectedId = id;
                    legacyIds.add(legacyPrefixedId);
                } else {
                    selectedId = legacyPrefixedId;
                }
                blocks.register(block.setRegistryName(new ResourceLocation(GameRegistryObjectsProvider.this.modId, selectedId)));
                GameRegistryObjectsProvider.this.registerRemaps(GameRegistryObjectsProvider.this.blockRemaps, block, selectedId, legacyIds, GameRegistryObjectsProvider.this.legacyModIds);
                if (annotation.registerItemBlock()) {
                    itemBlock = GameRegistryObjectsProvider.initializeItemBlock(itemBlockClass, block);
                    if (itemBlock != null) {
                        items.register(itemBlock.setRegistryName(new ResourceLocation(GameRegistryObjectsProvider.this.modId, selectedId)));
                        GameRegistryObjectsProvider.this.registerRemaps(GameRegistryObjectsProvider.this.itemRemaps, itemBlock, selectedId, legacyIds, GameRegistryObjectsProvider.this.legacyModIds);
                    }
                } else {
                    itemBlock = null;
                }
                GameRegistryObjectsProvider.setBlockPrefixedId(annotation.unlocalizedName(), id, GameRegistryObjectsProvider.this.langDecorator, arg_0 -> ((Block)block).func_149663_c(arg_0));
                if (teClass != null) {
                    GameRegistry.registerTileEntity(teClass, (ResourceLocation)new ResourceLocation(GameRegistryObjectsProvider.this.modId, id));
                    this.registerFixer(teClass);
                }
                if (block instanceof IRegisterableBlock) {
                    ((IRegisterableBlock)block).setupBlock(GameRegistryObjectsProvider.this.modContainer, id, teClass, itemBlock);
                }
                for (RegisterBlock.RegisterTileEntity te : annotation.tileEntities()) {
                    GameRegistry.registerTileEntity(te.cls(), (ResourceLocation)new ResourceLocation(GameRegistryObjectsProvider.this.modId, te.name()));
                    this.registerFixer(te.cls());
                }
                if (annotation.addToModCreativeTab()) {
                    block.func_149647_a(GameRegistryObjectsProvider.this.creativeTab());
                }
                if (itemBlock != null) {
                    ResourceLocation itemLocation = GameRegistryObjectsProvider.this.itemModelDecorator.build(id);
                    if (annotation.customItemModels() != ICustomItemModelProvider.class) {
                        GameRegistryObjectsProvider.registerCustomItemModels((Item)itemBlock, itemLocation, annotation.customItemModels());
                    }
                    if (annotation.registerDefaultItemModel()) {
                        GameRegistryObjectsProvider.this.itemModelIds.put(itemBlock, itemLocation);
                    }
                }
            }

            private void registerFixer(Class<? extends TileEntity> teClass) {
                RegisterFixer fixer = teClass.getAnnotation(RegisterFixer.class);
                if (fixer != null) {
                    IFixerFactory fixerFactory = (IFixerFactory)fixerFactories.getOrCreate(fixer.value());
                    fixerFactory.register(this.val$fixerRegistry, teClass);
                }
            }
        });
    }

    public boolean hasIntraModRenames() {
        return !this.legacyModIds.isEmpty();
    }

    public void handleBlockRemaps(Collection<RegistryEvent.MissingMappings.Mapping<Block>> mappings) {
        for (RegistryEvent.MissingMappings.Mapping<Block> mapping : mappings) {
            Block remap = this.blockRemaps.get(mapping.key);
            if (remap == null) continue;
            mapping.remap((IForgeRegistryEntry)remap);
        }
    }

    public void handleItemRemaps(Collection<RegistryEvent.MissingMappings.Mapping<Item>> mappings) {
        for (RegistryEvent.MissingMappings.Mapping<Item> mapping : mappings) {
            Item remap = this.itemRemaps.get(mapping.key);
            if (remap == null) continue;
            mapping.remap((IForgeRegistryEntry)remap);
        }
    }

    public void registerItemModels() {
        for (Map.Entry<Item, ResourceLocation> modelId : this.itemModelIds.entrySet()) {
            OpenMods.proxy.bindItemModelToItemMeta(modelId.getKey(), 0, modelId.getValue());
        }
    }

    @FunctionalInterface
    private static interface IdSetter {
        public void setId(String var1);
    }

    private static class ResourceLocationBuilder {
        private String modId;

        private ResourceLocationBuilder() {
        }

        public void setMod(String modId) {
            this.modId = modId;
        }

        public ResourceLocation build(String id) {
            return new ResourceLocation(this.modId, id);
        }
    }

    private static class IdDecorator {
        private String modId;
        private final String joiner;

        public IdDecorator(String joiner) {
            this.joiner = joiner;
        }

        public void setMod(String modId) {
            this.modId = modId;
        }

        public String decorate(String id) {
            return this.modId + this.joiner + id;
        }
    }

    @FunctionalInterface
    private static interface IObjectVisitor<I, A extends Annotation> {
        public void visit(I var1, A var2);
    }

    private static interface IAnnotationAccess<A extends Annotation, I> {
        public String getEntryId(A var1);

        public Class<? extends I> getObjectType(A var1);

        public boolean isEnabled(String var1);
    }
}

