/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.tileentity;

import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import openblocks.common.tileentity.TileEntityGuide;
import openblocks.rpc.IGuideAnimationTrigger;
import openmods.utils.render.GeometryUtils;

public class TileEntityBuilderGuide
extends TileEntityGuide
implements IGuideAnimationTrigger {
    private static final Random RANDOM = new Random();
    private int ticks;

    @Override
    public boolean shouldRenderInPass(int pass) {
        return pass == 0 || pass == 1 && this.shouldRender();
    }

    @Override
    public boolean onItemUse(EntityPlayerMP player, @Nonnull ItemStack heldStack, EnumFacing side, float hitX, float hitY, float hitZ) {
        Item heldItem;
        if (this.active.get() && (heldItem = heldStack.func_77973_b()) instanceof ItemBlock) {
            ItemBlock itemBlock = (ItemBlock)heldItem;
            Block block = itemBlock.func_179223_d();
            int blockMeta = itemBlock.func_77647_b(heldStack.func_77952_i());
            if (player.field_71075_bZ.field_75098_d && this.isInFillMode()) {
                this.creativeReplaceBlocks(player, heldStack, block, blockMeta, side, hitX, hitY, hitZ);
                return true;
            }
            return this.survivalPlaceBlocks(player, heldStack, block, blockMeta, side, hitX, hitY, hitZ);
        }
        return super.onItemUse(player, heldStack, side, hitX, hitY, hitZ);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            ++this.ticks;
        }
    }

    private void creativeReplaceBlocks(EntityPlayerMP player, ItemStack heldStack, Block block, int blockMeta, EnumFacing side, float hitX, float hitY, float hitZ) {
        for (BlockPos coord : this.getShapeSafe().getCoords()) {
            BlockPos clickPos = this.field_174879_c.func_177971_a((Vec3i)coord);
            IBlockState state = block.getStateForPlacement(this.field_145850_b, clickPos, side, hitX, hitY, hitZ, blockMeta, (EntityLivingBase)player, EnumHand.MAIN_HAND);
            this.field_145850_b.func_175656_a(clickPos, state);
        }
    }

    @Override
    protected boolean canAddCoord(int x, int y, int z) {
        return Math.abs(x) > 1 || Math.abs(y) > 1 || Math.abs(z) > 1;
    }

    private boolean survivalPlaceBlocks(EntityPlayerMP player, @Nonnull ItemStack heldItem, Block block, int blockMeta, EnumFacing side, float hitX, float hitY, float hitZ) {
        for (BlockPos relCoord : this.getShapeSafe().getCoords()) {
            EnumActionResult placeResult;
            BlockPos absPos = this.field_174879_c.func_177971_a((Vec3i)relCoord);
            if (!this.field_145850_b.func_175667_e(absPos) || !this.field_145850_b.func_175623_d(absPos) || absPos.func_177956_o() < 0 || absPos.func_177956_o() >= 256 || (placeResult = player.field_71134_c.func_187251_a((EntityPlayer)player, this.field_145850_b, heldItem, EnumHand.MAIN_HAND, absPos, side, hitX, hitY, hitZ)) != EnumActionResult.SUCCESS) continue;
            int stateId = Block.func_176210_f((IBlockState)this.field_145850_b.func_180495_p(absPos));
            ((IGuideAnimationTrigger)this.createServerRpcProxy(IGuideAnimationTrigger.class, new Class[0])).trigger(absPos, stateId);
            return true;
        }
        return false;
    }

    private boolean isInFillMode() {
        return this.field_145850_b.func_180495_p(this.field_174879_c.func_177984_a()).func_177230_c() == Blocks.field_150343_Z;
    }

    public float getTicks() {
        return this.ticks;
    }

    @Override
    public void trigger(BlockPos pos, int stateId) {
        GeometryUtils.line3D((Vec3i)this.field_174879_c, (Vec3i)pos, (x, y, z) -> {
            double dx = (double)x + 0.5;
            double dy = (double)y + 0.5;
            double dz = (double)z + 0.5;
            for (int i = 0; i < 5; ++i) {
                double px = dx + 0.3 * (double)RANDOM.nextFloat();
                double py = dy + 0.3 * (double)RANDOM.nextFloat();
                double pz = dz + 0.3 * (double)RANDOM.nextFloat();
                this.field_145850_b.func_175688_a(EnumParticleTypes.PORTAL, px, py, pz, 0.0, 0.0, 0.0, new int[0]);
                this.field_145850_b.func_175688_a(EnumParticleTypes.BLOCK_DUST, px, py, pz, 0.0, 0.0, 0.0, new int[]{stateId});
            }
        });
    }
}

