/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.item;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import openblocks.OpenBlocks;
import openmods.colors.ColorMeta;
import openmods.item.ItemOpenBlock;
import openmods.utils.ItemUtils;

public class ItemPaintCan
extends ItemOpenBlock {
    public static final String TAG_AMOUNT = "amount";
    public static final String TAG_COLOR = "color";
    public static final int FULL_CAN_SIZE = 30;
    private static final int COLOR_WHITE = 0xFFFFFF;

    public ItemPaintCan(Block block) {
        super(block);
        this.func_77656_e(30);
        this.func_77625_d(1);
    }

    public static int getColorFromStack(@Nonnull ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        return tag != null ? tag.func_74762_e(TAG_COLOR) : 0xFFFFFF;
    }

    public static int getAmountFromStack(@Nonnull ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        return tag != null ? tag.func_74762_e(TAG_AMOUNT) : 0;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> result) {
        if (this.func_194125_a(tab)) {
            for (ColorMeta meta : ColorMeta.getAllColors()) {
                result.add((Object)ItemPaintCan.createStack(meta.rgb, 30));
            }
        }
    }

    @Nonnull
    public static ItemStack createStack(int color, int amount) {
        ItemStack stack = new ItemStack(OpenBlocks.Blocks.paintCan);
        ItemPaintCan.setColorAndAmount(stack, color, amount);
        return stack;
    }

    public static void setColorAndAmount(ItemStack stack, int color, int amount) {
        NBTTagCompound tag = ItemUtils.getItemTag((ItemStack)stack);
        tag.func_74768_a(TAG_COLOR, color);
        tag.func_74768_a(TAG_AMOUNT, amount);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(@Nonnull ItemStack stack, @Nullable World world, List<String> result, ITooltipFlag flag) {
        result.add(String.format("#%06X", ItemPaintCan.getColorFromStack(stack)));
    }

    public int getDamage(@Nonnull ItemStack stack) {
        return 30 - ItemPaintCan.getAmountFromStack(stack);
    }

    public double getDurabilityForDisplay(@Nonnull ItemStack stack) {
        return 1.0 - (double)ItemPaintCan.getAmountFromStack(stack) / 30.0;
    }

    public boolean isDamaged(@Nonnull ItemStack stack) {
        return stack.func_77942_o() && ItemPaintCan.getAmountFromStack(stack) < 30;
    }

    @SideOnly(value=Side.CLIENT)
    public static class ItemColorHandler
    implements IItemColor {
        public int func_186726_a(@Nonnull ItemStack stack, int tintIndex) {
            return tintIndex == 1 ? ItemPaintCan.getColorFromStack(stack) : 0xFFFFFF;
        }
    }
}

