/*
 * Decompiled with CFR 0.152.
 */
package openblocks.client;

import net.minecraft.block.Block;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.item.Item;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import openblocks.OpenBlocks;
import openblocks.common.block.BlockCanvas;
import openblocks.common.block.BlockElevator;
import openblocks.common.block.BlockFlag;
import openblocks.common.block.BlockPaintCan;
import openblocks.common.block.BlockPaintMixer;
import openblocks.common.item.ItemDevNull;
import openblocks.common.item.ItemElevator;
import openblocks.common.item.ItemFlagBlock;
import openblocks.common.item.ItemGlyph;
import openblocks.common.item.ItemImaginary;
import openblocks.common.item.ItemImaginationGlasses;
import openblocks.common.item.ItemPaintBrush;
import openblocks.common.item.ItemPaintCan;
import openblocks.common.item.ItemTankBlock;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public class BlockColorHandlerRegistration {
    @SubscribeEvent
    public static void registerItemColormHandlers(ColorHandlerEvent.Item evt) {
        ItemColors itemColors = evt.getItemColors();
        BlockColors blockColors = evt.getBlockColors();
        if (OpenBlocks.Items.paintBrush != null) {
            itemColors.func_186730_a((IItemColor)new ItemPaintBrush.ColorHandler(), new Item[]{OpenBlocks.Items.paintBrush});
        }
        if (OpenBlocks.Items.crayonGlasses != null) {
            itemColors.func_186730_a((IItemColor)new ItemImaginationGlasses.CrayonColorHandler(), new Item[]{OpenBlocks.Items.crayonGlasses});
        }
        if (OpenBlocks.Blocks.paintCan != null) {
            itemColors.func_186731_a((IItemColor)new ItemPaintCan.ItemColorHandler(), new Block[]{OpenBlocks.Blocks.paintCan});
            blockColors.func_186722_a((IBlockColor)new BlockPaintCan.BlockColorHandler(), new Block[]{OpenBlocks.Blocks.paintCan});
        }
        if (OpenBlocks.Blocks.imaginary != null) {
            itemColors.func_186731_a((IItemColor)new ItemImaginary.CrayonColorHandler(), new Block[]{OpenBlocks.Blocks.imaginary});
        }
        if (OpenBlocks.Items.devNull != null) {
            itemColors.func_186730_a((IItemColor)new ItemDevNull.NestedItemColorHandler(itemColors), new Item[]{OpenBlocks.Items.devNull});
        }
        if (OpenBlocks.Blocks.elevator != null) {
            blockColors.func_186722_a((IBlockColor)new BlockElevator.BlockColorHandler(), new Block[]{OpenBlocks.Blocks.elevator});
            itemColors.func_186731_a((IItemColor)new ItemElevator.ItemColorHandler(), new Block[]{OpenBlocks.Blocks.elevator});
        }
        if (OpenBlocks.Blocks.elevatorRotating != null) {
            blockColors.func_186722_a((IBlockColor)new BlockElevator.BlockColorHandler(), new Block[]{OpenBlocks.Blocks.elevatorRotating});
            itemColors.func_186731_a((IItemColor)new ItemElevator.ItemColorHandler(), new Block[]{OpenBlocks.Blocks.elevatorRotating});
        }
        if (OpenBlocks.Blocks.flag != null) {
            itemColors.func_186731_a((IItemColor)new ItemFlagBlock.ItemColorHandler(), new Block[]{OpenBlocks.Blocks.flag});
            blockColors.func_186722_a((IBlockColor)new BlockFlag.BlockColorHandler(), new Block[]{OpenBlocks.Blocks.flag});
        }
        if (OpenBlocks.Items.glyph != null) {
            itemColors.func_186730_a((IItemColor)new ItemGlyph.ColorHandler(), new Item[]{OpenBlocks.Items.glyph});
        }
        if (OpenBlocks.Blocks.tank != null) {
            itemColors.func_186731_a((IItemColor)new ItemTankBlock.ColorHandler(), new Block[]{OpenBlocks.Blocks.tank});
        }
    }

    @SubscribeEvent
    public static void registerBlockHandler(ColorHandlerEvent.Block evt) {
        BlockColors blockColors = evt.getBlockColors();
        if (OpenBlocks.Blocks.canvas != null) {
            blockColors.func_186722_a((IBlockColor)new BlockCanvas.InnerBlockColorHandler(blockColors), new Block[]{OpenBlocks.Blocks.canvas});
        }
        if (OpenBlocks.Blocks.paintMixer != null) {
            blockColors.func_186722_a((IBlockColor)new BlockPaintMixer.BlockColorHandler(), new Block[]{OpenBlocks.Blocks.paintMixer});
        }
    }
}

