/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.util;

import java.util.Arrays;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class GuiUtils {
    private static final ResourceLocation[] MODULE_TEXTURES = new ResourceLocation[]{new ResourceLocation("securitycraft", "textures/items/module_background.png"), new ResourceLocation("securitycraft", "textures/items/whitelist_module.png"), new ResourceLocation("securitycraft", "textures/items/blacklist_module.png"), new ResourceLocation("securitycraft", "textures/items/harming_module.png"), new ResourceLocation("securitycraft", "textures/items/smart_module.png"), new ResourceLocation("securitycraft", "textures/items/storage_module.png"), new ResourceLocation("securitycraft", "textures/items/disguise_module.png"), new ResourceLocation("securitycraft", "textures/items/module_background.png")};
    private static final ResourceLocation REDSTONE_TEXTURE = new ResourceLocation("textures/items/redstone_dust.png");
    private static final ResourceLocation SUGAR_TEXTURE = new ResourceLocation("textures/items/sugar.png");

    private GuiUtils() {
    }

    public static void drawItemStackToGui(ItemStack stack, int x, int y, boolean fixLighting) {
        Minecraft mc = Minecraft.func_71410_x();
        RenderItem renderItem = mc.func_175599_af();
        if (fixLighting) {
            GlStateManager.func_179145_e();
        }
        RenderHelper.func_74520_c();
        GlStateManager.func_179091_B();
        renderItem.func_180450_b(stack, x, y);
        renderItem.func_175030_a(mc.field_71466_p, stack, x, y);
        GlStateManager.func_179140_f();
        GlStateManager.func_179101_C();
    }

    public static void renderModuleInfo(ModuleType module, String moduleTooltip, boolean isModuleInstalled, int moduleLeft, int moduleTop, int screenWidth, int screenHeight, int mouseX, int mouseY) {
        Minecraft mc = Minecraft.func_71410_x();
        float alpha = isModuleInstalled ? 1.0f : 0.5f;
        int moduleRight = moduleLeft + 16;
        int moduleBottom = moduleTop + 16;
        GlStateManager.func_179140_f();
        GlStateManager.func_179141_d();
        GlStateManager.func_179147_l();
        mc.func_110434_K().func_110577_a(MODULE_TEXTURES[module.ordinal()]);
        GuiUtils.drawTexture(Tessellator.func_178181_a(), moduleLeft, moduleTop, moduleRight, moduleBottom, alpha);
        if (module == ModuleType.REDSTONE) {
            mc.func_110434_K().func_110577_a(REDSTONE_TEXTURE);
            GuiUtils.drawTexture(Tessellator.func_178181_a(), moduleLeft, moduleTop, moduleRight, moduleBottom, alpha);
        } else if (module == ModuleType.SPEED) {
            mc.func_110434_K().func_110577_a(SUGAR_TEXTURE);
            GuiUtils.drawTexture(Tessellator.func_178181_a(), moduleLeft, moduleTop, moduleRight, moduleBottom, alpha);
        }
        if (moduleTooltip != null && !moduleTooltip.isEmpty() && mouseX >= moduleLeft && mouseX < moduleRight && mouseY >= moduleTop && mouseY <= moduleBottom) {
            net.minecraftforge.fml.client.config.GuiUtils.drawHoveringText(Arrays.asList(moduleTooltip), (int)mouseX, (int)mouseY, (int)screenWidth, (int)screenHeight, (int)-1, (FontRenderer)mc.field_71466_p);
            RenderHelper.func_74518_a();
        }
        GlStateManager.func_179084_k();
        GlStateManager.func_179118_c();
        GlStateManager.func_179145_e();
    }

    private static void drawTexture(Tessellator tess, int moduleLeft, int moduleTop, int moduleRight, int moduleBottom, float alpha) {
        BufferBuilder bufferBuilder = tess.func_178180_c();
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        bufferBuilder.func_181662_b((double)moduleLeft, (double)moduleBottom, 0.0).func_187315_a(0.0, 1.0).func_181666_a(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
        bufferBuilder.func_181662_b((double)moduleRight, (double)moduleBottom, 0.0).func_187315_a(1.0, 1.0).func_181666_a(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
        bufferBuilder.func_181662_b((double)moduleRight, (double)moduleTop, 0.0).func_187315_a(1.0, 0.0).func_181666_a(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
        bufferBuilder.func_181662_b((double)moduleLeft, (double)moduleTop, 0.0).func_187315_a(0.0, 0.0).func_181666_a(1.0f, 1.0f, 1.0f, alpha).func_181675_d();
        tess.func_78381_a();
    }
}

