/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import io.netty.buffer.ByteBuf;
import net.geforcemods.securitycraft.blockentities.SecureRedstoneInterfaceBlockEntity;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class SyncSecureRedstoneInterface
implements IMessage {
    private BlockPos pos;
    private boolean sender;
    private boolean protectedSignal;
    private int frequency;
    private boolean sendExactPower;
    private boolean receiveInvertedPower;
    private int senderRange;
    private boolean highlightConnections;

    public SyncSecureRedstoneInterface() {
    }

    public SyncSecureRedstoneInterface(BlockPos pos, boolean sender, boolean protectedSignal, int frequency, boolean sendExactPower, boolean receiveInvertedPower, int senderRange, boolean highlightConnections) {
        this.pos = pos;
        this.sender = sender;
        this.protectedSignal = protectedSignal;
        this.frequency = frequency;
        this.sendExactPower = sendExactPower;
        this.receiveInvertedPower = receiveInvertedPower;
        this.senderRange = senderRange;
        this.highlightConnections = highlightConnections;
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = BlockPos.func_177969_a((long)buf.readLong());
        this.sender = buf.readBoolean();
        this.protectedSignal = buf.readBoolean();
        this.frequency = ByteBufUtils.readVarInt((ByteBuf)buf, (int)5);
        this.sendExactPower = buf.readBoolean();
        this.receiveInvertedPower = buf.readBoolean();
        this.senderRange = ByteBufUtils.readVarInt((ByteBuf)buf, (int)5);
        this.highlightConnections = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.pos.func_177986_g());
        buf.writeBoolean(this.sender);
        buf.writeBoolean(this.protectedSignal);
        ByteBufUtils.writeVarInt((ByteBuf)buf, (int)this.frequency, (int)5);
        buf.writeBoolean(this.sendExactPower);
        buf.writeBoolean(this.receiveInvertedPower);
        ByteBufUtils.writeVarInt((ByteBuf)buf, (int)this.senderRange, (int)5);
        buf.writeBoolean(this.highlightConnections);
    }

    public static class Handler
    implements IMessageHandler<SyncSecureRedstoneInterface, IMessage> {
        public IMessage onMessage(SyncSecureRedstoneInterface message, MessageContext ctx) {
            Utils.addScheduledTask(ctx.getServerHandler().field_147369_b.field_70170_p, () -> {
                EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                World level = player.field_70170_p;
                TileEntity te = level.func_175625_s(message.pos);
                if (!player.func_175149_v() && te instanceof SecureRedstoneInterfaceBlockEntity) {
                    SecureRedstoneInterfaceBlockEntity be = (SecureRedstoneInterfaceBlockEntity)te;
                    if (!be.isOwnedBy((Entity)player)) {
                        return;
                    }
                    if (message.sender != be.isSender()) {
                        be.setSender(message.sender);
                    }
                    if (message.protectedSignal != be.isProtectedSignal()) {
                        be.setProtectedSignal(message.protectedSignal);
                    }
                    if (message.frequency != be.getFrequency()) {
                        be.setFrequency(message.frequency);
                    }
                    if (message.sendExactPower != be.sendsExactPower()) {
                        be.setSendExactPower(message.sendExactPower);
                    }
                    if (message.receiveInvertedPower != be.receivesInvertedPower()) {
                        be.setReceiveInvertedPower(message.receiveInvertedPower);
                    }
                    if (message.senderRange != be.getSenderRange()) {
                        be.setSenderRange(message.senderRange);
                    }
                    be.setHighlightConnections(message.highlightConnections);
                }
            });
            return null;
        }
    }
}

