/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import io.netty.buffer.ByteBuf;
import net.geforcemods.securitycraft.blockentities.BlockChangeDetectorBlockEntity;
import net.geforcemods.securitycraft.blocks.BlockChangeDetectorBlock;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class ClearChangeDetectorServer
implements IMessage {
    private BlockPos pos;

    public ClearChangeDetectorServer() {
    }

    public ClearChangeDetectorServer(BlockPos pos) {
        this.pos = pos;
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = BlockPos.func_177969_a((long)buf.readLong());
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.pos.func_177986_g());
    }

    public static class Handler
    implements IMessageHandler<ClearChangeDetectorServer, IMessage> {
        public IMessage onMessage(ClearChangeDetectorServer message, MessageContext ctx) {
            Utils.addScheduledTask(ctx.getServerHandler().field_147369_b.field_70170_p, () -> {
                BlockChangeDetectorBlockEntity te;
                EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                World level = player.field_70170_p;
                BlockPos pos = message.pos;
                TileEntity tile = level.func_175625_s(pos);
                if (!player.func_175149_v() && tile instanceof BlockChangeDetectorBlockEntity && (te = (BlockChangeDetectorBlockEntity)tile).isOwnedBy((Entity)player)) {
                    IBlockState state = level.func_180495_p(pos);
                    te.getEntries().clear();
                    te.func_70296_d();
                    te.sync();
                    if (((Boolean)state.func_177229_b((IProperty)BlockChangeDetectorBlock.POWERED)).booleanValue()) {
                        BlockChangeDetectorBlock block = (BlockChangeDetectorBlock)state.func_177230_c();
                        level.func_175656_a(pos, state.func_177226_a((IProperty)BlockChangeDetectorBlock.POWERED, (Comparable)Boolean.valueOf(false)));
                        BlockUtils.updateIndirectNeighbors(level, pos, (Block)block, block.getConnectedDirection(state).func_176734_d());
                    }
                }
            });
            return null;
        }
    }
}

